/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DatePart;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record7;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.PagingAndMultiSorting;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.QIteration;
import org.squashtest.tm.domain.campaign.QTestSuite;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.QTestPlanItem;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.domain.testautomation.QAutomatedTest;
import org.squashtest.tm.domain.testautomation.QTestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.execution.NotUniqueTechnologyForRepositoryException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomatedExecutionExtender;
import org.squashtest.tm.jooq.domain.tables.AutomatedSuite;
import org.squashtest.tm.service.internal.dto.AutomatedSuiteDto;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.NestedEntityGraphQueryBuilder;
import org.squashtest.tm.service.testautomation.AutomationDeletionCount;
import org.squashtest.tm.service.testautomation.model.AutomatedSuitePreview;

@Repository
public class HibernateAutomatedSuiteDao
implements AutomatedSuiteDao {
    private static final String AUTOMATED_SUITE_COUNT_STATUS = "automatedSuite.countStatuses";
    private static final String ID = "id";
    private static final String UNCHECKED = "unchecked";
    private static final String CREATED_ON = "CREATED_ON";
    private static final String CREATED_BY = "CREATED_BY";
    private static final String EXECUTION_STATUS = "EXECUTION_STATUS";
    private static final String LAST_MODIFIED_ON = "LAST_MODIFIED_ON";
    private static final String LAST_MODIFIED_BY = "LAST_MODIFIED_BY";
    private static final String SUITE_ID = "SUITE_ID";
    private static final String SUITE_ID_PARAM = "suiteId";
    private static final String REPOSITORY = "REPOSITORY";
    private static final String ATTACHMENT_LIST_ID = "ATTACHMENT_LIST_ID";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext dslContext;

    @Override
    public org.squashtest.tm.domain.testautomation.AutomatedSuite load(Long newSuiteId) {
        return (org.squashtest.tm.domain.testautomation.AutomatedSuite)this.em.createQuery("select a from AutomatedSuite a\nleft join fetch a.iteration\nleft join fetch a.testSuite\nwhere a.id = :id", org.squashtest.tm.domain.testautomation.AutomatedSuite.class).setParameter(ID, (Object)newSuiteId).getSingleResult();
    }

    @Override
    public org.squashtest.tm.domain.testautomation.AutomatedSuite save(org.squashtest.tm.domain.testautomation.AutomatedSuite suite) {
        if (suite.getId() == null) {
            this.em.persist((Object)suite);
            return suite;
        }
        return (org.squashtest.tm.domain.testautomation.AutomatedSuite)this.em.merge((Object)suite);
    }

    @Override
    public void delete(Long id) {
        org.squashtest.tm.domain.testautomation.AutomatedSuite suite = this.findById(id);
        this.em.remove((Object)suite);
    }

    @Override
    public void delete(org.squashtest.tm.domain.testautomation.AutomatedSuite suite) {
        this.em.remove((Object)suite);
    }

    @Override
    public org.squashtest.tm.domain.testautomation.AutomatedSuite createNewSuite() {
        org.squashtest.tm.domain.testautomation.AutomatedSuite suite = new org.squashtest.tm.domain.testautomation.AutomatedSuite();
        this.em.persist((Object)suite);
        return suite;
    }

    @Override
    public org.squashtest.tm.domain.testautomation.AutomatedSuite createNewSuite(Iteration iteration) {
        org.squashtest.tm.domain.testautomation.AutomatedSuite suite = new org.squashtest.tm.domain.testautomation.AutomatedSuite(iteration);
        this.em.persist((Object)suite);
        return suite;
    }

    @Override
    public org.squashtest.tm.domain.testautomation.AutomatedSuite createNewSuite(TestSuite testSuite) {
        org.squashtest.tm.domain.testautomation.AutomatedSuite suite = new org.squashtest.tm.domain.testautomation.AutomatedSuite(testSuite);
        this.em.persist((Object)suite);
        return suite;
    }

    @Override
    public org.squashtest.tm.domain.testautomation.AutomatedSuite findById(Long id) {
        return (org.squashtest.tm.domain.testautomation.AutomatedSuite)this.em.getReference(org.squashtest.tm.domain.testautomation.AutomatedSuite.class, (Object)id);
    }

    @Override
    public Optional<org.squashtest.tm.domain.testautomation.AutomatedSuite> findByUuid(String targetUUID) {
        return this.em.createQuery("SELECT suite FROM AutomatedSuite suite WHERE suite.uuid = :uuid", org.squashtest.tm.domain.testautomation.AutomatedSuite.class).setParameter("uuid", (Object)targetUUID).setMaxResults(1).getResultList().stream().findFirst();
    }

    @Override
    public List<org.squashtest.tm.domain.testautomation.AutomatedSuite> findAll() {
        Query query = this.em.createNamedQuery("automatedSuite.findAll");
        return query.getResultList();
    }

    @Override
    public List<org.squashtest.tm.domain.testautomation.AutomatedSuite> findAllByIds(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        Query query = this.em.createNamedQuery("automatedSuite.findAllById");
        query.setParameter("suiteIds", ids);
        return query.getResultList();
    }

    @Override
    public Collection<org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender> findAllExtenders(Long suiteId) {
        Query query = this.em.createNamedQuery("automatedSuite.findAllExtenders");
        query.setParameter(SUITE_ID_PARAM, (Object)suiteId);
        return query.getResultList();
    }

    @Override
    public Collection<org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender> findAllWaitingExtenders(Long suiteId) {
        return this.findAllExtendersByStatus(suiteId, ExecutionStatus.READY);
    }

    @Override
    public Collection<org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender> findAllRunningExtenders(Long suiteId) {
        return this.findAllExtendersByStatus(suiteId, ExecutionStatus.RUNNING);
    }

    @Override
    public Collection<org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender> findAllCompletedExtenders(Long suiteId) {
        return this.findAllExtendersByStatus(suiteId, ExecutionStatus.getTerminatedStatusSet());
    }

    @Override
    public Collection<org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender> findAllExtendersByStatus(Long suiteId, Collection<ExecutionStatus> statusList) {
        Query query = this.em.createNamedQuery("automatedSuite.findAllExtendersHavingStatus");
        query.setParameter(SUITE_ID_PARAM, (Object)suiteId);
        query.setParameter("statusList", statusList);
        return query.getResultList();
    }

    @Override
    public List<org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender> findAndFetchForAutomatedExecutionCreation(Long suiteId) {
        List extenders = this.em.createQuery("select ext from AutomatedExecutionExtender ext\njoin fetch ext.execution ex\njoin fetch ex.attachmentList\njoin fetch ex.issueList\nwhere ext.automatedSuite.id = :id", org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender.class).setParameter(ID, (Object)suiteId).getResultList();
        this.loadExtenderAttributes(extenders);
        return extenders;
    }

    private void loadExtenderAttributes(List<org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender> extenders) {
        Set iterationTestPlanIds = extenders.stream().map(extender -> extender.getTestPlanItem().getId()).collect(Collectors.toSet());
        new NestedEntityGraphQueryBuilder<TestPlanItem>(this.em, TestPlanItem.class, "SELECT DISTINCT itpi FROM TestPlanItem itpi WHERE itpi.id IN :ids ORDER BY itpi.id", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.sub("testPlan", NestedEntityGraphQueryBuilder.GraphDefinition.sub("parentIteration", NestedEntityGraphQueryBuilder.GraphDefinition.attr("campaign"))), NestedEntityGraphQueryBuilder.GraphDefinition.attr("referencedTestCase"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("exploratorySessionOverview"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("referencedDataset"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("testSuites"))).executeDistinctList(Map.of("ids", iterationTestPlanIds));
        Set testCaseIds = extenders.stream().filter(extender -> extender.getTestPlanItem().getReferencedTestCase() != null).map(extender -> extender.getTestPlanItem().getReferencedTestCase().getId()).collect(Collectors.toSet());
        new EntityGraphQueryBuilder<TestCase>(this.em, TestCase.class, "SELECT DISTINCT tc FROM TestCase tc WHERE tc.id IN :ids").addAttributeNodes("automatedTest", "nature", "parameters", "automationRequest").addSubGraph("nature", "infoList").executeDistinctList(Map.of("ids", testCaseIds));
    }

    @Override
    public List<AutomatedSuiteDto> findAutomatedSuitesByIterationID(Long iterationId, PagingAndMultiSorting paging, ColumnFiltering filter) {
        int offset = paging.getFirstItemIndex();
        int limit = paging.getPageSize();
        return this.getSelectFields().from((TableLike)Tables.AUTOMATED_SUITE).innerJoin((TableLike)Tables.ITERATION).on(Tables.AUTOMATED_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId)).union((Select)this.getSelectFields().from((TableLike)Tables.AUTOMATED_SUITE).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.AUTOMATED_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).innerJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId))).union((Select)this.getSelectFields().from((TableLike)Tables.AUTOMATED_SUITE).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_SUITE.SUITE_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId))).orderBy((OrderField)DSL.field((String)CREATED_ON).desc()).offset((Number)offset).limit((Number)limit).fetchInto(AutomatedSuiteDto.class);
    }

    @Override
    public List<AutomatedSuiteDto> findAutomatedSuitesByTestSuiteID(Long suiteId, PagingAndMultiSorting paging, ColumnFiltering filter) {
        int offset = paging.getFirstItemIndex();
        int limit = paging.getPageSize();
        return this.getSelectFields().from((TableLike)Tables.AUTOMATED_SUITE).where(Tables.AUTOMATED_SUITE.TEST_SUITE_ID.eq((Object)suiteId)).union((Select)this.getSelectFields().from((TableLike)Tables.AUTOMATED_SUITE).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_SUITE.SUITE_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).where(Tables.TEST_SUITE.ID.eq((Object)suiteId))).orderBy((OrderField)DSL.field((String)CREATED_ON).desc()).offset((Number)offset).limit((Number)limit).fetchInto(AutomatedSuiteDto.class);
    }

    private SelectSelectStep<Record7<Timestamp, String, String, Timestamp, String, Long, Long>> getSelectFields() {
        return this.dslContext.select((SelectField)AutomatedSuite.AUTOMATED_SUITE.CREATED_ON.as(CREATED_ON), (SelectField)AutomatedSuite.AUTOMATED_SUITE.CREATED_BY.as(CREATED_BY), (SelectField)AutomatedSuite.AUTOMATED_SUITE.EXECUTION_STATUS.as(EXECUTION_STATUS), (SelectField)AutomatedSuite.AUTOMATED_SUITE.LAST_MODIFIED_ON.as(LAST_MODIFIED_ON), (SelectField)AutomatedSuite.AUTOMATED_SUITE.LAST_MODIFIED_BY.as(LAST_MODIFIED_BY), (SelectField)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.as(SUITE_ID), (SelectField)AutomatedSuite.AUTOMATED_SUITE.ATTACHMENT_LIST_ID.as(ATTACHMENT_LIST_ID));
    }

    @Override
    public long countSuitesByIterationId(Long iterationId, ColumnFiltering filter) {
        return this.dslContext.select((SelectField)Tables.AUTOMATED_SUITE.SUITE_ID).from((TableLike)Tables.AUTOMATED_SUITE).innerJoin((TableLike)Tables.ITERATION).on(Tables.AUTOMATED_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId)).union((Select)this.dslContext.select((SelectField)Tables.AUTOMATED_SUITE.SUITE_ID).from((TableLike)Tables.AUTOMATED_SUITE).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.AUTOMATED_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).innerJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId))).union((Select)this.dslContext.select((SelectField)Tables.AUTOMATED_SUITE.SUITE_ID).from((TableLike)Tables.AUTOMATED_SUITE).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_SUITE.SUITE_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId))).fetch().stream().count();
    }

    @Override
    public long countSuitesByTestSuiteId(Long suiteId, ColumnFiltering filter) {
        return this.dslContext.select((SelectField)Tables.AUTOMATED_SUITE.SUITE_ID).from((TableLike)Tables.AUTOMATED_SUITE).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.AUTOMATED_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).where(Tables.TEST_SUITE.ID.eq((Object)suiteId)).union((Select)this.dslContext.select((SelectField)Tables.AUTOMATED_SUITE.SUITE_ID).from((TableLike)Tables.AUTOMATED_SUITE).innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_SUITE.SUITE_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).where(Tables.TEST_SUITE.ID.eq((Object)suiteId))).fetch().stream().count();
    }

    @Override
    public ExecutionStatusReport getStatusReport(Long id) {
        ExecutionStatusReport report = new ExecutionStatusReport();
        TypedQuery query = this.em.createNamedQuery(AUTOMATED_SUITE_COUNT_STATUS, Object[].class);
        query.setParameter(ID, (Object)id);
        List tuples = query.getResultList();
        for (Object[] tuple : tuples) {
            report.set(((ExecutionStatus)tuple[0]).getCanonicalStatus(), ((Long)tuple[1]).intValue());
        }
        return report;
    }

    private Collection<org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender> findAllExtendersByStatus(Long suiteId, ExecutionStatus ... statusArray) {
        List<ExecutionStatus> statusList = Arrays.asList(statusArray);
        return this.findAllExtendersByStatus(suiteId, statusList);
    }

    @Override
    public List<Couple<TestAutomationProject, Long>> findAllCalledByTestPlan(EntityReference context, Collection<Long> testPlanSubset, Long userId) {
        JPAQuery query = this.createBaseTestplanQueryFromSpec(context, testPlanSubset, userId);
        query = query.select((Expression)Projections.constructor(Couple.class, (Expression[])new Expression[]{QTestAutomationProject.testAutomationProject, QTestPlanItem.testPlanItem.count().as("itemCount")}));
        query = (JPAQuery)((JPAQuery)query.groupBy((Expression)QTestAutomationProject.testAutomationProject)).orderBy(QTestAutomationProject.testAutomationProject.label.asc());
        return query.fetch();
    }

    @Override
    public List<String> findTestPathForAutomatedSuiteAndProject(EntityReference context, Collection<Long> testPlanSubset, long automationProjectId, Long userId) {
        JPAQuery query = this.createBaseTestplanQueryFromSpec(context, testPlanSubset, userId);
        query = query.select((Expression)QTestAutomationProject.testAutomationProject.label.concat("/").concat((Expression)QAutomatedTest.automatedTest.name).as("path"));
        query = (JPAQuery)query.where((Predicate)QTestAutomationProject.testAutomationProject.id.eq((Object)automationProjectId));
        query.orderBy(QAutomatedTest.automatedTest.name.asc());
        return query.fetch();
    }

    private <T> JPAQuery<T> createBaseTestplanQueryFromSpec(EntityReference context, Collection<Long> testPlanSubset, Long userId) {
        this.assertContextIsValid(context);
        EntityType type = context.getType();
        Long id = context.getId();
        JPAQueryFactory factory = new JPAQueryFactory(this.em);
        JPAQuery query = null;
        if (type == EntityType.ITERATION) {
            query = (JPAQuery)((JPAQuery)factory.from((EntityPath)QIteration.iteration).innerJoin((CollectionExpression)QIteration.iteration.testPlan.testPlanItems, (Path)QTestPlanItem.testPlanItem)).where((Predicate)QIteration.iteration.id.eq((Object)id));
            if (Objects.nonNull(userId)) {
                query = (JPAQuery)query.where((Predicate)QTestPlanItem.testPlanItem.assignee.id.eq((Object)userId));
            }
        } else {
            query = (JPAQuery)((JPAQuery)factory.from((EntityPath)QTestSuite.testSuite).innerJoin((CollectionExpression)QTestSuite.testSuite.testPlanItems, (Path)QTestPlanItem.testPlanItem)).where((Predicate)QTestSuite.testSuite.id.eq((Object)id));
        }
        if (testPlanSubset != null && !testPlanSubset.isEmpty()) {
            query = (JPAQuery)query.where((Predicate)QTestPlanItem.testPlanItem.id.in(testPlanSubset));
        }
        query = (JPAQuery)((JPAQuery)((JPAQuery)query.innerJoin((EntityPath)QTestPlanItem.testPlanItem.referencedTestCase, (Path)QTestCase.testCase)).innerJoin((EntityPath)QTestCase.testCase.automatedTest, (Path)QAutomatedTest.automatedTest)).innerJoin((EntityPath)QAutomatedTest.automatedTest.project, (Path)QTestAutomationProject.testAutomationProject);
        return query;
    }

    private void assertContextIsValid(EntityReference context) {
        if (context == null || context.getType() == EntityType.ITERATION && context.getType() == EntityType.TEST_SUITE) {
            throw new IllegalArgumentException("invalid context : expected a reference to an Iteration or a TestSuite, but got " + String.valueOf(context));
        }
    }

    @Override
    public AutomationDeletionCount countOldAutomatedSuitesAndExecutions() {
        LocalDateTime todayLocalDateTime = LocalDateTime.now();
        Instant todayInstant = todayLocalDateTime.atZone(ZoneId.systemDefault()).toInstant();
        Timestamp todayTimestamp = Timestamp.from(todayInstant);
        return this.countOldAutomatedSuiteAndExecutionsByCondition(DSL.timestampAdd((Field)AutomatedSuite.AUTOMATED_SUITE.CREATED_ON, (Field)Tables.PROJECT.AUTOMATED_SUITES_LIFETIME, (DatePart)DatePart.DAY).lessThan((Object)todayTimestamp));
    }

    @Override
    public AutomationDeletionCount countOldAutomatedSuitesAndExecutionsByProjectId(Long projectId) {
        LocalDateTime todayLocalDateTime = LocalDateTime.now();
        Instant todayInstant = todayLocalDateTime.atZone(ZoneId.systemDefault()).toInstant();
        Timestamp todayTimestamp = Timestamp.from(todayInstant);
        return this.countOldAutomatedSuiteAndExecutionsByCondition(Tables.PROJECT.PROJECT_ID.eq((Object)projectId).and(DSL.timestampAdd((Field)AutomatedSuite.AUTOMATED_SUITE.CREATED_ON, (Field)Tables.PROJECT.AUTOMATED_SUITES_LIFETIME, (DatePart)DatePart.DAY).lessThan((Object)todayTimestamp)));
    }

    private AutomationDeletionCount countOldAutomatedSuiteAndExecutionsByCondition(Condition condition) {
        Condition iterationAndTestSuiteCondition = condition.and(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.isNull());
        Table countTable = this.countOldAutomatedSuitesAndExecutionsLinkedToExecutionsWhereCondition(condition).union(this.countOldAutomatedSuitesLinkedToIterationWhereCondition(iterationAndTestSuiteCondition)).union(this.countOldAutomatedSuitesLinkedToTestSuiteWhereCondition(iterationAndTestSuiteCondition)).asTable();
        return (AutomationDeletionCount)this.dslContext.select((SelectField)DSL.sum((Field)countTable.field("AUTOMATED_SUITE_COUNT", Integer.class)).as("OLD_AUTOMATED_SUITE_COUNT"), (SelectField)DSL.sum((Field)countTable.field("AUTOMATED_EXECUTION_COUNT", Integer.class)).as("OLD_AUTOMATED_EXECUTION_COUNT")).from((TableLike)countTable).fetchOneInto(AutomationDeletionCount.class);
    }

    private SelectConditionStep<Record2<Integer, Integer>> countOldAutomatedSuitesAndExecutionsLinkedToExecutionsWhereCondition(Condition condition) {
        return this.dslContext.select((SelectField)DSL.countDistinct((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID).as("AUTOMATED_SUITE_COUNT"), (SelectField)DSL.countDistinct((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID).as("AUTOMATED_EXECUTION_COUNT")).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).innerJoin((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CL_ID.eq((Field)Tables.TEST_PLAN.CL_ID)).where(condition);
    }

    private SelectConditionStep<Record2<Integer, Integer>> countOldAutomatedSuitesLinkedToIterationWhereCondition(Condition condition) {
        return this.dslContext.select((SelectField)DSL.countDistinct((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID), (SelectField)DSL.field((String)"0", Integer.class)).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).leftJoin((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(condition);
    }

    private SelectConditionStep<Record2<Integer, Integer>> countOldAutomatedSuitesLinkedToTestSuiteWhereCondition(Condition condition) {
        return this.dslContext.select((SelectField)DSL.countDistinct((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID), (SelectField)DSL.field((String)"0", Integer.class)).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).leftJoin((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.TEST_SUITE_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(condition);
    }

    @Override
    public List<Long> getOldAutomatedSuiteIds() {
        LocalDateTime todayLocalDateTime = LocalDateTime.now();
        Instant todayInstant = todayLocalDateTime.atZone(ZoneId.systemDefault()).toInstant();
        Timestamp todayTimestamp = Timestamp.from(todayInstant);
        return this.getOldAutomatedSuitesIdsByCondition(DSL.timestampAdd((Field)AutomatedSuite.AUTOMATED_SUITE.CREATED_ON, (Field)Tables.PROJECT.AUTOMATED_SUITES_LIFETIME, (DatePart)DatePart.DAY).lessThan((Object)todayTimestamp));
    }

    @Override
    public List<Long> getOldAutomatedSuiteIdsByProjectId(Long projectId) {
        LocalDateTime todayLocalDateTime = LocalDateTime.now();
        Instant todayInstant = todayLocalDateTime.atZone(ZoneId.systemDefault()).toInstant();
        Timestamp todayTimestamp = Timestamp.from(todayInstant);
        return this.getOldAutomatedSuitesIdsByCondition(Tables.PROJECT.PROJECT_ID.eq((Object)projectId).and(DSL.timestampAdd((Field)AutomatedSuite.AUTOMATED_SUITE.CREATED_ON, (Field)Tables.PROJECT.AUTOMATED_SUITES_LIFETIME, (DatePart)DatePart.DAY).lessThan((Object)todayTimestamp)));
    }

    private List<Long> getOldAutomatedSuitesIdsByCondition(Condition condition) {
        Condition iterationAndTestSuiteCondition = condition.and(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.isNull());
        return this.getOldAutomatedSuitesIdLinkedToExecutionWhereCondition(condition).union(this.getOldAutomatedSuitesIdLinkedToIterationWhereCondition(iterationAndTestSuiteCondition)).union(this.getOldAutomatedSuitesIdLinkedToTestSuiteWhereCondition(iterationAndTestSuiteCondition)).fetch((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID, Long.class);
    }

    private SelectConditionStep<Record1<Long>> getOldAutomatedSuitesIdLinkedToExecutionWhereCondition(Condition condition) {
        return this.dslContext.selectDistinct((SelectField)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).innerJoin((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CL_ID.eq((Field)Tables.TEST_PLAN.CL_ID)).where(condition);
    }

    private SelectConditionStep<Record1<Long>> getOldAutomatedSuitesIdLinkedToIterationWhereCondition(Condition condition) {
        return this.dslContext.selectDistinct((SelectField)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).leftJoin((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(condition);
    }

    private SelectConditionStep<Record1<Long>> getOldAutomatedSuitesIdLinkedToTestSuiteWhereCondition(Condition condition) {
        return this.dslContext.selectDistinct((SelectField)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).leftJoin((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.TEST_SUITE_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(condition);
    }

    @Override
    public void deleteAllByIds(List<Long> automatedSuiteIds) {
        if (automatedSuiteIds.isEmpty()) {
            return;
        }
        Query deleteQuery = this.em.createNamedQuery("AutomatedSuite.deleteAllByIds");
        deleteQuery.setParameter("automatedSuiteIds", automatedSuiteIds);
        deleteQuery.executeUpdate();
    }

    @Override
    public boolean itpiSelectionContainsSquashAutomTest(EntityReference context, List<Long> testPlanSubsetIds) {
        this.assertContextIsValid(context);
        EntityType contextType = context.getType();
        Long entityId = context.getId();
        boolean contextIsIteration = EntityType.ITERATION.equals((Object)contextType);
        SelectOnConditionStep queryWithCommonInnerJoins = DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID));
        SelectConditionStep queryWithWhereClause = contextIsIteration ? queryWithCommonInnerJoins.innerJoin((TableLike)Tables.ITERATION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)entityId)) : queryWithCommonInnerJoins.innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)entityId));
        SelectConditionStep<?> queryWithAndClauses = this.buildCommonWhereClauseOfSquashAutomQuery(queryWithWhereClause);
        SelectConditionStep<?> queryWithPotentialItemSubset = this.buildAndClauseOfSquashAutomQueryWithTestPlanSubset(testPlanSubsetIds, queryWithAndClauses);
        return this.dslContext.fetchExists(queryWithPotentialItemSubset);
    }

    @Override
    public Map<Long, AutomatedSuitePreview.SquashAutomProjectPreview> findAllSquashAutomProjectPreviews(EntityReference context, List<Long> testPlanSubsetIds, @Nullable Long userId) {
        this.assertContextIsValid(context);
        if (testPlanSubsetIds.size() != 1) {
            this.checkUniqueTechnologyInSameRepository(context, testPlanSubsetIds);
        }
        EntityType contextType = context.getType();
        Long entityId = context.getId();
        boolean contextIsIteration = EntityType.ITERATION.equals((Object)contextType);
        HashMap<Long, AutomatedSuitePreview.SquashAutomProjectPreview> automProjectPreviewsMap = new HashMap<Long, AutomatedSuitePreview.SquashAutomProjectPreview>();
        SelectOnConditionStep queryWithCommonInnerJoins = this.dslContext.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE, (SelectField)Tables.THIRD_PARTY_SERVER.SERVER_ID, (SelectField)Tables.THIRD_PARTY_SERVER.NAME, (SelectField)Tables.TEST_CASE.REFERENCE, (SelectField)Tables.TEST_PLAN_ITEM.ITEM_ORDER, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE.AUTOMATABLE, (SelectField)Tables.TEST_CASE.IMPORTANCE, (SelectField)Tables.AUTOMATION_REQUEST.REQUEST_STATUS, (SelectField)Tables.DATASET.NAME).from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID)).innerJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID));
        SelectConditionStep queryWithWhereClause = contextIsIteration ? queryWithCommonInnerJoins.innerJoin((TableLike)Tables.ITERATION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)entityId)).and(Objects.nonNull(userId) ? Tables.TEST_PLAN_ITEM.ASSIGNEE_ID.eq((Object)userId) : DSL.condition((Boolean)true)) : queryWithCommonInnerJoins.innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)entityId));
        SelectConditionStep<?> queryWithAndClauses = this.buildCommonWhereClauseOfSquashAutomQuery(queryWithWhereClause);
        SelectConditionStep<?> queryWithPotentialItemSubset = this.buildAndClauseOfSquashAutomQueryWithTestPlanSubset(testPlanSubsetIds, queryWithAndClauses);
        queryWithPotentialItemSubset.fetch().forEach(record -> {
            long projectId = (Long)record.get((Field)Tables.PROJECT.PROJECT_ID);
            AutomatedSuitePreview.SquashAutomProjectPreview automProjectPreview = (AutomatedSuitePreview.SquashAutomProjectPreview)automProjectPreviewsMap.get(projectId);
            if (Objects.isNull(automProjectPreview)) {
                automProjectPreview = new AutomatedSuitePreview.SquashAutomProjectPreview(projectId, (String)record.get((Field)Tables.PROJECT.NAME), (Long)record.get((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID), (String)record.get((Field)Tables.THIRD_PARTY_SERVER.NAME));
                automProjectPreviewsMap.put(projectId, automProjectPreview);
            }
            this.checkTestCaseIsAutomatedAndAddToAutomProjectPreview((Record)record, automProjectPreview);
        });
        return automProjectPreviewsMap;
    }

    @Override
    public List<Long> findAttachmentListIdsByIds(List<Long> automatedSuiteIds) {
        return this.dslContext.select((SelectField)AutomatedSuite.AUTOMATED_SUITE.ATTACHMENT_LIST_ID).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).where(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.in(automatedSuiteIds)).fetchInto(Long.class);
    }

    @Override
    public AutomatedSuiteWorkflow getAutomatedSuiteWorkflowByWorkflowId(String workflowId) {
        return (AutomatedSuiteWorkflow)this.dslContext.select((SelectField)Tables.AUTOMATED_SUITE_WORKFLOWS.WORKFLOW_ID, (SelectField)Tables.AUTOMATED_SUITE_WORKFLOWS.SUITE_ID, (SelectField)Tables.AUTOMATED_SUITE_WORKFLOWS.PROJECT_ID).from((TableLike)Tables.AUTOMATED_SUITE_WORKFLOWS).where(Tables.AUTOMATED_SUITE_WORKFLOWS.WORKFLOW_ID.eq((Object)workflowId)).fetchOneInto(AutomatedSuiteWorkflow.class);
    }

    @Override
    public Map<Long, List<AutomatedSuiteWorkflow>> getAutomatedSuiteWorkflowsBySuiteIds(List<Long> suiteIds) {
        return this.dslContext.select((SelectField)Tables.AUTOMATED_SUITE_WORKFLOWS.WORKFLOW_ID, (SelectField)Tables.AUTOMATED_SUITE_WORKFLOWS.SUITE_ID, (SelectField)Tables.AUTOMATED_SUITE_WORKFLOWS.PROJECT_ID).from((TableLike)Tables.AUTOMATED_SUITE_WORKFLOWS).where(Tables.AUTOMATED_SUITE_WORKFLOWS.SUITE_ID.in(suiteIds)).fetchGroups((Field)Tables.AUTOMATED_SUITE_WORKFLOWS.SUITE_ID, AutomatedSuiteWorkflow.class);
    }

    @Override
    public void deleteAutomatedSuiteWorkflowsBySuiteIds(List<Long> suiteIds) {
        this.dslContext.deleteFrom((Table)Tables.AUTOMATED_SUITE_WORKFLOWS).where(Tables.AUTOMATED_SUITE_WORKFLOWS.SUITE_ID.in(suiteIds)).execute();
    }

    @Override
    public Map<Long, Long> getAutomatedExecutionIdsWithAttachmentListIds(List<Long> automatedSuiteIds, boolean complete) {
        Condition baseCondition = AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.in(automatedSuiteIds);
        Condition condition = complete ? baseCondition : baseCondition.and(Tables.EXECUTION.EXECUTION_STATUS.eq((Object)ExecutionStatus.SUCCESS.name()));
        return this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_ID, (SelectField)Tables.EXECUTION.ATTACHMENT_LIST_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID)).where(condition).fetchMap((Field)Tables.EXECUTION.EXECUTION_ID, (Field)Tables.EXECUTION.ATTACHMENT_LIST_ID);
    }

    @Override
    public org.squashtest.tm.domain.testautomation.AutomatedSuite createNewSuiteWithLinkToTestSuite(TestSuite testSuite) {
        org.squashtest.tm.domain.testautomation.AutomatedSuite suite = new org.squashtest.tm.domain.testautomation.AutomatedSuite(testSuite);
        this.em.persist((Object)suite);
        return suite;
    }

    @Override
    public org.squashtest.tm.domain.testautomation.AutomatedSuite createNewSuiteWithLinkToIteration(Iteration iteration) {
        org.squashtest.tm.domain.testautomation.AutomatedSuite suite = new org.squashtest.tm.domain.testautomation.AutomatedSuite(iteration);
        this.em.persist((Object)suite);
        return suite;
    }

    private void checkTestCaseIsAutomatedAndAddToAutomProjectPreview(Record record, AutomatedSuitePreview.SquashAutomProjectPreview automProjectPreview) {
        if ("NONE".equalsIgnoreCase((String)record.get((Field)Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE)) || "Y".equals(record.get((Field)Tables.TEST_CASE.AUTOMATABLE)) && "AUTOMATED".equals(record.get((Field)Tables.AUTOMATION_REQUEST.REQUEST_STATUS))) {
            automProjectPreview.getTestCases().add(new AutomatedSuitePreview.TestCasePreviewInfo((String)record.get((Field)Tables.TEST_CASE.REFERENCE), (String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME), (String)record.get((Field)Tables.DATASET.NAME), (String)record.get((Field)Tables.TEST_CASE.IMPORTANCE), (Integer)record.get((Field)Tables.TEST_PLAN_ITEM.ITEM_ORDER)));
        }
    }

    private SelectConditionStep<?> buildCommonWhereClauseOfSquashAutomQuery(SelectConditionStep<?> queryWithWhereClause) {
        return queryWithWhereClause.and(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name())).and(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull()).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNotNull()).and(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull());
    }

    private SelectConditionStep<?> buildAndClauseOfSquashAutomQueryWithTestPlanSubset(List<Long> testPlanSubsetIds, SelectConditionStep<?> queryWithAndClauses) {
        if (Objects.nonNull(testPlanSubsetIds) && !testPlanSubsetIds.isEmpty()) {
            return queryWithAndClauses.and(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(testPlanSubsetIds));
        }
        return queryWithAndClauses;
    }

    private void checkUniqueTechnologyInSameRepository(EntityReference context, List<Long> testPlanSubset) {
        Table<?> subRequestTable = this.getSubRequestTable(context, testPlanSubset);
        List repositoryIdsWithMultipleTechnologies = this.dslContext.select((SelectField)subRequestTable.field(REPOSITORY)).from(subRequestTable).groupBy(new GroupField[]{subRequestTable.field(REPOSITORY)}).having(DSL.count().gt((Object)1)).fetchInto(Long.class);
        if (!repositoryIdsWithMultipleTechnologies.isEmpty()) {
            throw new NotUniqueTechnologyForRepositoryException();
        }
    }

    private Table<?> getSubRequestTable(EntityReference context, List<Long> testPlanSubset) {
        SelectSelectStep select = this.dslContext.select((SelectField)Tables.TEST_CASE.SCM_REPOSITORY_ID.as(REPOSITORY), (SelectField)Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.as("TECHNOLOGY"));
        SelectOnConditionStep from = select.from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID));
        this.addJoinAndWhereClauses(context, testPlanSubset, (SelectJoinStep<Record2<Long, Long>>)from);
        return from.groupBy(new GroupField[]{Tables.TEST_CASE.SCM_REPOSITORY_ID, Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY}).asTable();
    }

    private void addJoinAndWhereClauses(EntityReference context, List<Long> testPlanSubset, SelectJoinStep<Record2<Long, Long>> from) {
        Condition commonCondition = Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull().and(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name()));
        if (testPlanSubset.size() > 1) {
            from.where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(testPlanSubset).and(commonCondition));
        } else if (EntityType.ITERATION.equals((Object)context.getType())) {
            from.innerJoin((TableLike)Tables.ITERATION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)context.getId()).and(commonCondition));
        } else if (EntityType.TEST_SUITE.equals((Object)context.getType())) {
            from.innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)context.getId()).and(commonCondition));
        }
    }

    @Override
    public org.squashtest.tm.domain.testautomation.AutomatedSuite findByIdWithExtenders(Long suiteId) {
        return (org.squashtest.tm.domain.testautomation.AutomatedSuite)this.em.createQuery("select a from AutomatedSuite a left join fetch a.executionExtenders where a.id = :id", org.squashtest.tm.domain.testautomation.AutomatedSuite.class).setParameter(ID, (Object)suiteId).getSingleResult();
    }

    @Override
    public boolean isAutomatedSuiteCreatedByTestAutomationServerUser(Long automatedSuiteId) {
        return this.dslContext.fetchExists((Select)this.dslContext.select((SelectField)AutomatedSuite.AUTOMATED_SUITE.CREATED_BY).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).join((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.LOGIN.eq((Field)AutomatedSuite.AUTOMATED_SUITE.CREATED_BY)).join((TableLike)Tables.CORE_GROUP_MEMBER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.CORE_GROUP_MEMBER.PARTY_ID)).join((TableLike)Tables.CORE_GROUP).on(Tables.CORE_GROUP_MEMBER.GROUP_ID.eq((Field)Tables.CORE_GROUP.ID)).where(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Object)automatedSuiteId)).and(Tables.CORE_GROUP.QUALIFIED_NAME.eq((Object)"squashtest.authz.group.tm.TechnicalAccount")));
    }

    @Override
    public void deleteApiTokensMatchingSuiteIds(List<Long> automatedSuiteIds) {
        if (automatedSuiteIds == null || automatedSuiteIds.isEmpty()) {
            return;
        }
        this.dslContext.deleteFrom((Table)Tables.API_TOKEN).whereExists((Select)this.dslContext.selectOne().from((TableLike)AutomatedSuite.AUTOMATED_SUITE).where(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.in(automatedSuiteIds)).and((Condition)Tables.API_TOKEN.NAME.like(DSL.concat((Field[])new Field[]{DSL.val((String)"%-"), AutomatedSuite.AUTOMATED_SUITE.UUID, DSL.val((String)"-%")})))).execute();
    }

    @Override
    public Set<TestSuite> findTestSuitesByAutomatedSuiteIds(List<Long> automatedSuiteIds) {
        if (automatedSuiteIds == null || automatedSuiteIds.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<TestSuite>(this.em.createQuery("SELECT DISTINCT ats.testSuite FROM AutomatedSuite ats WHERE ats.id IN :ids", TestSuite.class).setParameter("ids", automatedSuiteIds).getResultList());
    }
}

