/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.profile;

import jakarta.persistence.EntityNotFoundException;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.profile.CannotDeleteProfileException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.internal.display.dto.NewProfileDto;
import org.squashtest.tm.service.internal.display.dto.ProfileActivePermissionsRecord;
import org.squashtest.tm.service.internal.repository.ProfileDao;
import org.squashtest.tm.service.profile.ProfileManagerService;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;

@Transactional
@Service
public class ProfileManagerServiceImpl
implements ProfileManagerService {
    private static final String PROFILE_WITH_ID = "Profile with id";
    private final ProfileDao profileDao;
    private final DSLContext dslContext;
    private final ObjectAclService aclService;
    private final AuditModificationService auditModificationService;

    public ProfileManagerServiceImpl(ProfileDao profileDao, DSLContext dslContext, ObjectAclService aclService, AuditModificationService auditModificationService) {
        this.profileDao = profileDao;
        this.dslContext = dslContext;
        this.aclService = aclService;
        this.auditModificationService = auditModificationService;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public long persist(NewProfileDto profileDto) {
        String profileName = profileDto.getQualifiedName();
        if (this.nameInUse(profileName)) {
            throw new NameAlreadyInUseException(AclGroup.class.getSimpleName(), profileName);
        }
        AclGroup newProfile = profileDto.toProfile();
        this.profileDao.save(newProfile);
        this.insertPermissionsFromReferenceProfile(newProfile.getId(), profileDto.getReferenceProfileId());
        return newProfile.getId();
    }

    private void insertPermissionsFromReferenceProfile(long profileId, long referenceProfileId) {
        this.dslContext.insertInto((Table)Tables.ACL_GROUP_PERMISSION, (Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID, (Field)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK, (Field)Tables.ACL_GROUP_PERMISSION.CLASS_ID).select((Select)this.dslContext.select((SelectField)DSL.val((long)profileId), (SelectField)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK, (SelectField)Tables.ACL_GROUP_PERMISSION.CLASS_ID).from((TableLike)Tables.ACL_GROUP_PERMISSION).where(Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID.eq((Object)referenceProfileId))).execute();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteProfile(long profileId) {
        AclGroup profileToDelete = (AclGroup)this.profileDao.findById(profileId).orElseThrow(() -> new EntityNotFoundException(String.format("%S %d %S", PROFILE_WITH_ID, profileId, "doesn't exist.")));
        profileToDelete.checkAndForbidOperationForDefaultSystemProfile();
        if (this.profileDao.isProfileUsed(profileId)) {
            throw new CannotDeleteProfileException();
        }
        this.dslContext.deleteFrom((Table)Tables.ACL_GROUP_PERMISSION).where(Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID.eq((Object)profileId)).execute();
        this.profileDao.delete(profileToDelete);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void changeDescription(long profileId, String newDescription) {
        AclGroup profile = this.findById(profileId);
        profile.setDescription(newDescription);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void changeName(long profileId, @NotNull String newName) {
        String string = newName;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string);
        AclGroup profile = this.findById(profileId);
        if (newName.equals(profile.getQualifiedName())) {
            return;
        }
        if (this.nameInUse(newName)) {
            throw new NameAlreadyInUseException(AclGroup.class.getSimpleName(), newName);
        }
        profile.setQualifiedName(newName);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deactivateProfile(long profileId) {
        AclGroup profile = this.findById(profileId);
        profile.setActive(false);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void activateProfile(long profileId) {
        AclGroup profile = this.findById(profileId);
        profile.setActive(true);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void changePermissions(long profileId, List<ProfileActivePermissionsRecord> profileActivePermissions) {
        AclGroup profile = this.findById(profileId);
        profile.checkAndForbidOperationForDefaultSystemProfile();
        this.profileDao.updatePermissions(profileId, profileActivePermissions);
        this.aclService.refreshAcls();
        this.auditModificationService.updateAuditable((AuditableMixin)profile);
    }

    private AclGroup findById(long profileId) {
        return (AclGroup)this.profileDao.findById(profileId).orElseThrow(() -> new EntityNotFoundException(String.format("%s %d %S", PROFILE_WITH_ID, profileId, "doesn't exist.")));
    }

    private boolean nameInUse(String profileName) {
        return this.dslContext.fetchExists((Select)this.dslContext.select((SelectField)Tables.ACL_GROUP.ID).from((TableLike)Tables.ACL_GROUP).where(Tables.ACL_GROUP.QUALIFIED_NAME.eq((Object)profileName)));
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public void transferAuthorizations(long profileId, long targetProfileId) {
        this.dslContext.update((Table)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).set((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID, (Object)targetProfileId).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Object)profileId)).execute();
        this.aclService.refreshAcls();
    }
}

