/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution;

import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.service.execution.ExecutionDeletionService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class ExecutionDeletionServiceImpl
implements ExecutionDeletionService {
    private static final String LOCKED_MILESTONE_MESSAGE = "This test plan item is linked to a blocking milestone and cannot be modified.";
    private final TestPlanItemDao testPlanItemDao;
    private final CampaignNodeDeletionHandler deletionHandler;
    private final PermissionEvaluationService permissionEvaluationService;
    private final SprintDisplayDao sprintDisplayDao;
    private final MilestoneDao milestoneDao;

    public ExecutionDeletionServiceImpl(TestPlanItemDao testPlanItemDao, CampaignNodeDeletionHandler deletionHandler, PermissionEvaluationService permissionEvaluationService, SprintDisplayDao sprintDisplayDao, MilestoneDao milestoneDao) {
        this.testPlanItemDao = testPlanItemDao;
        this.deletionHandler = deletionHandler;
        this.permissionEvaluationService = permissionEvaluationService;
        this.sprintDisplayDao = sprintDisplayDao;
        this.milestoneDao = milestoneDao;
    }

    @Override
    public void deleteExecutions(List<Long> executionIds) {
        this.checkDeleteExecutionPermission(executionIds);
        Map<Long, List<Long>> executionIdsByTestPlanItemId = this.testPlanItemDao.findTestPlanItemIdsByExecutionIds(executionIds);
        executionIdsByTestPlanItemId.forEach((testPlanItemId, testPlanExecutionIds) -> this.deleteExecutionsAndRemoveFromTestPlanItem((List<Long>)testPlanExecutionIds, (long)testPlanItemId));
    }

    private void deleteExecutionsAndRemoveFromTestPlanItem(List<Long> executionIds, long testPlanItemId) {
        this.checkBlockingMilestones(testPlanItemId);
        this.checkParentSprintStatus(testPlanItemId);
        TestPlanItem testPlanItem = this.testPlanItemDao.findByIdWithExecutions(testPlanItemId);
        List<Execution> executions = testPlanItem.getExecutions().stream().filter(execution -> executionIds.contains(execution.getId())).toList();
        this.deletionHandler.deleteExecutions(executions);
    }

    private void checkDeleteExecutionPermission(List<Long> executionIds) {
        this.permissionEvaluationService.checkPermission(executionIds, Permissions.DELETE_EXECUTION.name(), Execution.class.getName());
    }

    private void checkBlockingMilestones(long testPlanItemId) {
        if (this.milestoneDao.isTestPlanItemBoundToBlockingMilestone(testPlanItemId)) {
            throw new MilestoneForbidModificationException(LOCKED_MILESTONE_MESSAGE);
        }
    }

    private void checkParentSprintStatus(long testPlanItemId) {
        SprintStatus sprintStatus = this.sprintDisplayDao.getSprintStatusByTestPlanItemId(testPlanItemId);
        if (SprintStatus.CLOSED.equals((Object)sprintStatus)) {
            throw new SprintClosedException();
        }
    }
}

