/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractAuditablePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.DenormalizedValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotBoundEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IssuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.PivotIssueEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.AbstractStepPivot;

public class ExecutionStepPivot
extends AbstractAuditablePivot
implements PivotBoundEntity,
PivotIssueEntity {
    @JsonProperty(value="test_step_id")
    private String testStepId;
    @JsonProperty(value="status")
    private ExecutionStatus status;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="last_executed_by")
    private String lastExecutedBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss.SSS")
    @JsonProperty(value="last_executed_on")
    private Date lastExecutedOn;
    @JsonProperty(value="denormalized_values")
    private List<DenormalizedValuePivot> denormalizedValues = new ArrayList<DenormalizedValuePivot>();
    @JsonProperty(value="custom_fields")
    private List<CustomFieldValuePivot> customFields = new ArrayList<CustomFieldValuePivot>();
    @JsonProperty(value="attachments")
    private List<AttachmentPivot> attachments = new ArrayList<AttachmentPivot>();
    @JsonProperty(value="issues")
    private List<IssuePivot> issues = new ArrayList<IssuePivot>();
    @JsonProperty(value="test_step_denormalized")
    private StepPivotDenormalized stepPivotDenormalized;

    @Override
    public String getBasePivotId() {
        return "ES";
    }

    public String getTestStepId() {
        return this.testStepId;
    }

    public void setTestStepId(String testStepId) {
        this.testStepId = testStepId;
    }

    public void setTestStepId(Long testStepId, String basePivotId) {
        this.testStepId = ExecutionStepPivot.getPivotId(basePivotId, testStepId);
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExecutionStatus status) {
        this.status = status;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getLastExecutedBy() {
        return this.lastExecutedBy;
    }

    public void setLastExecutedBy(String lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy;
    }

    public Date getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public void setLastExecutedOn(Date lastExecutedOn) {
        this.lastExecutedOn = lastExecutedOn;
    }

    public List<DenormalizedValuePivot> getDenormalizedValues() {
        return this.denormalizedValues;
    }

    public void setDenormalizedValues(List<DenormalizedValuePivot> denormalizedValues) {
        this.denormalizedValues = denormalizedValues;
    }

    public void addDenormalizedValue(DenormalizedValuePivot denormalizedValue) {
        this.denormalizedValues.add(denormalizedValue);
    }

    @Override
    public List<CustomFieldValuePivot> getCustomFields() {
        return this.customFields;
    }

    @Override
    public void setCustomFields(List<CustomFieldValuePivot> customFields) {
        this.customFields = customFields;
    }

    @Override
    public void addCustomField(CustomFieldValuePivot customFieldValue) {
        this.customFields.add(customFieldValue);
    }

    @Override
    public void addAllCustomFields(List<CustomFieldValuePivot> customFields) {
        this.customFields.addAll(customFields);
    }

    @Override
    public List<AttachmentPivot> getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(List<AttachmentPivot> attachments) {
        this.attachments = attachments;
    }

    @Override
    public void addAttachment(AttachmentPivot attachment) {
        this.attachments.add(attachment);
    }

    @Override
    public List<IssuePivot> getIssues() {
        return this.issues;
    }

    @Override
    public void setIssues(List<IssuePivot> issues) {
        this.issues = issues;
    }

    @Override
    public void addIssue(IssuePivot issue) {
        this.issues.add(issue);
    }

    public StepPivotDenormalized getStepPivotDenormalized() {
        return this.stepPivotDenormalized;
    }

    public void setStepPivotDenormalized(StepPivotDenormalized stepPivotDenormalized) {
        this.stepPivotDenormalized = stepPivotDenormalized;
    }

    public static class StepPivotDenormalized
    extends AbstractStepPivot {
    }
}

