/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.NodeScopeType;

public interface SoftDeletableNodeHandler {
    default public void transientlyRestoreNodes(Map<NodeScopeType, Set<Long>> nodeIdsByType, Runnable runnable) {
        throw new UnsupportedOperationException("Transient restore operation is not supported by this handler. Please implement it if needed.");
    }

    default public OperationReport softDeleteNodes(List<Long> nodesIds) {
        throw new UnsupportedOperationException("Soft delete operation is not supported by this handler. Please implement it if needed.");
    }

    default public OperationReport restoreDeletedNodes(NodeScope scope) {
        throw new UnsupportedOperationException("Restore operation is not supported by this handler. Please implement it if needed.");
    }

    default public OperationReport hardDeleteNodes(NodeScope scope) {
        throw new UnsupportedOperationException("Hard delete operation is not supported by this handler. Please implement it if needed.");
    }

    default public void cleanupAll(Long projectId) {
        throw new UnsupportedOperationException("Empty workspace operation is not supported by this handler. Please implement it if needed.");
    }
}

