/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.service.internal.deletion.NodeScopeType;

public record NodeScope(Map<NodeScopeType, Set<Long>> nodes, Set<String> entityIds) {
    public static NodeScope of(Map<NodeScopeType, Set<NodeReference>> referencesByType) {
        Objects.requireNonNull(referencesByType, "referencesByType cannot be null");
        Map<NodeScopeType, Set<Long>> nodes = referencesByType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().map(NodeReference::getId).collect(Collectors.toSet())));
        Set<String> entityIds = referencesByType.values().stream().flatMap(Collection::stream).map(NodeReference::toNodeId).collect(Collectors.toSet());
        return new NodeScope(nodes, entityIds);
    }

    public static NodeScope fromLibraries(Set<NodeReference> libraries) {
        Objects.requireNonNull(libraries, "libraries cannot be null");
        if (libraries.stream().anyMatch(lib -> !NodeScopeType.LIBRARY.isCompatibleWith(lib.getNodeType()))) {
            throw new IllegalArgumentException("All references must be of type LIBRARY");
        }
        return NodeScope.of(Map.of(NodeScopeType.LIBRARY, libraries));
    }

    public Set<Long> getNodeIds() {
        return this.nodes.getOrDefault((Object)NodeScopeType.NODE, Set.of());
    }

    public Set<Long> getLibraryIds() {
        return this.nodes.getOrDefault((Object)NodeScopeType.LIBRARY, Set.of());
    }

    public boolean hasLibraries() {
        return this.nodes.containsKey((Object)NodeScopeType.LIBRARY);
    }

    public boolean hasNodes() {
        return this.nodes.containsKey((Object)NodeScopeType.NODE);
    }
}

