/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase;

import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.testcase.TestCaseImportService;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.TestCaseFolderImportData;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.TestCaseImportData;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.deletion.NodeScopeType;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.internal.testcase.NatureTypeChainFixer;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;

@Service
@Transactional
public class TestCaseImportServiceImpl
implements TestCaseImportService {
    private final TestCaseLibraryDao testCaseLibraryDao;
    private final TestCaseFolderDao testCaseFolderDao;
    private final TestCaseDao testCaseDao;
    private final EntityManager entityManager;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final MilestoneMembershipManager milestoneService;
    private final TestCaseNodeDeletionHandler deletionHandler;

    public TestCaseImportServiceImpl(TestCaseLibraryDao testCaseLibraryDao, TestCaseFolderDao testCaseFolderDao, TestCaseDao testCaseDao, EntityManager entityManager, PrivateCustomFieldValueService customFieldValueService, MilestoneMembershipManager milestoneService, TestCaseNodeDeletionHandler deletionHandler) {
        this.testCaseLibraryDao = testCaseLibraryDao;
        this.testCaseFolderDao = testCaseFolderDao;
        this.testCaseDao = testCaseDao;
        this.entityManager = entityManager;
        this.customFieldValueService = customFieldValueService;
        this.milestoneService = milestoneService;
        this.deletionHandler = deletionHandler;
    }

    @Override
    @PreventConcurrent(entityType=TestCaseLibrary.class)
    public void addTestCasesToLibrary(@Id Long libraryId, Batch<TestCaseImportData> batch, Project project) {
        this.deletionHandler.transientlyRestoreNodes(Map.of(NodeScopeType.LIBRARY, Set.of(libraryId)), () -> {
            TestCaseLibrary library = (TestCaseLibrary)this.testCaseLibraryDao.loadForNodeAddition(libraryId);
            for (TestCaseImportData importedTestCase : batch.getEntities()) {
                TestCase tc = importedTestCase.getTestCase();
                Integer position = importedTestCase.getPosition();
                if (position != null) {
                    library.addContent((LibraryNode)tc, position.intValue());
                } else {
                    library.addContent((LibraryNode)tc);
                }
                this.replaceInfoListReferences(tc);
                this.testCaseDao.persist(tc);
            }
        });
        List<TestCaseImportData> importDataList = batch.getEntities();
        this.initializeCustomFieldValues(importDataList, (GenericProject)project);
        this.initializeMilestoneBindings(importDataList);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    @BatchPreventConcurrent(entityType=TestCaseFolder.class)
    public void addTestCasesToFolders(@Ids List<Long> folderIds, Project project, List<Batch<TestCaseImportData>> batchList) {
        this.deletionHandler.transientlyRestoreNodes(Map.of(NodeScopeType.NODE, Set.copyOf(folderIds)), () -> {
            Map testCaseFolderById = this.testCaseFolderDao.loadForNodeAddition(folderIds).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
            for (Batch batch : batchList) {
                TestCaseFolder folder = (TestCaseFolder)testCaseFolderById.get(batch.getTargetId());
                for (TestCaseImportData importedTestCase : batch.getEntities()) {
                    TestCase tc = importedTestCase.getTestCase();
                    Integer position = importedTestCase.getPosition();
                    if (position != null) {
                        folder.addContent((TestCaseLibraryNode)tc, position.intValue());
                    } else {
                        folder.addContent((TestCaseLibraryNode)tc);
                    }
                    this.replaceInfoListReferences(tc);
                    this.testCaseDao.safePersist(tc);
                }
            }
        });
        List<TestCaseImportData> importDataList = batchList.stream().flatMap(a -> a.getEntities().stream()).toList();
        this.initializeCustomFieldValues(importDataList, (GenericProject)project);
        this.initializeMilestoneBindings(importDataList);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    @PreventConcurrent(entityType=TestCaseLibrary.class)
    public void addFoldersToLibrary(@Id Long libraryId, Batch<TestCaseFolderImportData> libraryFolders) {
        TestCaseLibrary library = (TestCaseLibrary)this.testCaseLibraryDao.loadForNodeAddition(libraryId);
        List<TestCaseFolder> folders = libraryFolders.getEntities().stream().map(TestCaseFolderImportData::mainFolder).toList();
        NatureTypeChainFixer fixer = new NatureTypeChainFixer();
        for (TestCaseFolder folder : folders) {
            library.addContent((LibraryNode)folder);
            fixer.fix(folder);
            this.testCaseFolderDao.persist(folder);
        }
        this.batchFolderCustomFieldInitialization(folders, library.getProject().getId());
        List<TestCaseImportData> importDataList = libraryFolders.getEntities().stream().flatMap(data -> data.testCaseDataInNodes().stream()).toList();
        this.initializeCustomFieldValues(importDataList, library.getProject());
        this.initializeMilestoneBindings(importDataList);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    @BatchPreventConcurrent(entityType=TestCaseFolder.class)
    public void addFoldersToFolders(@Ids List<Long> folderIds, List<Batch<TestCaseFolderImportData>> batchList) {
        Map testCaseFolderById = this.testCaseFolderDao.loadForNodeAddition(folderIds).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        NatureTypeChainFixer fixer = new NatureTypeChainFixer();
        for (Batch<TestCaseFolderImportData> batch2 : batchList) {
            TestCaseFolder target = (TestCaseFolder)testCaseFolderById.get(batch2.getTargetId());
            for (TestCaseFolderImportData folderImportData : batch2.getEntities()) {
                TestCaseFolder folder = folderImportData.mainFolder();
                target.addContent((TestCaseLibraryNode)folder);
                fixer.fix(folder);
                this.testCaseFolderDao.persist(folder);
            }
        }
        List<TestCaseFolder> folders = batchList.stream().flatMap(batch -> batch.getEntities().stream()).map(TestCaseFolderImportData::mainFolder).toList();
        Project project = ((TestCaseFolder)testCaseFolderById.values().iterator().next()).getProject();
        this.batchFolderCustomFieldInitialization(folders, project.getId());
        List<TestCaseImportData> importDataList = batchList.stream().flatMap(batch -> batch.getEntities().stream()).flatMap(data -> data.testCaseDataInNodes().stream()).toList();
        this.initializeCustomFieldValues(importDataList, (GenericProject)project);
        this.initializeMilestoneBindings(importDataList);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void batchFolderCustomFieldInitialization(List<TestCaseFolder> newFolders, Long projectId) {
        this.customFieldValueService.batchFolderCustomFieldValuesCreation(newFolders, BindableEntity.TESTCASE_FOLDER, projectId);
    }

    public void replaceInfoListReferences(TestCase testCase) {
        NatureTypeChainFixer.fix(testCase);
    }

    private void initializeCustomFieldValues(List<TestCaseImportData> testCasesData, GenericProject project) {
        List<TestCase> testCases = testCasesData.stream().map(TestCaseImportData::getTestCase).toList();
        this.customFieldValueService.createAllCustomFieldValues(testCases, project);
        Map<TestCase, Map> testCaseCustomFields = testCasesData.stream().filter(data -> !data.getCustomFields().isEmpty()).collect(Collectors.toMap(TestCaseImportData::getTestCase, TestCaseImportData::getCustomFields));
        this.customFieldValueService.initBatchCustomFieldValues(testCaseCustomFields);
    }

    private void initializeMilestoneBindings(List<TestCaseImportData> testCasesData) {
        Map<TestCase, List> testCaseMilestones = testCasesData.stream().filter(data -> !data.getMilestoneIds().isEmpty()).collect(Collectors.toMap(TestCaseImportData::getTestCase, TestCaseImportData::getMilestoneIds));
        this.milestoneService.bindHoldersToMilestones(testCaseMilestones);
    }
}

