/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instruction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.internal.batchimport.CustomFieldHolder;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.Milestoned;
import org.squashtest.tm.service.internal.batchimport.instruction.Instruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestCaseTarget;

public class TestCaseInstruction
extends Instruction<TestCaseTarget>
implements CustomFieldHolder,
Milestoned {
    private final TestCase testCase;
    private final Map<String, String> customFields = new HashMap<String, String>();
    private final String[] milestones = new String[0];

    public TestCaseInstruction(TestCaseTarget target, TestCase testCase) {
        super(target);
        this.testCase = testCase;
    }

    @Override
    protected LogTrain executeUpdate(Facility facility) {
        LogTrain execLogTrain = facility.updateTestCase(this);
        return execLogTrain;
    }

    @Override
    protected LogTrain executeDelete(Facility facility) {
        LogTrain execLogTrain = facility.deleteTestCase((TestCaseTarget)this.getTarget());
        return execLogTrain;
    }

    @Override
    protected LogTrain executeCreate(Facility facility) {
        throw new UnsupportedOperationException("This operation is no longer supported ");
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    @Override
    public void addCustomField(String code, String value) {
        this.customFields.put(code, value);
    }

    public List<String> getMilestones() {
        return Arrays.asList(this.milestones);
    }
}

