/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.utils;

import ch.x28.inscriptis.Inscriptis;
import ch.x28.inscriptis.ParserConfig;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;

public final class HTMLCleanupUtils {
    private HTMLCleanupUtils() {
    }

    public static String htmlToTrimmedText(String html) {
        return HTMLCleanupUtils.htmlToText(html).trim();
    }

    public static String htmlToText(String html) {
        String fixedHtml = html != null ? html : "";
        String replacedHtml = fixedHtml.replaceFirst("\n", "");
        Source htmlSource = new Source((CharSequence)replacedHtml);
        Segment htmlSegment = new Segment(htmlSource, 0, replacedHtml.length());
        Renderer htmlRend = new Renderer(htmlSegment);
        return htmlRend.toString();
    }

    public static String htmlToLayoutAwareText(String html, boolean shouldDisplayLinks) {
        org.w3c.dom.Document document = W3CDom.convert((Document)Jsoup.parse((String)html));
        ParserConfig parserConfig = new ParserConfig();
        parserConfig.setDisplayLinks(shouldDisplayLinks);
        Inscriptis inscriptis = new Inscriptis(document, parserConfig);
        return inscriptis.getText();
    }

    public static String forceHtmlEscape(String html) {
        String fixedHtml = html != null ? html : "";
        String unescaped = HtmlUtils.htmlUnescape((String)fixedHtml);
        return HtmlUtils.htmlEscape((String)unescaped);
    }

    public static String escapeOrDefault(String toEscape, String defaultString) {
        return toEscape != null ? HtmlUtils.htmlEscape((String)toEscape) : defaultString;
    }

    public static String stripJavascript(String json) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Document.OutputSettings outputSettings = new Document.OutputSettings();
            outputSettings.prettyPrint(false);
            outputSettings.outline(false);
            String cleaned = Jsoup.clean((String)json, (String)"", (Safelist)Safelist.relaxed(), (Document.OutputSettings)outputSettings);
            return HtmlUtils.htmlUnescape((String)cleaned);
        }
        return "";
    }

    public static String getCleanedBriefText(String text, int maxLength) {
        if (((String)(text = HTMLCleanupUtils.htmlToTrimmedText(HTMLCleanupUtils.cleanHtml((String)text)))).length() > maxLength) {
            text = ((String)text).substring(0, maxLength - 3) + "...";
        }
        return text;
    }

    public static String cleanHtml(String unsecureHtml) {
        return HTMLSanitizeUtils.cleanHtml((String)unsecureHtml);
    }

    public static String cleanAndUnescapeHTML(String unsecureHtml) {
        return HtmlUtils.htmlUnescape((String)HTMLCleanupUtils.cleanHtml(unsecureHtml));
    }

    public static String removeHtml(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        return html.replaceAll("(?s)<[^>]*>(\\s*<[^>]*>)*", "");
    }
}

