/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.scripted.gherkin;

import gherkin.ast.GherkinDocument;
import java.util.Objects;
import java.util.function.Consumer;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.domain.script.GherkinParser;
import org.squashtest.tm.domain.testcase.ConsumerForScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.service.internal.testcase.scripted.gherkin.GherkinStepGenerator;
import org.squashtest.tm.service.testcase.scripted.ScriptedTestCaseParser;

public class GherkinTestCaseParser
implements ScriptedTestCaseParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GherkinTestCaseParser.class);
    private GherkinStepGenerator stepGenerator;

    public GherkinTestCaseParser(GherkinStepGenerator stepGenerator) {
        this.stepGenerator = stepGenerator;
    }

    @Override
    public void populateExecution(ScriptedExecution scriptedExecution) {
        TestCase referencedTestCase = scriptedExecution.getReferencedTestCase();
        if (Objects.nonNull(referencedTestCase)) {
            Consumer<ScriptedTestCase> consumer = scriptedTestCase -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Begin parsing of Test Case {} for Execution {}", new Object[]{referencedTestCase, scriptedExecution});
                }
                GherkinDocument gherkinDocument = GherkinParser.parseDocument((String)scriptedTestCase.getScript());
                this.stepGenerator.populateExecution(scriptedExecution, gherkinDocument);
            };
            ConsumerForScriptedTestCaseVisitor testCaseVisitor = new ConsumerForScriptedTestCaseVisitor(consumer, (RuntimeException)new IllegalArgumentException("GherkinTestCaseParser is dedicated to ScriptedTestCase."));
            referencedTestCase.accept((TestCaseVisitor)testCaseVisitor);
        }
    }

    @Override
    public void validateScript(ScriptedTestCase scriptedTestCase) {
        GherkinParser.parseDocument((String)scriptedTestCase.getScript());
    }
}

