/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.statistics.testingstatus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatusDao;
import org.squashtest.tm.service.statistics.testingstatus.RequirementsByRemoteKeyByServerId;

@Repository
public class RemoteTestingStatusDaoImpl
implements RemoteTestingStatusDao {
    private final DSLContext dslContext;

    public RemoteTestingStatusDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public RequirementsByRemoteKeyByServerId findRequirementsByRemoteKeyByServerId(String remoteSynchronisationKind) {
        HashMap<Long, Map<String, List<Long>>> result = new HashMap<Long, Map<String, List<Long>>>();
        this.dslContext.select((SelectField)Tables.REMOTE_SYNCHRONISATION.SERVER_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID)).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)remoteSynchronisationKind)).fetch().stream().collect(Collectors.groupingBy(r -> (Long)r.get((Field)Tables.REMOTE_SYNCHRONISATION.SERVER_ID))).forEach((serverId, records) -> {
            Map reqIdsByRemoteKey = records.stream().collect(Collectors.groupingBy(r -> (String)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID), Collectors.mapping(r -> (Long)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID), Collectors.toList())));
            result.put((Long)serverId, reqIdsByRemoteKey);
        });
        return new RequirementsByRemoteKeyByServerId(result);
    }

    @Override
    public List<Long> findRequirementIdsForOneRemoteKeyAndServerId(String remoteSynchronisationKind, String remoteKey, Long serverId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID)).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)remoteSynchronisationKind)).and(Tables.REMOTE_SYNCHRONISATION.SERVER_ID.eq((Object)serverId)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)remoteKey)).fetchInto(Long.class);
    }

    @Override
    public Map<Long, List<String>> findSynchronisedKeysBySynchronisationId(List<Long> remoteSyncIds) {
        HashMap<Long, List<String>> remoteKeysBySyncId = new HashMap<Long, List<String>>();
        this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.in(remoteSyncIds)).fetch().forEach(extenderRecord -> {
            Long remoteSynchronisationId = (Long)extenderRecord.value1();
            String remoteReqId = (String)extenderRecord.value2();
            remoteKeysBySyncId.computeIfAbsent(remoteSynchronisationId, key -> new ArrayList()).add(remoteReqId);
        });
        return remoteKeysBySyncId;
    }
}

