/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.internal.repository.CustomSprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

@Repository
public class CustomSprintReqVersionDaoImpl
extends HibernateEntityDao<Sprint>
implements CustomSprintReqVersionDao {
    private final TestPlanItemDao testPlanItemDao;

    public CustomSprintReqVersionDaoImpl(TestPlanItemDao testPlanItemDao) {
        this.testPlanItemDao = testPlanItemDao;
    }

    @Override
    public void removeTestPlanItemOrNullifyReferencedTestCase(List<Long> tclnIds) {
        List<TestPlanItem> testPlanItems = this.testPlanItemDao.findByReferencedTestCasesWithExecutions(tclnIds);
        List<TestPlanItem> itemsWithoutExecutions = testPlanItems.stream().filter(item -> item.getExecutions().isEmpty()).toList();
        List<TestPlanItem> itemsWithExecutions = testPlanItems.stream().filter(item -> !item.getExecutions().isEmpty()).toList();
        this.testPlanItemDao.deleteAll(itemsWithoutExecutions);
        itemsWithExecutions.forEach(item -> item.setReferencedTestCase(null));
    }

    @Override
    public SprintReqVersion loadForExecutionResume(long sprintReqVersionId) {
        List itemIds = this.entityManager.createQuery("select item.id\nfrom SprintReqVersion srv\njoin srv.testPlan tp\njoin tp.testPlanItems item\nwhere srv.id = :id", Long.class).setParameter("id", (Object)sprintReqVersionId).getResultList();
        if (!itemIds.isEmpty()) {
            this.entityManager.createQuery("select distinct tpi\nfrom TestPlanItem tpi\nleft join fetch tpi.executions exec\nleft join fetch exec.steps\nleft join fetch exec.automatedExecutionExtender\nwhere tpi.id in :itemIds", TestPlanItem.class).setParameter("itemIds", (Object)itemIds).getResultList();
            this.entityManager.createQuery("select distinct tc\nfrom TestCase tc\nleft join fetch tc.steps\nwhere tc.id in (\n    select tpi.referencedTestCase.id\n    from TestPlanItem tpi\n    where tpi.id in :itemIds\n    and tpi.referencedTestCase is not null\n)", TestCase.class).setParameter("itemIds", (Object)itemIds).getResultList();
        }
        return (SprintReqVersion)this.entityManager.createQuery("select distinct srv\nfrom SprintReqVersion srv\nleft join fetch srv.testPlan tp\nleft join fetch tp.testPlanItems item\nwhere srv.id = :id", SprintReqVersion.class).setParameter("id", (Object)sprintReqVersionId).getSingleResult();
    }
}

