/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report.qualitativecoverage;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageCampaignDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageIterationDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageProjectDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageTestSuiteDto;
import org.squashtest.tm.service.internal.report.qualitativecoverage.QuaCoverageFormatter;
import org.squashtest.tm.service.internal.report.qualitativecoverage.QuaCoverageQueryFinder;

@Component
public class QuaCoverageQuery
implements ReportQuery {
    public static final String CRIT_MODE = "requirementsSelectionMode";
    private static final String CRIT_MILESTONES = "milestones";
    private static final String CRIT_PROJ_IDS = "projectIds";
    private static final String CRIT_PROJECT_PICKER = "PROJECT_PICKER";
    public static final String MILESTONE_LABEL = "milestoneLabel";
    public static final String DATA = "data";
    private CurrentUserHelper currentUserHelper;
    private QuaCoverageQueryFinder quaCoverageQueryFinder;

    @Inject
    public QuaCoverageQuery(CurrentUserHelper currentUserHelper, QuaCoverageQueryFinder quaCoverageQueryFinder) {
        this.currentUserHelper = currentUserHelper;
        this.quaCoverageQueryFinder = quaCoverageQueryFinder;
    }

    public QuaCoverageQuery() {
    }

    public void executeQuery(Map<String, Criteria> criteria, Map<String, Object> model) {
        List<Long> projectIds;
        String mode = (String)criteria.get(CRIT_MODE).getValue();
        QuaCoverageFormatter quaCoverageFormatter = new QuaCoverageFormatter(this.quaCoverageQueryFinder, this.currentUserHelper);
        List milestoneIds = null;
        if (mode.equals(CRIT_PROJECT_PICKER)) {
            List projectIdsAsString = (List)criteria.get(CRIT_PROJ_IDS).getValue();
            projectIds = projectIdsAsString.stream().map(Long::parseLong).toList();
        } else {
            milestoneIds = (List)criteria.get(CRIT_MILESTONES).getValue();
            projectIds = this.quaCoverageQueryFinder.getProjectIdsByMilestoneIds(milestoneIds);
        }
        List<Long> accessibleProjectIds = quaCoverageFormatter.filterAccessibleProject(projectIds);
        List<QuaCoverageProjectDto> projectBeans = this.quaCoverageQueryFinder.getProjectsByIds(accessibleProjectIds);
        quaCoverageFormatter.setDisabledExecutionStatus(projectBeans);
        List<QuaCoverageCampaignDto> campaignBeans = Objects.isNull(milestoneIds) ? this.quaCoverageQueryFinder.getCampaignsByProjectIds(projectIds) : this.quaCoverageQueryFinder.getCampaignsByProjectAndMilestoneIds(projectIds, milestoneIds);
        quaCoverageFormatter.setCampaignsRequirement(campaignBeans);
        List<QuaCoverageIterationDto> iterationBeans = this.quaCoverageQueryFinder.getIterationsByCampaignIds(quaCoverageFormatter.getCampaignIds(campaignBeans));
        quaCoverageFormatter.setIterationsRequirement(iterationBeans);
        List<QuaCoverageTestSuiteDto> testSuiteBeans = this.quaCoverageQueryFinder.getTestSuitesByIterationIds(quaCoverageFormatter.getIterationIds(iterationBeans));
        quaCoverageFormatter.setTestSuitesRequirement(testSuiteBeans);
        quaCoverageFormatter.setIterationsTestSuites(iterationBeans, testSuiteBeans);
        quaCoverageFormatter.setCampaignsIterations(campaignBeans, iterationBeans);
        quaCoverageFormatter.setProjectsCampaigns(projectBeans, campaignBeans);
        if (Objects.nonNull(milestoneIds)) {
            Integer milestoneId = (Integer)milestoneIds.getFirst();
            String milestoneLabel = this.quaCoverageQueryFinder.getMilestoneLabel(milestoneId);
            model.put(MILESTONE_LABEL, milestoneLabel);
        }
        model.put(DATA, projectBeans);
    }
}

