/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report.qualitativecoverage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageCampaignDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageIterationDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageProjectDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageRequirementDto;
import org.squashtest.tm.service.internal.dto.qualitativecoverage.QuaCoverageTestSuiteDto;
import org.squashtest.tm.service.internal.report.qualitativecoverage.QuaCoverageQueryFinder;

public class QuaCoverageFormatter {
    private final QuaCoverageQueryFinder quaCoverageQueryFinder;
    private final CurrentUserHelper currentUserHelper;

    public QuaCoverageFormatter(QuaCoverageQueryFinder quaCoverageQueryFinder, CurrentUserHelper currentUserHelper) {
        this.quaCoverageQueryFinder = quaCoverageQueryFinder;
        this.currentUserHelper = currentUserHelper;
    }

    public List<Long> filterAccessibleProject(List<Long> projectIds) {
        HashSet<Long> projectIdsSet = new HashSet<Long>(projectIds);
        return this.currentUserHelper.findFilteredReadableProjectIds().stream().filter(projectIdsSet::contains).toList();
    }

    public void setDisabledExecutionStatus(List<QuaCoverageProjectDto> projectBeans) {
        List<Long> projectIds = this.getProjectIds(projectBeans);
        Map<Long, List<String>> disabledExecutionStatusByProjectId = this.quaCoverageQueryFinder.getDisabledExecutionStatus(projectIds);
        for (QuaCoverageProjectDto projectBean : projectBeans) {
            projectBean.setDisabledExecutionStatus(disabledExecutionStatusByProjectId.get(projectBean.getProjectId()));
        }
    }

    public void setCampaignsRequirement(List<QuaCoverageCampaignDto> campaignBeans) {
        List<Long> campaignIds = this.getCampaignIds(campaignBeans);
        Map<Long, List<QuaCoverageRequirementDto>> requirementsByCampaignId = this.quaCoverageQueryFinder.fetchCoverageByCampaigns(campaignIds);
        campaignBeans.forEach(campaignBean -> campaignBean.setRequirements((List)requirementsByCampaignId.get(campaignBean.getCampaignId())));
    }

    public void setProjectsCampaigns(List<QuaCoverageProjectDto> projectBeans, List<QuaCoverageCampaignDto> campaignBeans) {
        Map<Long, List<QuaCoverageCampaignDto>> campaignsByProjectId = campaignBeans.stream().collect(Collectors.groupingBy(QuaCoverageCampaignDto::getProjectId));
        projectBeans.forEach(projectBean -> {
            List<QuaCoverageCampaignDto> campaigns = campaignsByProjectId.getOrDefault(projectBean.getProjectId(), Collections.emptyList());
            projectBean.setCampaigns(campaigns);
        });
    }

    public List<Long> getProjectIds(List<QuaCoverageProjectDto> projectBeans) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        for (QuaCoverageProjectDto projectBean : projectBeans) {
            projectIds.add(projectBean.getProjectId());
        }
        return projectIds;
    }

    public List<Long> getCampaignIds(List<QuaCoverageCampaignDto> campaignBeans) {
        return campaignBeans.stream().map(QuaCoverageCampaignDto::getCampaignId).toList();
    }

    public List<Long> getIterationIds(List<QuaCoverageIterationDto> iterationBeans) {
        return iterationBeans.stream().map(QuaCoverageIterationDto::getIterationId).toList();
    }

    public void setIterationsRequirement(List<QuaCoverageIterationDto> iterationBeans) {
        List<Long> iterationIds = this.getIterationIds(iterationBeans);
        Map<Long, List<QuaCoverageRequirementDto>> requirementsByIterationId = this.quaCoverageQueryFinder.fetchCoverageByIterations(iterationIds);
        iterationBeans.forEach(iterationBean -> iterationBean.setRequirements((List)requirementsByIterationId.get(iterationBean.getIterationId())));
    }

    public void setTestSuitesRequirement(List<QuaCoverageTestSuiteDto> testSuiteBeans) {
        List<Long> testSuiteIds = this.getTestSuiteIds(testSuiteBeans);
        Map<Long, List<QuaCoverageRequirementDto>> requirementsByTestSuiteId = this.quaCoverageQueryFinder.fetchCoverageByTestSuites(testSuiteIds);
        testSuiteBeans.forEach(testSuiteBean -> testSuiteBean.setRequirements((List)requirementsByTestSuiteId.get(testSuiteBean.getTestSuiteId())));
    }

    public List<Long> getTestSuiteIds(List<QuaCoverageTestSuiteDto> testSuiteBeans) {
        return testSuiteBeans.stream().map(QuaCoverageTestSuiteDto::getTestSuiteId).toList();
    }

    public void setIterationsTestSuites(List<QuaCoverageIterationDto> iterationBeans, List<QuaCoverageTestSuiteDto> testSuiteBeans) {
        Map<Long, List<QuaCoverageTestSuiteDto>> testSuitesByIterationId = testSuiteBeans.stream().collect(Collectors.groupingBy(QuaCoverageTestSuiteDto::getIterationId));
        iterationBeans.forEach(iterationBean -> {
            List<QuaCoverageTestSuiteDto> testSuites = testSuitesByIterationId.getOrDefault(iterationBean.getIterationId(), Collections.emptyList());
            iterationBean.setTestSuites(testSuites);
        });
    }

    public void setCampaignsIterations(List<QuaCoverageCampaignDto> campaignBeans, List<QuaCoverageIterationDto> iterationBeans) {
        Map<Long, List<QuaCoverageIterationDto>> iterationsByCampaignId = iterationBeans.stream().collect(Collectors.groupingBy(QuaCoverageIterationDto::getCampaignId));
        campaignBeans.forEach(campaignBean -> {
            List<QuaCoverageIterationDto> iterations = iterationsByCampaignId.getOrDefault(campaignBean.getCampaignId(), Collections.emptyList());
            campaignBean.setIterations(iterations);
        });
    }
}

