/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentPivotType;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.TestCasePivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CalledTestCasePivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Service
public class TestCasePivotExporterServiceImpl
implements TestCasePivotExporterService {
    private final TestCasePivotDao testCasePivotDao;
    private final CalledTestCasePivotDao calledTestCasePivotDao;
    private final PivotFileManager pivotFileManager;

    public TestCasePivotExporterServiceImpl(TestCasePivotDao testCasePivotDao, CalledTestCasePivotDao calledTestCasePivotDao, PivotFileManager pivotFileManager) {
        this.testCasePivotDao = testCasePivotDao;
        this.calledTestCasePivotDao = calledTestCasePivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateTestCaseJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId) throws IOException {
        if (this.testCasePivotDao.hasTestCase(projectId)) {
            File attachmentDir = this.pivotFileManager.createAttachmentDir(tmpAttachmentDir, AttachmentPivotType.TEST_CASE);
            this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleTestCase((JsonGenerator)jsonGenerator, attachmentDir, projectId), JsonImportFile.TEST_CASES, archive);
            this.pivotFileManager.addAttachmentsToZip(archive, tmpAttachmentDir, attachmentDir);
        }
    }

    private void handleTestCase(JsonGenerator jsonGenerator, File attachmentDir, Long projectId) {
        this.testCasePivotDao.getTestCaseByProjectId(projectId, testCasePivot -> this.pivotFileManager.writePivotObject(testCasePivot, jsonGenerator, JsonImportFile.TEST_CASES), attachmentPivot -> this.pivotFileManager.saveTmpSaveAttachment(attachmentDir, (AttachmentPivot)attachmentPivot));
    }

    @Override
    public void generateCalledTestCaseJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (this.calledTestCasePivotDao.hasCalledTestCase(projectId)) {
            this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleCalledTestCase((JsonGenerator)jsonGenerator, projectId), JsonImportFile.CALLED_TEST_CASES, archive);
        }
    }

    private void handleCalledTestCase(JsonGenerator jsonGenerator, Long projectId) {
        this.calledTestCasePivotDao.getCalledTestCaseByProjectId(projectId, calledTestCasesPivot -> this.pivotFileManager.writePivotObject(calledTestCasesPivot, jsonGenerator, JsonImportFile.CALLED_TEST_CASES));
    }
}

