/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.trash;

import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.service.display.trash.TestCaseBinDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.repository.hibernate.TestCaseBinDao;

@Service
@Transactional(readOnly=true)
public class TestCaseBinDisplayServiceImpl
implements TestCaseBinDisplayService {
    private final TestCaseBinDao testCaseBinDao;

    public TestCaseBinDisplayServiceImpl(TestCaseBinDao testCaseBinDao) {
        this.testCaseBinDao = testCaseBinDao;
    }

    @Override
    public GridResponse displayDeletedNodes(GridRequest request) {
        List<NodeReference> references = request.getScope().stream().map(NodeReference::fromNodeId).toList();
        if (references.isEmpty()) {
            throw new IllegalArgumentException("No references provided in the request scope.");
        }
        HashSet<Long> libraryIds = new HashSet<Long>();
        HashSet<Long> nodeIds = new HashSet<Long>();
        for (NodeReference reference : references) {
            switch (reference.getNodeType()) {
                case TEST_CASE_LIBRARY: {
                    libraryIds.add(reference.getId());
                    break;
                }
                case TEST_CASE_FOLDER: 
                case TEST_CASE: {
                    nodeIds.add(reference.getId());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported entity type: " + String.valueOf(reference.getNodeType()));
                }
            }
        }
        return this.testCaseBinDao.getDeletedNodesGrid(request, libraryIds, nodeIds);
    }
}

