/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.testcase;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class TestCaseBinGrid
extends AbstractGrid {
    private static final String DELETED_NODE_TABLE = "DELETED_NODE_TABLE";
    private static final String ATTACHMENT_TABLE = "ATTACHMENT_TABLE";
    private static final String PATH_TABLE = "PATH_TABLE";
    private final Set<Long> nodeIds;
    private final Set<Long> libraryIds;

    public TestCaseBinGrid(Set<Long> libraryIds, Set<Long> nodeIds) {
        this.nodeIds = nodeIds;
        this.libraryIds = libraryIds;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return List.of(new GridColumn(DSL.field((String)"ID")), new GridColumn(DSL.field((String)"NAME")), new GridColumn(DSL.field((String)"DELETED_ON", Timestamp.class)), new GridColumn(DSL.field((String)"DELETED_BY")), new GridColumn(DSL.field((String)"PROJECT_ID")), new GridColumn(DSL.field((String)"PROJECT_NAME")), new GridColumn(DSL.field((String)"PATH")), new GridColumn(DSL.field((String)"ATTACHMENT_SIZE")), new GridColumn(DSL.field((String)"NODE_ID")));
    }

    @Override
    protected Table<?> getTable() {
        CommonTableExpression<Record1<Long>> deletedNodeCte = this.getDeleteNodeTable();
        Table<Record2<Long, String>> pathTable = this.getPathTable();
        Table<Record2<Long, BigDecimal>> attachmentTable = this.getAttachmentTable();
        return DSL.with((CommonTableExpression[])new CommonTableExpression[]{deletedNodeCte}).select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("ID"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON.as("DELETED_ON"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DELETED_BY.as("DELETED_BY"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), this.getNodeIdField(), (SelectField)DSL.coalesce((Field)DSL.field((Name)DSL.name((String[])new String[]{PATH_TABLE, "PATH"})), (Object)Tables.PROJECT.NAME).as("PATH"), (SelectField)DSL.field((Name)DSL.name((String[])new String[]{ATTACHMENT_TABLE, "ATTACHMENT_SIZE"}))).from(deletedNodeCte).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(deletedNodeCte.field("TCLN_ID", Long.class).eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).leftJoin(pathTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(pathTable.field("TCLN_ID", Long.class))).leftJoin(attachmentTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(attachmentTable.field("TCLN_ID", Long.class))).asTable();
    }

    private Field<String> getNodeIdField() {
        return DSL.when((Condition)Tables.TEST_CASE_FOLDER.TCLN_ID.isNotNull(), this.concatNodeField(NodeType.TEST_CASE_FOLDER)).otherwise(this.concatNodeField(NodeType.TEST_CASE)).as("NODE_ID");
    }

    private Field<String> concatNodeField(NodeType nodeType) {
        String typeName = nodeType.getTypeName() + "-";
        return DSL.concat((Field[])new Field[]{DSL.value((String)typeName), Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID});
    }

    private CommonTableExpression<Record1<Long>> getDeleteNodeTable() {
        boolean hasLibraries = !this.libraryIds.isEmpty();
        boolean hasFolders = !this.nodeIds.isEmpty();
        SelectConditionStep<Record1<Long>> query = null;
        if (!hasLibraries && !hasFolders) {
            throw new IllegalArgumentException("At least one of libraryIds or nodeIds must be provided.");
        }
        if (hasLibraries) {
            query = this.getLibraryDeletedContent();
        }
        if (hasFolders) {
            Select folderQuery = this.getDeleteNodes();
            query = query == null ? folderQuery : query.union(folderQuery);
        }
        return DSL.name((String)DELETED_NODE_TABLE).fields("TCLN_ID").as(query);
    }

    private SelectConditionStep<Record1<Long>> getLibraryDeletedContent() {
        return DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TCLN_ID")).from((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.in(this.libraryIds).and(Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON.isNotNull()));
    }

    private SelectConditionStep<Record1<Long>> getDeleteNodes() {
        return DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TCLN_ID")).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(this.nodeIds).and(Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON.isNotNull()));
    }

    private Table<Record2<Long, BigDecimal>> getAttachmentTable() {
        return DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)DSL.coalesce((Field)DSL.round((Field)DSL.sum((Field)Tables.ATTACHMENT.SIZE).divide((Number)0x100000), (int)2), (Object)BigDecimal.ZERO).as("ATTACHMENT_SIZE")).from(DSL.name((String)DELETED_NODE_TABLE)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(DSL.field((Name)DSL.name((String[])new String[]{DELETED_NODE_TABLE, "TCLN_ID"}), Long.class).eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.ATTACHMENT).on(Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID.eq((Field)Tables.ATTACHMENT.ATTACHMENT_LIST_ID)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID}).asTable(ATTACHMENT_TABLE);
    }

    private Table<Record2<Long, String>> getPathTable() {
        return DSL.select((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.as("TCLN_ID"), (SelectField)DSL.concat((Field[])new Field[]{Tables.PROJECT.NAME, DSL.value((String)" / "), DSL.groupConcat((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME).orderBy(new OrderField[]{Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator(" / ")}).as("PATH")).from(DSL.name((String)DELETED_NODE_TABLE)).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(DSL.field((Name)DSL.name((String[])new String[]{DELETED_NODE_TABLE, "TCLN_ID"}), Long.class).eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0)).groupBy(new GroupField[]{Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.PROJECT.NAME}).asTable(PATH_TABLE);
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return DSL.field((String)"PROJECT_ID");
    }
}

