/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.impl.DSL;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.script.GherkinParser;
import org.squashtest.tm.exception.testcase.ScriptParsingException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.utils.RequestAliasesConstants;

public final class TestPlanGridHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestPlanGridHelpers.class);
    private static final String NOT_ACTIVE_SUFFIX = " (not_active)";

    private TestPlanGridHelpers() {
    }

    public static SelectFieldOrAsterisk formatAssigneeFullName() {
        return TestPlanGridHelpers.formatAssigneeFullName(Tables.CORE_USER);
    }

    public static Field<String> formatAssigneeFullName(CoreUser user) {
        return DSL.when((Condition)user.FIRST_NAME.isNotNull().and(user.FIRST_NAME.notEqual((Object)"")).and(user.ACTIVE.isTrue()), (Field)user.FIRST_NAME.concat(new Field[]{DSL.val((String)" "), user.LAST_NAME, DSL.val((String)" ("), user.LOGIN, DSL.val((String)")")})).when(user.FIRST_NAME.isNotNull().and(user.FIRST_NAME.notEqual((Object)"")).and(user.ACTIVE.isFalse()), user.FIRST_NAME.concat(new Field[]{DSL.val((String)" "), user.LAST_NAME, DSL.val((String)NOT_ACTIVE_SUFFIX)})).when(user.FIRST_NAME.isNull().and(user.ACTIVE.isTrue()).or(user.FIRST_NAME.eq((Object)"").and(user.ACTIVE.isTrue())), user.LAST_NAME.concat(new Field[]{DSL.val((String)" ("), user.LOGIN, DSL.val((String)")")})).otherwise(user.LAST_NAME.concat(new Field[]{DSL.val((String)NOT_ACTIVE_SUFFIX)})).as("ASSIGNEE_FULL_NAME");
    }

    public static void formatDeactivatedUserNameInRowData(DataRow row, MessageSource messageSource) {
        String assigneeFullName = RequestAliasesConstants.toCamelCase("ASSIGNEE_FULL_NAME");
        String rowUserName = (String)row.getData().get(assigneeFullName);
        if (rowUserName != null && rowUserName.contains("(not_active)")) {
            Locale locale = LocaleContextHolder.getLocale();
            String translatedMessage = messageSource.getMessage("administration-workspace.users.manage.deactivated", null, locale).toLowerCase();
            rowUserName = rowUserName.replace("not_active", translatedMessage);
            row.addData(assigneeFullName, rowUserName);
        }
    }

    public static void addTestCasePath(DataRow row, Map<Long, String> testCasePathById) {
        Long rowTestCaseId = (Long)row.getData().get(RequestAliasesConstants.toCamelCase("TEST_CASE_ID"));
        row.addData(RequestAliasesConstants.toCamelCase("TEST_CASE_PATH"), testCasePathById.get(rowTestCaseId));
    }

    public static void checkScriptedTestCaseHasScenario(DataRow row) {
        String script = (String)row.getData().get(RequestAliasesConstants.toCamelCase("SCRIPT"));
        if (Objects.nonNull(script)) {
            boolean hasScenarios = false;
            try {
                hasScenarios = GherkinParser.hasScenarios((String)script);
            }
            catch (ScriptParsingException e) {
                LOGGER.warn("Failed to parse gherkin script, setting hasExecutableSteps to false", (Throwable)e);
            }
            row.addData(RequestAliasesConstants.toCamelCase("HAS_EXECUTABLE_STEPS"), hasScenarios);
        }
    }
}

