/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto.aiserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.tools.StringUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public abstract class AbstractAiServerConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAiServerConfiguration.class);

    protected AbstractAiServerConfiguration() {
    }

    public static <T extends AbstractAiServerConfiguration> T getDeserializedConfiguration(String options, String serverName, Class<T> configClass) {
        try {
            if (StringUtils.isBlank((String)options)) {
                return (T)((AbstractAiServerConfiguration)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            ObjectMapper mapper = new ObjectMapper();
            return (T)((AbstractAiServerConfiguration)mapper.readValue(options, configClass));
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("Could not deserialize options for AI server %s", serverName), (Throwable)e);
            }
            throw new IllegalArgumentException(e);
        }
    }
}

