/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.column;

import jakarta.validation.constraints.NotNull;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.SheetCorruptedException;
import org.squashtest.tm.service.batchimport.excel.TemplateMismatchException;
import org.squashtest.tm.service.batchimport.excel.WorksheetFormatStatus;
import org.squashtest.tm.service.batchimport.excel.WorksheetMismatch;
import org.squashtest.tm.service.internal.batchimport.column.ColumnMismatchException;
import org.squashtest.tm.service.internal.batchimport.column.ExcelWorkbookParser;
import org.squashtest.tm.service.internal.batchimport.column.TemplateWorksheet;
import org.squashtest.tm.service.internal.batchimport.column.WorkbookMetaData;
import org.squashtest.tm.service.internal.batchimport.column.WorksheetDef;

class ExcelWorkbookParserBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelWorkbookParserBuilder.class);
    private final File xls;

    public ExcelWorkbookParserBuilder(@NotNull File xls) {
        this.xls = xls;
    }

    public ExcelWorkbookParser build() throws SheetCorruptedException, TemplateMismatchException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.xls));){
                Workbook wb = this.openWorkbook(is);
                WorkbookMetaData wmd = this.getWorkbookMetaData(wb);
                LOGGER.trace("Metamodel is built, will create a parser based on the metamodel", new Object[0]);
                return new ExcelWorkbookParser(wb, wmd);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SheetCorruptedException((Exception)e);
        }
    }

    @NotNull
    private WorkbookMetaData getWorkbookMetaData(Workbook wb) {
        WorkbookMetaData wmd;
        try {
            wmd = this.buildMetaData(wb);
            wmd.validate();
        }
        catch (TemplateMismatchException tme) {
            throw new TemplateMismatchException(tme.getWorksheetFormatStatuses(), tme);
        }
        return wmd;
    }

    private WorkbookMetaData buildMetaData(Workbook wb) throws TemplateMismatchException {
        LOGGER.trace("Building metamodel for workbook", new Object[0]);
        WorkbookMetaData wmd = new WorkbookMetaData();
        this.processSheets(wb, wmd);
        return wmd;
    }

    private void processSheets(Workbook wb, WorkbookMetaData wmd) {
        ArrayList<WorksheetFormatStatus> worksheetKOStatuses = new ArrayList<WorksheetFormatStatus>();
        int iSheet = 0;
        while (iSheet < wb.getNumberOfSheets()) {
            this.processSheet(wb, wmd, worksheetKOStatuses, iSheet);
            ++iSheet;
        }
        if (!worksheetKOStatuses.isEmpty()) {
            throw new TemplateMismatchException(worksheetKOStatuses);
        }
    }

    private void processSheet(Workbook wb, WorkbookMetaData wmd, List<WorksheetFormatStatus> worksheetKOStatuses, int iSheet) {
        Sheet ws = wb.getSheetAt(iSheet);
        String sheetName = ws.getSheetName();
        Collection<TemplateWorksheet> sheetTypes = TemplateWorksheet.coerceFromSheetName(sheetName);
        for (TemplateWorksheet sheetType : sheetTypes) {
            if (sheetType != null) {
                LOGGER.trace("Worksheet named '{}' will be added to metamodel as standard worksheet {}", new Object[]{sheetName, sheetType});
                WorksheetDef wd = new WorksheetDef(sheetType);
                wmd.addWorksheetDef(wd);
                WorksheetFormatStatus workSheetFormatStatus = this.populateColumnDefs(wd, ws);
                if (workSheetFormatStatus.isFormatOk()) continue;
                worksheetKOStatuses.add(workSheetFormatStatus);
                continue;
            }
            LOGGER.trace("Skipping unrecognized worksheet named '{}'", new Object[]{ws.getSheetName()});
        }
    }

    private WorksheetFormatStatus populateColumnDefs(WorksheetDef<?> wd, Sheet ws) {
        Row headerRow = this.findHeaderRow(ws);
        WorksheetFormatStatus worksheetFormatStatus = new WorksheetFormatStatus(wd.getWorksheetType());
        if (headerRow == null) {
            worksheetFormatStatus.addWorksheetMismatch(WorksheetMismatch.MISSING_HEADER);
            return worksheetFormatStatus;
        }
        int iCell = 0;
        while (iCell < headerRow.getLastCellNum()) {
            Cell cell = headerRow.getCell(iCell);
            if (cell != null && cell.getCellType() == CellType.STRING) {
                try {
                    String header = cell.getStringCellValue();
                    wd.addColumnDef(header, iCell);
                }
                catch (ColumnMismatchException cme) {
                    worksheetFormatStatus.addMismatch(cme.getType(), cme.getColType());
                }
            }
            ++iCell;
        }
        return worksheetFormatStatus;
    }

    private Row findHeaderRow(Sheet ws) {
        return ws.getRow(0);
    }

    private Workbook openWorkbook(InputStream is) throws SheetCorruptedException {
        try {
            return WorkbookFactory.create((InputStream)is);
        }
        catch (IOException | IllegalArgumentException | POIXMLException e) {
            LOGGER.info(e.getMessage(), new Object[0]);
            IOUtils.closeQuietly((InputStream)is);
            throw new SheetCorruptedException((Exception)e);
        }
    }
}

