/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerRequiredOptions;
import org.squashtest.tm.service.internal.repository.display.AiTestCaseGenerationDisplayDao;

@Repository
public class AiTestCaseGenerationDisplayDaoImpl
implements AiTestCaseGenerationDisplayDao {
    private final DSLContext dsl;

    public AiTestCaseGenerationDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public boolean isAiServerProperlyConfigured(Long aiServerId, Long aiUsageId, Long projectId) {
        Boolean configurationOk = (Boolean)this.dsl.select((SelectField)DSL.when((Condition)Tables.AI_SERVER.PROVIDER.eq((Object)AiProvider.NONE.name()), (Field)AiTestCaseGenerationDisplayDaoImpl.canUseNoneProvider()).when(Tables.AI_SERVER.PROVIDER.eq((Object)AiProvider.CUSTOM.name()), (Field)AiTestCaseGenerationDisplayDaoImpl.canUseCustomAIServer().and(Tables.PROJECT_AI_CONFIGURATION.PROMPT_SET_ID.isNotNull())).when(Tables.AI_SERVER.PROVIDER.eq((Object)AiProvider.GOOGLE_VERTEX_AI.name()), (Field)AiTestCaseGenerationDisplayDaoImpl.canUseGoogleVertexAi().and(Tables.PROJECT_AI_CONFIGURATION.PROMPT_SET_ID.isNotNull())).otherwise((Field)AiTestCaseGenerationDisplayDaoImpl.canUseStandardProvider().and(Tables.PROJECT_AI_CONFIGURATION.PROMPT_SET_ID.isNotNull()))).from((TableLike)Tables.AI_SERVER).innerJoin((TableLike)Tables.PROJECT_AI_CONFIGURATION).on(Tables.AI_SERVER.SERVER_ID.eq((Field)Tables.PROJECT_AI_CONFIGURATION.AI_SERVER_ID)).where(Tables.AI_SERVER.SERVER_ID.eq((Object)aiServerId)).and(Tables.PROJECT_AI_CONFIGURATION.PROJECT_ID.eq((Object)projectId)).and(Tables.PROJECT_AI_CONFIGURATION.AI_USAGE_ID.eq((Object)aiUsageId)).fetchOne(0, Boolean.class);
        return Boolean.TRUE.equals(configurationOk);
    }

    private static Condition canUseNoneProvider() {
        return Tables.AI_SERVER.PAYLOAD_TEMPLATE.isNotNull().and(Tables.AI_SERVER.JSON_PATH.isNotNull());
    }

    private static Condition canUseCustomAIServer() {
        return Tables.AI_SERVER.OPTIONS.contains((Object)AiServerRequiredOptions.PAYLOAD_TEMPLATE.label).and(Tables.AI_SERVER.OPTIONS.contains((Object)AiServerRequiredOptions.GENERATED_TEXT_JSON_PATH.label));
    }

    private static Condition canUseStandardProvider() {
        return Tables.AI_SERVER.MODEL_NAME.isNotNull().and(Tables.AI_SERVER.MODEL_NAME.ne((Object)""));
    }

    private static Condition canUseGoogleVertexAi() {
        return Tables.AI_SERVER.MODEL_NAME.isNotNull().and(Tables.AI_SERVER.MODEL_NAME.ne((Object)"")).and(Tables.AI_SERVER.OPTIONS.contains((Object)AiServerRequiredOptions.PROJECT_ID.label)).and(Tables.AI_SERVER.OPTIONS.contains((Object)AiServerRequiredOptions.REGION.label));
    }
}

