/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.ColumnRole;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;

public class WorkbenchData {
    private final ChartBuildingBlocks chartBuildingBlocks;
    private final Long containerId;
    private final Long projectId;

    public WorkbenchData(Map<EntityType, Set<QueryColumnPrototype>> columnPrototypes, Long containerId, Long projectId) {
        this.chartBuildingBlocks = new ChartBuildingBlocks(columnPrototypes);
        this.containerId = containerId;
        this.projectId = projectId;
    }

    public ChartBuildingBlocks getChartBuildingBlocks() {
        return this.chartBuildingBlocks;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getContainerId() {
        return this.containerId;
    }

    public static class ChartBuildingBlocks {
        private final Map<EntityType, Set<QueryColumnPrototype>> columnPrototypes;
        private final Map<ColumnRole, EnumSet<Operation>> columnRoles = new EnumMap<ColumnRole, EnumSet<Operation>>(ColumnRole.class);
        private final Map<DataType, EnumSet<Operation>> dataTypes = new EnumMap<DataType, EnumSet<Operation>>(DataType.class);
        private final Map<EntityType, String> entityTypes = new LinkedHashMap<EntityType, String>();

        public ChartBuildingBlocks(Map<EntityType, Set<QueryColumnPrototype>> columnPrototypes) {
            this.columnPrototypes = columnPrototypes;
            this.populate();
        }

        private void populate() {
            this.addColumnRoles();
            this.addDataType();
            this.addEntityType();
        }

        private void addColumnRoles() {
            ColumnRole[] columnRoleArray = ColumnRole.values();
            int n = columnRoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnRole cr = columnRoleArray[n2];
                this.columnRoles.put(cr, (EnumSet)cr.getOperations());
                ++n2;
            }
        }

        private void addDataType() {
            DataType[] dataTypeArray = DataType.values();
            int n = dataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataType dt = dataTypeArray[n2];
                this.dataTypes.put(dt, (EnumSet)dt.getOperations());
                ++n2;
            }
        }

        private void addEntityType() {
            this.entityTypes.put(EntityType.REQUIREMENT, "icon-chart-requirement");
            this.entityTypes.put(EntityType.REQUIREMENT_VERSION, "icon-chart-requirement-version");
            this.entityTypes.put(EntityType.TEST_CASE, "icon-chart-test-case");
            this.entityTypes.put(EntityType.CAMPAIGN, "icon-chart-campaign");
            this.entityTypes.put(EntityType.ITERATION, "icon-chart-iteration");
            this.entityTypes.put(EntityType.ITEM_TEST_PLAN, "icon-chart-item-test-plan");
            this.entityTypes.put(EntityType.EXECUTION, "icon-chart-execution");
        }

        public Map<EntityType, String> getEntityTypes() {
            return this.entityTypes;
        }

        public Map<ColumnRole, EnumSet<Operation>> getColumnRoles() {
            return this.columnRoles;
        }

        public Map<DataType, EnumSet<Operation>> getDataTypes() {
            return this.dataTypes;
        }

        public Map<EntityType, Set<QueryColumnPrototype>> getColumnPrototypes() {
            return this.columnPrototypes;
        }
    }
}

