/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportHeader;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;

public class CampaignExportRows {
    private static final String DEFAULT_VALUE = "n/a";
    private static final String DEFAULT_VALUE_CUF = "";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final boolean milestonesEnabled;
    private final Map<String, String> headers;
    private Map<String, String> currentRow = null;

    public CampaignExportRows(CampaignExportMode mode, boolean milestonesEnabled) {
        this.milestonesEnabled = milestonesEnabled;
        this.headers = this.getHeaders(mode);
    }

    private Map<String, String> getHeaders(CampaignExportMode mode) {
        switch (mode) {
            case STANDARD: {
                throw new UnsupportedOperationException("Standard export mode is not supported.");
            }
            case LIGHT: {
                throw new UnsupportedOperationException("Light export mode is not supported.");
            }
            case FULL: {
                break;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        return this.getColumnsCampaignFullExport(CampaignExportHeader.getFullExportHeaders());
    }

    private Map<String, String> getColumnsCampaignFullExport(List<CampaignExportHeader> headers) {
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        headers.forEach(header -> {
            if (CampaignExportHeader.isCufHeader(header) || this.skipMilestone((CampaignExportHeader)((Object)header))) {
                return;
            }
            columns.put(header.getHeaderName(), DEFAULT_VALUE);
        });
        return columns;
    }

    public void addCufHeaders(Map<BindableEntity, List<String>> cufCodesByBindableEntity) {
        if (cufCodesByBindableEntity.isEmpty()) {
            return;
        }
        this.addCufHeader(cufCodesByBindableEntity, BindableEntity.CAMPAIGN);
        this.addCufHeader(cufCodesByBindableEntity, BindableEntity.ITERATION);
        this.addCufHeader(cufCodesByBindableEntity, BindableEntity.TEST_CASE);
        this.addCufHeader(cufCodesByBindableEntity, BindableEntity.EXECUTION);
        this.addCufHeader(cufCodesByBindableEntity, BindableEntity.EXECUTION_STEP);
    }

    private void addCufHeader(Map<BindableEntity, List<String>> cufCodesByBindableEntity, BindableEntity bindableEntity) {
        if (cufCodesByBindableEntity.containsKey(bindableEntity)) {
            CampaignExportHeader header = CampaignExportHeader.fromBindableEntity(bindableEntity);
            cufCodesByBindableEntity.get(bindableEntity).forEach(code -> {
                String headerName = "%s%s".formatted(header.getHeaderName(), code);
                this.headers.put(headerName, DEFAULT_VALUE_CUF);
            });
        }
    }

    private boolean skipMilestone(CampaignExportHeader header) {
        return !this.milestonesEnabled && CampaignExportHeader.isMilestoneHeader(header);
    }

    public Collection<String> getHeaders() {
        return this.headers.keySet();
    }

    private void addValue(String headerName, String value) {
        if (Objects.isNull(this.currentRow)) {
            this.currentRow = new LinkedHashMap<String, String>(this.headers);
        }
        if (Objects.nonNull(value) && this.currentRow.containsKey(headerName)) {
            this.currentRow.replace(headerName, value);
        }
    }

    public void addValue(CampaignExportHeader header, String value) {
        this.addValue(header.getHeaderName(), value);
    }

    public void addValueLongText(CampaignExportHeader header, String value) {
        this.addValue(header, StringUtils.trimToEmpty((String)value));
    }

    public void addOrderValue(CampaignExportHeader header, int order) {
        this.addValue(header, order + 1);
    }

    public void addValue(CampaignExportHeader header, Date date) {
        String dateStr = Objects.isNull(date) ? DEFAULT_VALUE_CUF : this.dateFormat.format(date);
        this.addValue(header, dateStr);
    }

    public void addValue(CampaignExportHeader header, Object value) {
        if (Objects.nonNull(value)) {
            this.addValue(header, value.toString());
        }
    }

    public void addValueOrEmpty(CampaignExportHeader header, Object value) {
        if (Objects.nonNull(value)) {
            this.addValue(header, value.toString());
        } else {
            this.addValue(header, DEFAULT_VALUE_CUF);
        }
    }

    public void addValue(CampaignExportHeader header, List<CustomFieldValueDto> customFieldValueDtos) {
        customFieldValueDtos.forEach(cfv -> {
            String headerName = "%s%s".formatted(header.getHeaderName(), cfv.getCufCode());
            this.addValue(headerName, cfv.getValue());
        });
    }

    public Map<String, String> getRow() {
        LinkedHashMap<String, String> row;
        if (Objects.isNull(this.currentRow)) {
            row = new LinkedHashMap<String, String>(this.headers);
        } else {
            row = new LinkedHashMap<String, String>(this.currentRow);
            this.currentRow = null;
        }
        return row;
    }
}

