/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport.models;

import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;

public final class TestCaseModel {
    public static final Comparator<TestCaseModel> COMPARATOR = new Comparator<TestCaseModel>(){

        @Override
        public int compare(TestCaseModel o1, TestCaseModel o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };
    private Long projectId;
    private String projectName;
    private String path;
    private Integer order;
    private Long id;
    private String reference;
    private String name;
    private String milestone;
    private int weightAuto;
    private TestCaseImportance weight;
    private InfoListItem nature;
    private InfoListItem type;
    private TestCaseStatus status;
    private String description;
    private String prerequisite;
    private Long nbReq;
    private Long nbCaller;
    private Long nbAttachments;
    private Long nbIterations;
    private Long nbSprints;
    private Date createdOn;
    private String createdBy;
    private Date lastModifiedOn;
    private String lastModifiedBy;
    private List<ExportModel.CustomField> cufs = new LinkedList<ExportModel.CustomField>();
    private TestCaseKind testCaseKind;
    private String tcScript;
    private TestCaseAutomatable automatable;
    private String uuid;
    private boolean allowAutomationWorkflow;
    private Long datasetCount;
    private Long milestonesCount;
    private Long testStepCount;
    private Long parameter;
    private Long executionCount;
    private Integer priority;
    private Date transmissionDate;
    private String automationRequestStatus;
    private Long hasAutoScript;
    private String automatedTestTechno;
    private Long hasBoundScmRepository;
    private String hasBoundAutomatedTestReference;
    private String milestoneStatus;
    private String milestoneEndDate;
    private Long calledStepCount;
    private Long issueCount;
    private boolean draftedByAi;

    public TestCaseModel(Long projectId, Boolean allowAutomationWorkflow, String projectName, Integer order, Long id, String uuid, String reference, String name, String milestone, Boolean weightAuto, TestCaseImportance weight, InfoListItem nature, InfoListItem type, TestCaseStatus status, TestCaseAutomatable automatable, String description, String prerequisite, Long nbReq, Long nbCaller, Long nbAttachments, Long nbIterations, Long nbSprints, Date createdOn, String createdBy, Date lastModifiedOn, String lastModifiedBy, TestCaseKind testCaseKind, String tcScript, Long datasetCount, Long milestonesCount, Long testStepCount, Long parameter, Long executionCount, Integer priority, Date transmissionDate, String automationRequestStatus, Long hasAutoScript, String automatedTestTechno, Long hasBoundScmRepository, String hasBoundAutomatedTestReference, String milestoneStatus, String milestoneEndDate, Long calledStepCount, Long issueCount, Boolean draftedByAi) {
        this.projectId = projectId;
        this.allowAutomationWorkflow = allowAutomationWorkflow;
        this.projectName = projectName;
        this.order = order;
        this.id = id;
        this.uuid = uuid;
        this.reference = reference;
        this.name = name;
        this.milestone = milestone;
        this.weightAuto = Boolean.TRUE.equals(weightAuto) ? 1 : 0;
        this.weight = weight;
        this.nature = nature;
        this.type = type;
        this.status = status;
        this.automatable = automatable;
        this.description = description;
        this.prerequisite = prerequisite;
        this.nbReq = nbReq;
        this.nbCaller = nbCaller;
        this.nbAttachments = nbAttachments;
        this.nbIterations = nbIterations;
        this.nbSprints = nbSprints;
        this.createdOn = createdOn;
        this.createdBy = createdBy;
        this.lastModifiedOn = lastModifiedOn;
        this.lastModifiedBy = lastModifiedBy;
        this.testCaseKind = testCaseKind;
        this.datasetCount = datasetCount;
        this.milestonesCount = milestonesCount;
        this.testStepCount = testStepCount;
        this.parameter = parameter;
        this.executionCount = executionCount;
        this.priority = priority;
        this.transmissionDate = transmissionDate;
        this.automationRequestStatus = automationRequestStatus;
        this.hasAutoScript = hasAutoScript;
        this.automatedTestTechno = automatedTestTechno;
        this.hasBoundScmRepository = hasBoundScmRepository;
        this.hasBoundAutomatedTestReference = hasBoundAutomatedTestReference;
        this.milestoneStatus = milestoneStatus;
        this.milestoneEndDate = milestoneEndDate;
        this.calledStepCount = calledStepCount;
        this.issueCount = issueCount;
        this.draftedByAi = draftedByAi;
        if (TestCaseKind.GHERKIN.equals((Object)testCaseKind)) {
            this.tcScript = tcScript;
        }
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWeightAuto() {
        return this.weightAuto;
    }

    public void setWeightAuto(int weightAuto) {
        this.weightAuto = weightAuto;
    }

    public TestCaseImportance getWeight() {
        return this.weight;
    }

    public void setWeight(TestCaseImportance weight) {
        this.weight = weight;
    }

    public InfoListItem getNature() {
        return this.nature;
    }

    public void setNature(InfoListItem nature) {
        this.nature = nature;
    }

    public InfoListItem getType() {
        return this.type;
    }

    public void setType(InfoListItem type) {
        this.type = type;
    }

    public TestCaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(TestCaseStatus status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(String prerequisite) {
        this.prerequisite = prerequisite;
    }

    public Long getNbReq() {
        return this.nbReq;
    }

    public void setNbReq(Long nbReq) {
        this.nbReq = nbReq;
    }

    public Long getNbCaller() {
        return this.nbCaller;
    }

    public void setNbCaller(Long nbCaller) {
        this.nbCaller = nbCaller;
    }

    public Long getNbAttachments() {
        return this.nbAttachments;
    }

    public void setNbAttachments(Long nbAttachments) {
        this.nbAttachments = nbAttachments;
    }

    public Long getNbIterations() {
        return this.nbIterations;
    }

    public void setNbIterations(Long nbIterations) {
        this.nbIterations = nbIterations;
    }

    public Object getNbSprints() {
        return this.nbSprints;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public void addCuf(ExportModel.CustomField cuf) {
        this.cufs.add(cuf);
    }

    public List<ExportModel.CustomField> getCufs() {
        return this.cufs;
    }

    public TestCaseKind getTestCaseKind() {
        return this.testCaseKind;
    }

    public void setTestCaseKind(TestCaseKind testCaseKind) {
        this.testCaseKind = testCaseKind;
    }

    public String getTcScript() {
        return this.tcScript;
    }

    public void setTcScript(String tcScript) {
        this.tcScript = tcScript;
    }

    public TestCaseAutomatable getAutomatable() {
        return this.automatable;
    }

    public void setAutomatable(TestCaseAutomatable automatable) {
        this.automatable = automatable;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean getAllowAutomationWorkflow() {
        return this.allowAutomationWorkflow;
    }

    public Long getDatasetCount() {
        return this.datasetCount;
    }

    public Long getMilestonesCount() {
        return this.milestonesCount;
    }

    public Long getTestStepCount() {
        return this.testStepCount;
    }

    public Long getParameter() {
        return this.parameter;
    }

    public Long getExecutionCount() {
        return this.executionCount;
    }

    public Date getTransmissionDate() {
        return this.transmissionDate;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getAutomationRequestStatus() {
        return this.automationRequestStatus;
    }

    public Long getHasAutoScript() {
        return this.hasAutoScript;
    }

    public String getAutomatedTestTechno() {
        return this.automatedTestTechno;
    }

    public Long getHasBoundScmRepository() {
        return this.hasBoundScmRepository;
    }

    public String getHasBoundAutomatedTestReference() {
        return this.hasBoundAutomatedTestReference;
    }

    public String getMilestoneStatus() {
        return this.milestoneStatus;
    }

    public String getMilestoneEndDate() {
        return this.milestoneEndDate;
    }

    public Long getCalledStepCount() {
        return this.calledStepCount;
    }

    public Long getIssueCount() {
        return this.issueCount;
    }

    public boolean getDraftedByAi() {
        return this.draftedByAi;
    }
}

