/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd.robot.keywords;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.service.internal.testcase.bdd.TextGridFormatter;
import org.squashtest.tm.service.internal.testcase.bdd.robot.RobotSyntaxHelpers;
import org.squashtest.tm.service.internal.testcase.bdd.robot.SectionBuilderHelpers;

public final class RetrieveDatatablesKeywordBuilder {
    private static final String DATATABLE_ROW_PARAM_FORMAT = "row_%s_%s";
    private static final List<String> RETRIEVE_DATATABLES_DOCUMENTATION_LINES = Arrays.asList("Retrieves SquashTM's datatables and stores them in a dictionary.", "", "For instance, 2 datatables have been defined in SquashTM,", "the first one containing data:", "| name | firstName |", "| Bob  |   Smith   |", "the second one containing data", "| name  | firstName | age |", "| Alice |   Smith   | 45  |", "", "First, for each datatable, this keyword retrieves the values of each row", "and stores them in a list, as follows:", "@{row_1_1} =    Create List    name    firstName", "", "Then, for each datatable, this keyword creates a list containing all the rows,", "as lists themselves, as follows:", "@{datatable_1} =    Create List    ${row_1_1}    ${row_1_2}", "", "Finally, this keyword stores the datatables into the &{datatables} dictionary", "with each datatable name as key, and each datatable list as value :", "&{datatables} =    Create Dictionary    datatable_1=${datatable_1}    datatable_2=${datatable_2}");

    private RetrieveDatatablesKeywordBuilder() {
    }

    public static String buildRetrieveDatatables(KeywordTestCase keywordTestCase) {
        boolean isDatatableEnabled = SectionBuilderHelpers.isTestCaseUsingDatatables(keywordTestCase);
        if (isDatatableEnabled) {
            SectionBuilderHelpers.MultiLineStringBuilder stringBuilder = new SectionBuilderHelpers.MultiLineStringBuilder();
            List<String> datatables = RetrieveDatatablesKeywordBuilder.extractNonEmptyDatatables(keywordTestCase);
            return stringBuilder.appendNewLine().appendLine("Retrieve Datatables").append(SectionBuilderHelpers.formatDocumentationSettingLines(RETRIEVE_DATATABLES_DOCUMENTATION_LINES)).appendNewLine().append(RetrieveDatatablesKeywordBuilder.formatDatatables(datatables)).append(RetrieveDatatablesKeywordBuilder.formatDatatablesDictionaryDeclaration(datatables)).appendNewLine().appendLine("    RETURN    " + RobotSyntaxHelpers.dictionaryVariable("datatables")).toString();
        }
        return "";
    }

    private static String formatDatatables(List<String> datatables) {
        SectionBuilderHelpers.MultiLineStringBuilder multiLineStringBuilder = new SectionBuilderHelpers.MultiLineStringBuilder();
        int i = 0;
        while (i < datatables.size()) {
            String datatable = datatables.get(i);
            int tableNumber = i + 1;
            multiLineStringBuilder.append(RetrieveDatatablesKeywordBuilder.buildDatatableRowsDefinition(datatable, tableNumber));
            multiLineStringBuilder.appendNewLine();
            ++i;
        }
        return multiLineStringBuilder.toString();
    }

    private static String buildDatatableRowsDefinition(String datatable, int tableNumber) {
        TextGridFormatter rowsTextGridFormatter = new TextGridFormatter();
        ArrayList<String> tableVariableCells = new ArrayList<String>(List.of(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.listVariable(SectionBuilderHelpers.formatDatatableName(tableNumber))), "Create List"));
        List<List<String>> rows = RetrieveDatatablesKeywordBuilder.extractRowsFromDataTable(datatable);
        int rowNumber = 1;
        for (List<String> row : rows) {
            String datatableRowIdentifier = String.format(DATATABLE_ROW_PARAM_FORMAT, tableNumber, rowNumber);
            tableVariableCells.add(RobotSyntaxHelpers.scalarVariable(datatableRowIdentifier));
            ArrayList<String> rowVariables = new ArrayList<String>(List.of(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.listVariable(datatableRowIdentifier)), "Create List"));
            rowVariables.addAll(row);
            rowsTextGridFormatter.addRow(rowVariables);
            ++rowNumber;
        }
        String formattedDatatableAssignment = new TextGridFormatter().addRow(tableVariableCells).format(TextGridFormatter.withRowPrefix("    "));
        return new SectionBuilderHelpers.MultiLineStringBuilder().append(rowsTextGridFormatter.format(TextGridFormatter.withRowPrefix("    "))).append(formattedDatatableAssignment).toString();
    }

    private static List<String> extractNonEmptyDatatables(KeywordTestCase keywordTestCase) {
        return keywordTestCase.getSteps().stream().map(step -> ((KeywordTestStep)step).getDatatable()).filter(datatable -> !Strings.isBlank((String)datatable)).toList();
    }

    private static List<List<String>> extractRowsFromDataTable(String datatableAsString) {
        String[] rowsAsString = datatableAsString.split("\n");
        ArrayList<List<String>> dataTable = new ArrayList<List<String>>(rowsAsString.length);
        String[] stringArray = rowsAsString;
        int n = rowsAsString.length;
        int n2 = 0;
        while (n2 < n) {
            String rowAsString = stringArray[n2];
            String[] rowParts = RetrieveDatatablesKeywordBuilder.splitOnUnescapedPipes(rowAsString);
            List<String> dataRow = Arrays.stream(rowParts).filter(part -> !Strings.isBlank((String)part)).map(String::trim).map(RetrieveDatatablesKeywordBuilder::withUnescapedPipeCharacters).map(RetrieveDatatablesKeywordBuilder::withEscapedSpecialCharacters).toList();
            dataTable.add(dataRow);
            ++n2;
        }
        return dataTable;
    }

    private static String withUnescapedPipeCharacters(String input) {
        StringBuilder sb = new StringBuilder();
        int position = 0;
        while (position < input.length()) {
            boolean nextIsPipe;
            char c = input.charAt(position);
            boolean bl = nextIsPipe = position + 1 < input.length() && input.charAt(position + 1) == '|';
            if (c == '\\' && nextIsPipe) {
                sb.append('|');
                position += 2;
                continue;
            }
            sb.append(c);
            ++position;
        }
        return sb.toString();
    }

    private static String withEscapedSpecialCharacters(String input) {
        StringBuilder sb = new StringBuilder();
        int position = 0;
        while (position < input.length()) {
            char c = input.charAt(position);
            if (RetrieveDatatablesKeywordBuilder.isSpecialCharacter(c)) {
                sb.append('\\');
            }
            sb.append(c);
            ++position;
        }
        return sb.toString();
    }

    private static boolean isSpecialCharacter(char c) {
        return "$@&%#=\\".indexOf(c) >= 0;
    }

    private static String[] splitOnUnescapedPipes(String rowAsString) {
        return rowAsString.split("(?<!\\\\)\\|");
    }

    private static String formatDatatablesDictionaryDeclaration(List<String> datatables) {
        ArrayList<String> cells = new ArrayList<String>();
        cells.add(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.dictionaryVariable("datatables")));
        cells.add("Create Dictionary");
        int i = 0;
        while (i < datatables.size()) {
            int tableNumber = i + 1;
            String datatableName = SectionBuilderHelpers.formatDatatableName(tableNumber);
            String entry = datatableName + "=" + RobotSyntaxHelpers.scalarVariable(datatableName);
            cells.add(entry);
            ++i;
        }
        TextGridFormatter textGridFormatter = new TextGridFormatter();
        textGridFormatter.addRow(cells);
        return textGridFormatter.format(TextGridFormatter.withRowPrefix("    "));
    }
}

