/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.internal.dto.resultimport.AttachmentDto;
import org.squashtest.tm.service.internal.dto.resultimport.PartialErrorDto;
import org.squashtest.tm.service.testautomation.resultimport.AttachmentContentVerificationService;

@Service
public class AttachmentImportHelper {
    @Inject
    private AttachmentContentVerificationService uploadContentFilter;

    public void deduplicateAttachmentNames(List<AttachmentDto> attachments) {
        List<String> attachmentNames = attachments.stream().map(AttachmentDto::getName).toList();
        List uniqueAttachmentNames = attachmentNames.stream().distinct().toList();
        HashMap<String, Integer> uniqueNameCounts = new HashMap<String, Integer>();
        for (String name : uniqueAttachmentNames) {
            uniqueNameCounts.put(name, 1);
        }
        if (attachmentNames.size() != uniqueAttachmentNames.size()) {
            int i = 0;
            while (i < attachments.size()) {
                AttachmentDto attachment = attachments.get(i);
                String filename = attachment.getName();
                if (attachmentNames.indexOf(filename) != i) {
                    String baseName = FilenameUtils.getBaseName((String)filename);
                    String extension = FilenameUtils.getExtension((String)filename);
                    attachment.setName(baseName + "(" + String.valueOf(uniqueNameCounts.get(filename)) + ")." + extension);
                    uniqueNameCounts.merge(filename, 1, Integer::sum);
                }
                ++i;
            }
        }
    }

    public UploadedData decodeBase64AttachmentContent(AttachmentDto attachmentDto) {
        ByteArrayInputStream stream = new ByteArrayInputStream(Base64.getDecoder().decode(attachmentDto.getContent().getBytes(StandardCharsets.UTF_8)));
        String name = attachmentDto.getName();
        long sizeInBytes = attachmentDto.getContent().length();
        return new UploadedData(stream, name, sizeInBytes);
    }

    public boolean isValidAutomatedSuiteAttachment(PartialErrorDto partialErrors, AttachmentDto attachmentDto) {
        boolean valid = true;
        if (attachmentDto.getName() == null || attachmentDto.getName().isBlank()) {
            partialErrors.addNewTestError(null, null, "Automated suite attachment name cannot be empty");
            return false;
        }
        if (attachmentDto.getContent() == null || attachmentDto.getContent().isBlank()) {
            valid = false;
            partialErrors.addNewTestError(null, null, "Automated suite attachment content cannot be empty");
            return false;
        }
        if (!this.uploadContentFilter.isTypeAllowedForAutomatedSuiteImport(attachmentDto.getName())) {
            valid = false;
            partialErrors.addNewTestError(null, null, "Automated suite attachment type is not allowed: '%s'. Allowed types are: %s".formatted(attachmentDto.getName(), Arrays.toString(this.uploadContentFilter.getAllowedExtensionsForAutomatedSuites())));
        }
        if (!this.uploadContentFilter.isSizeAllowed(attachmentDto.getContent())) {
            valid = false;
            partialErrors.addNewTestError(null, null, "Automated suite attachment '%s' cannot exceed the size limit of %d bytes. Current size: %s bytes.".formatted(attachmentDto.getName(), this.uploadContentFilter.getMaxUploadSizeInBytes(), attachmentDto.getContent().getBytes().length));
        }
        return valid;
    }

    public boolean isValidExecutionAttachment(Long testCaseId, String automatedTestRef, String fullTestIdentifier, PartialErrorDto partialErrors, AttachmentDto attachmentDto) {
        boolean valid = true;
        if (AttachmentImportHelper.isInvalidAttachmentName(attachmentDto.getName())) {
            partialErrors.addNewTestError(testCaseId, automatedTestRef, "Test %s cannot have an attachment with an empty name.".formatted(fullTestIdentifier));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)attachmentDto.getContent())) {
            partialErrors.addNewTestError(testCaseId, automatedTestRef, "Test %s cannot have an attachment with no content.".formatted(fullTestIdentifier));
            return false;
        }
        if (!this.uploadContentFilter.isTypeAllowedForExecutionImport(attachmentDto.getName())) {
            valid = false;
            partialErrors.addNewTestError(testCaseId, automatedTestRef, "Test %s cannot have an attachment of type '%s'. Allowed types are: %s".formatted(fullTestIdentifier, attachmentDto.getName(), Arrays.toString(this.uploadContentFilter.getAllowedExtensionsForExecutions())));
        }
        if (!this.uploadContentFilter.isSizeAllowed(attachmentDto.getContent())) {
            valid = false;
            partialErrors.addNewTestError(testCaseId, automatedTestRef, "Attachment '%s' of test %s cannot exceed the size limit of %d bytes. Current size: %s bytes.".formatted(attachmentDto.getName(), fullTestIdentifier, this.uploadContentFilter.getMaxUploadSizeInBytes(), attachmentDto.getContent().getBytes().length));
        }
        return valid;
    }

    private static boolean isInvalidAttachmentName(String attachmentDtoName) {
        return StringUtils.isBlank((CharSequence)attachmentDtoName);
    }
}

