/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Iteration;
import org.squashtest.tm.jooq.domain.tables.TestPlanItem;
import org.squashtest.tm.service.grid.ColumnIds;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridSort;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterConditionBuilder;
import org.squashtest.tm.service.internal.display.search.filter.ItpiExecutionScopeFilterHandler;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateCampaignDao;

@Repository
public class CustomItpiLastExecutionFilterDaoImpl
implements CustomItpiLastExecutionFilterDao {
    private static final List<EntityType> scopableEntityList = Arrays.asList(EntityType.ITERATION, EntityType.CAMPAIGN, EntityType.CAMPAIGN_FOLDER, EntityType.CAMPAIGN_LIBRARY, EntityType.SPRINT, EntityType.SPRINT_GROUP, EntityType.PROJECT, EntityType.TEST_SUITE, EntityType.EXECUTION);
    private static final String RANKED_IDS = "ranked_ids";
    private static final String EXECUTION_ON = "executionOn";
    private static final String ITEM_TEST_PLAN_EXECUTION_SCOPE = "itemTestPlanExecutionScope";
    private static final String TEST_PLAN_ID = "TEST_PLAN_ID";
    public static final String EXECUTION_STATUS_PRIORITY = "EXECUTION_STATUS_PRIORITY";
    @Inject
    HibernateCampaignDao campaignDao;
    @Inject
    SprintDao sprintDao;
    private final DSLContext dsl;

    public CustomItpiLastExecutionFilterDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public List<Long> gatherLatestItpiIdsForTCInScopeForCampaign(List<Long> campaignIds) {
        TestPlanItem itp = Tables.TEST_PLAN_ITEM.as("ITERATION_TEST_PLAN_ITEM");
        Table rankedIds = this.dsl.select((SelectField)itp.TEST_PLAN_ITEM_ID.as("ID"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{itp.TCLN_ID, itp.DATASET_ID}).orderBy(new OrderField[]{itp.LAST_EXECUTED_ON.desc().nullsLast(), itp.CREATED_ON.desc(), itp.TEST_PLAN_ITEM_ID.desc()})).as("ROW_NUMBER")).from((TableLike)Tables.CAMPAIGN).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).innerJoin((TableLike)Iteration.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Iteration.ITERATION.ITERATION_ID)).innerJoin((TableLike)itp).on(Iteration.ITERATION.TEST_PLAN_ID.eq((Field)itp.TEST_PLAN_ID)).where(Tables.CAMPAIGN.CLN_ID.in(campaignIds)).asTable(RANKED_IDS);
        return this.dsl.select((SelectField)rankedIds.field("ID", Long.class)).from((TableLike)rankedIds).where(rankedIds.field("ROW_NUMBER", Integer.TYPE).eq((Object)1)).fetchInto(Long.class);
    }

    @Override
    public List<Long> gatherLatestItpiIdsForTCInScopeForIteration(List<Long> iterationIds) {
        TestPlanItem itp = Tables.TEST_PLAN_ITEM.as("ITERATION_TEST_PLAN_ITEM");
        Table rankedIds = this.dsl.select((SelectField)itp.TEST_PLAN_ITEM_ID.as("ID"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{itp.TCLN_ID, itp.DATASET_ID}).orderBy(new OrderField[]{itp.LAST_EXECUTED_ON.desc().nullsLast(), itp.CREATED_ON.desc(), itp.TEST_PLAN_ITEM_ID.desc()})).as("ROW_NUMBER")).from((TableLike)Iteration.ITERATION).innerJoin((TableLike)itp).on(Iteration.ITERATION.TEST_PLAN_ID.eq((Field)itp.TEST_PLAN_ID)).where(Iteration.ITERATION.ITERATION_ID.in(iterationIds)).asTable(RANKED_IDS);
        return this.dsl.select((SelectField)rankedIds.field("ID", Long.class)).from((TableLike)rankedIds).where(rankedIds.field("ROW_NUMBER", Integer.TYPE).eq((Object)1)).fetchInto(Long.class);
    }

    @Override
    public List<Long> gatherLatestItpiIdsForTCInScopeForTestSuite(List<Long> testSuiteIds) {
        Table rankedIds = this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("ID"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.DATASET_ID}).orderBy(new OrderField[]{Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON.desc().nullsLast(), Tables.TEST_PLAN_ITEM.CREATED_ON.desc(), Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.desc()})).as("ROW_NUMBER")).from((TableLike)Tables.TEST_SUITE).innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.TEST_SUITE.ID.in(testSuiteIds)).asTable(RANKED_IDS);
        return this.dsl.select((SelectField)rankedIds.field("ID", Long.class)).from((TableLike)rankedIds).where(rankedIds.field("ROW_NUMBER", Integer.TYPE).eq((Object)1)).fetchInto(Long.class);
    }

    @Override
    public List<Long> gatherLatestItpiIdsForTCInDynamicScope(Map<EntityType, List<Long>> scopableEntitiesMap) {
        SelectJoinStep subquery = this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("ID"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.DATASET_ID}).orderBy(new OrderField[]{Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON.desc().nullsLast(), Tables.TEST_PLAN_ITEM.CREATED_ON.desc(), Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.desc()})).as("ROW_NUMBER")).from((TableLike)Tables.TEST_PLAN_ITEM);
        if (!scopableEntitiesMap.isEmpty()) {
            Condition whereClause = this.appendJoinClausesByScopeAndBuildWhereCondition(scopableEntitiesMap, subquery);
            subquery.where(whereClause);
        }
        return this.dsl.select((SelectField)subquery.field("ID", Long.class)).from((TableLike)subquery).where(DSL.field((Name)DSL.name((String)"ROW_NUMBER")).eq((Object)1)).fetchInto(Long.class);
    }

    @Override
    public Table<?> getTableForTCInDynamicScope(GridRequest request) {
        EnumMap<EntityType, List<Long>> scopableEntitiesMap = new EnumMap<EntityType, List<Long>>(EntityType.class);
        scopableEntityList.forEach(entityType -> ItpiExecutionScopeFilterHandler.extractEntityIdsFromScope(request.getScope(), scopableEntitiesMap, entityType));
        if (!request.getExcludedScope().isEmpty()) {
            ItpiExecutionScopeFilterHandler.extractEntityIdsFromScope(request.getExcludedScope(), scopableEntitiesMap, EntityType.TEST_SUITE);
        }
        return this.gatherLatestItpiIdsForTCInDynamicScopeAsTable(scopableEntitiesMap, request);
    }

    private Table<?> gatherLatestItpiIdsForTCInDynamicScopeAsTable(Map<EntityType, List<Long>> scopableEntitiesMap, GridRequest request) {
        SelectJoinStep subquery = this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("LATEST_EXECUTION_ID"), (SelectField)Tables.TEST_PLAN_ITEM.ASSIGNEE_ID.as("USER"), (SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID.as("TEST_CASE_ID"), (SelectField)Tables.TEST_PLAN_ITEM.DATASET_ID.as("DATASET_ID"), (SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.as("EXECUTION_STATUS"), (SelectField)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON.as("LAST_EXECUTED_ON"), (SelectField)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY.as("LAST_EXECUTED_BY"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.DATASET_ID}).orderBy(new OrderField[]{Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON.desc().nullsLast(), Tables.TEST_PLAN_ITEM.CREATED_ON.desc(), Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.desc()})).as("ROW_NUMBER"), (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.as(TEST_PLAN_ID)).from((TableLike)Tables.TEST_PLAN_ITEM);
        if (!scopableEntitiesMap.isEmpty()) {
            Condition whereClause = this.appendJoinClausesByScopeAndBuildWhereCondition(scopableEntitiesMap, subquery);
            subquery.where(whereClause);
        }
        Table<?> latestItpiIdsSubquery = subquery.asTable("LATEST_ITPI_IDS_SUBQUERY");
        latestItpiIdsSubquery = this.addOptionalFilterToQuery(latestItpiIdsSubquery, request);
        Condition combinedCondition = this.craftVariableFiltersConditionsForQuery(latestItpiIdsSubquery, request);
        return this.dsl.select(this.buildDynamicFields(latestItpiIdsSubquery, request)).from(latestItpiIdsSubquery).where(latestItpiIdsSubquery.field("ROW_NUMBER", Integer.class).eq((Object)1)).and(combinedCondition).asTable(RANKED_IDS);
    }

    private Condition craftVariableFiltersConditionsForQuery(Table<?> latestItpiIdsSubquery, GridRequest request) {
        return request.getFilterValues().stream().filter(filter -> !ITEM_TEST_PLAN_EXECUTION_SCOPE.equals(filter.getId())).map(filter -> this.convertFilterToConditionTest(latestItpiIdsSubquery, (GridFilterValue)filter)).reduce(Condition::and).orElse(DSL.noCondition());
    }

    protected Condition convertFilterToConditionTest(Table<?> latestItpiIdsSubquery, GridFilterValue gridFilterValue) {
        String id = gridFilterValue.getId();
        GridColumn gridColumn = Objects.requireNonNull(this.createAliasToFieldDictionary(latestItpiIdsSubquery).get(id));
        Field field = gridColumn.getNativeField();
        if (EXECUTION_ON.equals(id) || ColumnIds.MILESTONES_END_DATE.getColumnId().equals(id)) {
            field = DSL.timestamp(field);
        }
        return GridFilterConditionBuilder.getConditionBuilder(field, gridFilterValue).build();
    }

    protected Map<String, GridColumn> createAliasToFieldDictionary(Table<?> latestItpiIdsSubquery) {
        return this.getGridColumnsForFilters(latestItpiIdsSubquery).stream().collect(Collectors.toMap(GridColumn::findRuntimeAlias, column -> column));
    }

    private Condition appendJoinClausesByScopeAndBuildWhereCondition(Map<EntityType, List<Long>> scopableEntitiesMap, SelectJoinStep<?> subquery) {
        Condition whereCondition = DSL.noCondition();
        for (Map.Entry<EntityType, List<Long>> entityScope : scopableEntitiesMap.entrySet()) {
            this.appendJoinClausesByEntityType(entityScope, subquery);
            whereCondition = this.appendWhereClause(entityScope, whereCondition);
        }
        return whereCondition;
    }

    private void appendJoinClausesByEntityType(Map.Entry<EntityType, List<Long>> entityScope, SelectJoinStep<?> subquery) {
        int index = scopableEntityList.indexOf(entityScope.getKey());
        int i = 0;
        while (i <= index) {
            this.appendJoinClauseIfMissing(subquery, scopableEntityList.get(i));
            ++i;
        }
    }

    private void appendJoinClauseIfMissing(SelectJoinStep<?> subquery, EntityType entityType) {
        switch (entityType) {
            case ITERATION: {
                if (subquery.getSQL().toUpperCase().contains(Tables.ITERATION.ITERATION_ID.getName())) break;
                subquery.leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID));
                break;
            }
            case CAMPAIGN: 
            case CAMPAIGN_FOLDER: {
                if (subquery.getSQL().toUpperCase().contains(Tables.CAMPAIGN_ITERATION.getName())) break;
                subquery.leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID));
                break;
            }
            case CAMPAIGN_LIBRARY: 
            case PROJECT: 
            case SPRINT: 
            case SPRINT_GROUP: {
                if (subquery.getSQL().toUpperCase().contains(Tables.CAMPAIGN_LIBRARY_NODE.getName())) break;
                subquery.leftJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).or(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID));
                break;
            }
            case TEST_SUITE: {
                if (subquery.getSQL().toUpperCase().contains(Tables.TEST_SUITE_TEST_PLAN_ITEM.getName())) break;
                subquery.leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID));
                break;
            }
        }
    }

    private Condition appendWhereClause(Map.Entry<EntityType, List<Long>> entityScope, Condition whereCondition) {
        List<Long> ids = entityScope.getValue();
        return switch (entityScope.getKey()) {
            case EntityType.ITERATION -> whereCondition.or(Tables.ITERATION.ITERATION_ID.in(ids));
            case EntityType.CAMPAIGN -> whereCondition.or(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(ids));
            case EntityType.SPRINT -> whereCondition.or(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(ids));
            case EntityType.SPRINT_GROUP -> this.getSprintGroupWhereCondition(whereCondition, ids);
            case EntityType.CAMPAIGN_FOLDER -> this.getFolderWhereCondition(whereCondition, ids);
            case EntityType.CAMPAIGN_LIBRARY, EntityType.PROJECT -> whereCondition.or(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(ids));
            case EntityType.TEST_SUITE -> whereCondition.or(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.in(ids));
            default -> whereCondition;
        };
    }

    private Condition getSprintGroupWhereCondition(Condition whereCondition, List<Long> sprintGroupIds) {
        List<Long> sprintIds = this.sprintDao.findAllSprintIdsBySprintGroupIds(sprintGroupIds);
        return whereCondition.or(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(sprintIds));
    }

    private Condition getFolderWhereCondition(Condition whereCondition, List<Long> ids) {
        List<Long> campaignIdsInFolder = this.campaignDao.findAllCampaignIdsByNodeIds(ids);
        return whereCondition.or(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(campaignIdsInFolder));
    }

    private Table<?> addOptionalFilterToQuery(Table<?> latestItpiIdsSubquery, GridRequest gridRequest) {
        boolean campaignLibraryNodeJoinsApplied = false;
        boolean commonJoinsApplied = false;
        boolean milestoneJoinsApplied = false;
        boolean coreUserJoinsApplied = false;
        Set<String> campaignLibraryNodeFields = Set.of("CAMPAIGN_NAME", "SPRINT_NAME", "CAMPAIGN_LIBRARY_PROJECT_NAME");
        Set<String> milestoneFields = Set.of("CAMPAIGN_MILESTONE_ID", "CAMPAIGN_MILESTONE_STATUS", "CAMPAIGN_MILESTONE_END_DATE");
        if (this.isTestCaseJoinRequired(gridRequest, true)) {
            latestItpiIdsSubquery = latestItpiIdsSubquery.leftJoin((TableLike)Tables.TEST_CASE).on(latestItpiIdsSubquery.field("TEST_CASE_ID", Long.class).eq((Field)Tables.TEST_CASE.TCLN_ID));
        }
        LinkedHashSet<String> columnPrototypes = new LinkedHashSet<String>();
        for (GridSort sort : gridRequest.getSort()) {
            columnPrototypes.add(sort.getColumnPrototype());
        }
        for (GridFilterValue filter : gridRequest.getFilterValues()) {
            columnPrototypes.add(filter.getColumnPrototype());
        }
        Iterator<Object> iterator = columnPrototypes.iterator();
        block25: while (iterator.hasNext()) {
            String value;
            switch (value = (String)iterator.next()) {
                case "TEST_CASE_NAME": {
                    latestItpiIdsSubquery = latestItpiIdsSubquery.leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
                    break;
                }
                case "AUTOMATION_REQUEST_STATUS": {
                    latestItpiIdsSubquery = latestItpiIdsSubquery.leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID));
                    break;
                }
                case "DATASET_NAME": {
                    latestItpiIdsSubquery = latestItpiIdsSubquery.leftJoin((TableLike)Tables.DATASET).on(latestItpiIdsSubquery.field("DATASET_ID", Long.class).eq((Field)Tables.DATASET.DATASET_ID));
                    break;
                }
                case "EXECUTION_EXECUTION_MODE": {
                    latestItpiIdsSubquery = latestItpiIdsSubquery.leftJoin((TableLike)Tables.EXECUTION).on(latestItpiIdsSubquery.field("LATEST_EXECUTION_ID", Long.class).eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID));
                    break;
                }
                case "ITEM_TEST_PLAN_TESTER": 
                case "ITERATION_TEST_PLAN_ASSIGNED_USER_LOGIN": {
                    if (coreUserJoinsApplied) break;
                    latestItpiIdsSubquery = latestItpiIdsSubquery.leftJoin((TableLike)Tables.CORE_USER).on(latestItpiIdsSubquery.field("USER", Long.class).eq((Field)Tables.CORE_USER.PARTY_ID));
                    coreUserJoinsApplied = true;
                    break;
                }
                case "CAMPAIGN_MILESTONE_END_DATE": 
                case "ITERATION_NAME": 
                case "CAMPAIGN_MILESTONE_STATUS": 
                case "CAMPAIGN_NAME": 
                case "CAMPAIGN_LIBRARY_PROJECT_NAME": 
                case "CAMPAIGN_MILESTONE_ID": 
                case "SPRINT_NAME": {
                    if (!commonJoinsApplied) {
                        latestItpiIdsSubquery = latestItpiIdsSubquery.leftJoin((TableLike)Iteration.ITERATION).on(latestItpiIdsSubquery.field(TEST_PLAN_ID, Long.class).eq((Field)Iteration.ITERATION.TEST_PLAN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Iteration.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(latestItpiIdsSubquery.field(TEST_PLAN_ID, Long.class).eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID));
                        commonJoinsApplied = true;
                    }
                    if (milestoneFields.contains(value) && !milestoneJoinsApplied) {
                        latestItpiIdsSubquery = latestItpiIdsSubquery.leftJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID));
                        milestoneJoinsApplied = true;
                    }
                    if (!campaignLibraryNodeFields.contains(value) || campaignLibraryNodeJoinsApplied) continue block25;
                    latestItpiIdsSubquery = latestItpiIdsSubquery.leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).or(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID))).leftJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID));
                    campaignLibraryNodeJoinsApplied = true;
                    break;
                }
            }
        }
        return latestItpiIdsSubquery;
    }

    private boolean isTestCaseJoinRequired(GridRequest gridRequest, boolean addAutomationRequestStatus) {
        ArrayList<String> columnsThatNeedJoinToTestCase = new ArrayList<String>(List.of("TEST_CASE_ID", "TEST_CASE_REFERENCE", "TEST_CASE_NAME", "TEST_CASE_IMPORTANCE", "TEST_CASE_AUTOMATABLE"));
        if (addAutomationRequestStatus) {
            columnsThatNeedJoinToTestCase.add("AUTOMATION_REQUEST_STATUS");
        }
        return Stream.concat(gridRequest.getFilterValues().stream().map(GridFilterValue::getColumnPrototype), gridRequest.getSort().stream().map(GridSort::getColumnPrototype)).anyMatch(columnsThatNeedJoinToTestCase::contains);
    }

    private List<Field<?>> buildDynamicFields(Table<?> latestItpiIdsSubquery, GridRequest request) {
        Field customOrderField = DSL.case_().when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.READY.name()), (Object)1).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.RUNNING.name()), (Object)2).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.SUCCESS.name()), (Object)3).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.WARNING.name()), (Object)4).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.SETTLED.name()), (Object)5).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.SKIPPED.name()), (Object)6).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.CANCELLED.name()), (Object)7).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.FAILURE.name()), (Object)8).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.BLOCKED.name()), (Object)10).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.NOT_RUN.name()), (Object)11).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.ERROR.name()), (Object)12).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.UNTESTABLE.name()), (Object)13).when(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class).eq((Object)ExecutionStatus.NOT_FOUND.name()), (Object)14).otherwise((Object)-1000);
        Field customImportancemOrderField = DSL.case_().when(Tables.TEST_CASE.IMPORTANCE.eq((Object)TestCaseImportance.VERY_HIGH.name()), (Object)1).when(Tables.TEST_CASE.IMPORTANCE.eq((Object)TestCaseImportance.HIGH.name()), (Object)2).when(Tables.TEST_CASE.IMPORTANCE.eq((Object)TestCaseImportance.MEDIUM.name()), (Object)3).when(Tables.TEST_CASE.IMPORTANCE.eq((Object)TestCaseImportance.LOW.name()), (Object)4).otherwise((Object)-1000);
        ArrayList fields = new ArrayList();
        fields.add(latestItpiIdsSubquery.field("LATEST_EXECUTION_ID", Long.class));
        fields.add(latestItpiIdsSubquery.field("USER", Long.class));
        fields.add(latestItpiIdsSubquery.field("TEST_CASE_ID", Long.class));
        fields.add(latestItpiIdsSubquery.field("ROW_NUMBER", Long.class));
        fields.add(latestItpiIdsSubquery.field("EXECUTION_STATUS", Long.class));
        fields.add(latestItpiIdsSubquery.field("LAST_EXECUTED_ON", Long.class));
        fields.add(latestItpiIdsSubquery.field("LAST_EXECUTED_BY", Long.class));
        fields.add(customOrderField.as(EXECUTION_STATUS_PRIORITY));
        LinkedHashSet<String> columnPrototypes = new LinkedHashSet<String>();
        boolean coreUserJoinsApplied = false;
        for (GridSort sort : request.getSort()) {
            columnPrototypes.add(sort.getColumnPrototype());
        }
        for (GridFilterValue filter : request.getFilterValues()) {
            columnPrototypes.add(filter.getColumnPrototype());
        }
        if (this.isTestCaseJoinRequired(request, false)) {
            fields.add((Field<?>)Tables.TEST_CASE.TCLN_ID);
            fields.add(Tables.TEST_CASE.REFERENCE.as("TEST_CASE_REFERENCE"));
            fields.add(Tables.TEST_CASE.AUTOMATABLE.as("TEST_CASE_AUTOMATABLE"));
            fields.add(customImportancemOrderField.as("TEST_CASE_IMPORTANCE"));
        }
        Iterator<Object> iterator = columnPrototypes.iterator();
        while (iterator.hasNext()) {
            String value;
            switch (value = (String)iterator.next()) {
                case "TEST_CASE_NAME": {
                    fields.add(Tables.TEST_CASE_LIBRARY_NODE.NAME.as("TEST_CASE_NAME"));
                    break;
                }
                case "DATASET_NAME": {
                    fields.add(Tables.DATASET.NAME.as("DATASET_NAME"));
                    break;
                }
                case "EXECUTION_EXECUTION_MODE": {
                    fields.add(Tables.EXECUTION.EXECUTION_MODE.as("EXECUTION_EXECUTION_MODE"));
                    break;
                }
                case "AUTOMATION_REQUEST_STATUS": {
                    fields.add(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.as("AUTOMATION_REQUEST_STATUS"));
                    break;
                }
                case "ITEM_TEST_PLAN_TESTER": 
                case "ITERATION_TEST_PLAN_ASSIGNED_USER_LOGIN": {
                    if (coreUserJoinsApplied) break;
                    fields.add(Tables.CORE_USER.LOGIN.as("ITERATION_TEST_PLAN_ASSIGNED_USER_LOGIN"));
                    coreUserJoinsApplied = true;
                    break;
                }
                case "ITERATION_NAME": {
                    fields.add(Iteration.ITERATION.NAME.as("ITERATION_NAME"));
                    break;
                }
                case "CAMPAIGN_NAME": {
                    fields.add(Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("CAMPAIGN_NAME"));
                    break;
                }
                case "SPRINT_NAME": {
                    fields.add(Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("SPRINT_NAME"));
                    break;
                }
                case "CAMPAIGN_LIBRARY_PROJECT_NAME": {
                    fields.add(Tables.PROJECT.NAME.as("CAMPAIGN_LIBRARY_PROJECT_NAME"));
                    break;
                }
                case "CAMPAIGN_MILESTONE_ID": {
                    fields.add(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.as("CAMPAIGN_MILESTONE_ID"));
                    break;
                }
                case "CAMPAIGN_MILESTONE_STATUS": {
                    fields.add(Tables.MILESTONE.STATUS.as("CAMPAIGN_MILESTONE_STATUS"));
                    break;
                }
                case "CAMPAIGN_MILESTONE_END_DATE": {
                    fields.add(Tables.MILESTONE.END_DATE.as("CAMPAIGN_MILESTONE_END_DATE"));
                    break;
                }
            }
        }
        return fields;
    }

    protected List<GridColumn> getGridColumnsForFilters(Table<?> latestItpiIdsSubquery) {
        return List.of(new GridColumn((Field<?>)latestItpiIdsSubquery.field("TEST_CASE_ID", Long.class).as("ID"), (Field<?>)Tables.TEST_CASE.TCLN_ID), new GridColumn((Field<?>)Tables.TEST_CASE.REFERENCE), new GridColumn((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME), new GridColumn((Field<?>)Tables.TEST_CASE.AUTOMATABLE), new GridColumn((Field<?>)Tables.TEST_CASE.IMPORTANCE), new GridColumn((Field<?>)Tables.AUTOMATION_REQUEST.REQUEST_STATUS.as("AUTOMATION_REQUEST_STATUS"), (Field<?>)Tables.AUTOMATION_REQUEST.REQUEST_STATUS), new GridColumn((Field<?>)latestItpiIdsSubquery.field("USER", Long.class).as("ASSIGNEE"), (Field<?>)Tables.CORE_USER.LOGIN), new GridColumn(latestItpiIdsSubquery.field("LAST_EXECUTED_ON", Timestamp.class).as("EXECUTION_ON"), latestItpiIdsSubquery.field("LAST_EXECUTED_ON")), new GridColumn(latestItpiIdsSubquery.field("LAST_EXECUTED_BY", String.class).as("EXECUTED_BY"), latestItpiIdsSubquery.field("LAST_EXECUTED_BY")), new GridColumn((Field<?>)Tables.EXECUTION.EXECUTION_MODE.as("INFERRED_EXECUTION_MODE"), (Field<?>)Tables.EXECUTION.EXECUTION_MODE), new GridColumn(latestItpiIdsSubquery.field("EXECUTION_STATUS", String.class), latestItpiIdsSubquery.field("EXECUTION_STATUS")), new GridColumn((Field<?>)Tables.MILESTONE.MILESTONE_ID.as("MILESTONE_LABEL"), (Field<?>)Tables.MILESTONE.MILESTONE_ID), new GridColumn((Field<?>)Tables.MILESTONE.STATUS.as("MILESTONE_STATUS"), (Field<?>)Tables.MILESTONE.STATUS), new GridColumn((Field<?>)Tables.MILESTONE.END_DATE.as("MILESTONE_END_DATE"), (Field<?>)Tables.MILESTONE.END_DATE));
    }

    protected List<GridColumn> getColumnsForSort(Table<?> rankedIds) {
        return List.of(new GridColumn(Tables.TEST_CASE_LIBRARY_NODE.NAME.as("LABEL"), rankedIds.field("TEST_CASE_NAME")), new GridColumn((Field<?>)Tables.TEST_CASE.REFERENCE, (Field<?>)rankedIds.field("TEST_CASE_REFERENCE")), new GridColumn((Field<?>)Tables.TEST_CASE.AUTOMATABLE, (Field<?>)rankedIds.field("TEST_CASE_AUTOMATABLE")), new GridColumn((Field<?>)Tables.TEST_CASE.IMPORTANCE, (Field<?>)rankedIds.field("TEST_CASE_IMPORTANCE")), new GridColumn((Field<?>)Tables.AUTOMATION_REQUEST.REQUEST_STATUS, (Field<?>)rankedIds.field("AUTOMATION_REQUEST_STATUS")), new GridColumn(Tables.DATASET.NAME.as("DATASET_NAME"), rankedIds.field("DATASET_NAME")), new GridColumn(Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("CAMPAIGN_NAME"), rankedIds.field("CAMPAIGN_NAME")), new GridColumn(Tables.PROJECT.NAME.as("PROJECT_NAME"), rankedIds.field("CAMPAIGN_LIBRARY_PROJECT_NAME")), new GridColumn(Iteration.ITERATION.NAME.as("ITERATION_NAME"), rankedIds.field("ITERATION_NAME")), new GridColumn(rankedIds.field("USER", Long.class).as("ASSIGNEE_LOGIN"), rankedIds.field("ITERATION_TEST_PLAN_ASSIGNED_USER_LOGIN")), new GridColumn(Tables.EXECUTION.EXECUTION_MODE.as("EXECUTION_EXECUTION_MODE"), rankedIds.field("EXECUTION_EXECUTION_MODE")), new GridColumn(rankedIds.field("EXECUTION_STATUS", String.class), rankedIds.field(EXECUTION_STATUS_PRIORITY)), new GridColumn(rankedIds.field("LAST_EXECUTED_ON")), new GridColumn(rankedIds.field("LAST_EXECUTED_BY")), new GridColumn(Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("SPRINT_NAME"), rankedIds.field("SPRINT_NAME")));
    }

    @Override
    public SortField<?> convertGridSortToOrderBy(Table<?> rankedIds, GridSort gridSort) {
        GridSort.SortDirection direction = gridSort.getDirection();
        String id = gridSort.getProperty();
        Map<String, GridColumn> aliasToFieldMap = this.createAliasToFieldDictionaryForOrder(rankedIds);
        GridColumn gridColumn = Objects.requireNonNull(aliasToFieldMap.get(id));
        Field<?> nativeField = gridColumn.getNativeField();
        return direction == GridSort.SortDirection.ASC ? nativeField.asc() : nativeField.desc();
    }

    private Map<String, GridColumn> createAliasToFieldDictionaryForOrder(Table<?> rankedIds) {
        return this.getColumnsForSort(rankedIds).stream().collect(Collectors.toMap(GridColumn::findRuntimeAlias, column -> column));
    }
}

