/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.squashtest.tm.exception.pivot.projectexporter.ExportPivotException;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotMetaDataModel;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.CustomFieldPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.ExecutionWsPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.FolderPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.GlobalProjectPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.InfoListPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.MilestonePivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.ProjectPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.RequirementLinkExporterService;
import org.squashtest.tm.service.pivot.projectexporter.RequirementPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.ServerPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.TestCasePivotExporterService;

@Service
@Transactional
public class GlobalProjectPivotExporterServiceImpl
implements GlobalProjectPivotExporterService {
    private final ServerPivotExporterService serverPivotExporterService;
    private final CustomFieldPivotExporterService customFieldPivotExporterService;
    private final FolderPivotExporterService folderPivotExporterService;
    private final RequirementPivotExporterService requirementPivotExporterService;
    private final TestCasePivotExporterService testCasePivotExporterService;
    private final ExecutionWsPivotExporterService executionWsPivotExporterService;
    private final InfoListPivotExporterService infoListPivotExporterService;
    private final MilestonePivotExporterService milestonePivotExporterService;
    private final RequirementLinkExporterService requirementLinkExporterService;
    private final ProjectPivotExporterService projectPivotExporterService;
    private final PivotFileManager pivotFileManager;

    public GlobalProjectPivotExporterServiceImpl(ServerPivotExporterService serverPivotExporterService, CustomFieldPivotExporterService customFieldPivotExporterService, FolderPivotExporterService folderPivotExporterService, RequirementPivotExporterService requirementPivotExporterService, TestCasePivotExporterService testCasePivotExporterService, ExecutionWsPivotExporterService executionWsPivotExporterService, InfoListPivotExporterService infoListPivotExporterService, MilestonePivotExporterService milestonePivotExporterService, RequirementLinkExporterService requirementLinkExporterService, ProjectPivotExporterService projectPivotExporterService, PivotFileManager pivotFileManager) {
        this.serverPivotExporterService = serverPivotExporterService;
        this.customFieldPivotExporterService = customFieldPivotExporterService;
        this.folderPivotExporterService = folderPivotExporterService;
        this.requirementPivotExporterService = requirementPivotExporterService;
        this.testCasePivotExporterService = testCasePivotExporterService;
        this.executionWsPivotExporterService = executionWsPivotExporterService;
        this.infoListPivotExporterService = infoListPivotExporterService;
        this.milestonePivotExporterService = milestonePivotExporterService;
        this.requirementLinkExporterService = requirementLinkExporterService;
        this.projectPivotExporterService = projectPivotExporterService;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'EXPORT')  or hasRole('ROLE_ADMIN')")
    public File exportFile(Long projectId) {
        File tmpAttachmentDir;
        File exportZipFile;
        try {
            int idTransaction = TransactionAspectSupport.currentTransactionStatus().hashCode();
            exportZipFile = File.createTempFile("project_export_" + idTransaction, ".zip");
            tmpAttachmentDir = Files.createTempDirectory("project_export_attachment_" + idTransaction, new FileAttribute[0]).toFile();
            exportZipFile.deleteOnExit();
            tmpAttachmentDir.deleteOnExit();
        }
        catch (IOException e) {
            throw new ExportPivotException("Pivot format export - Error while creating the temporaries files for export in the temp directory: ", (Throwable)e);
        }
        JsonFactory jsonFactory = new JsonFactory();
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(exportZipFile));){
                PivotMetaDataModel pivotMetaDataModel = new PivotMetaDataModel();
                this.customFieldPivotExporterService.generateCustomFieldsJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.infoListPivotExporterService.generateInfoListsJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId, pivotMetaDataModel);
                this.milestonePivotExporterService.generateMilestoneJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.requirementLinkExporterService.generateRequirementLinkJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId, pivotMetaDataModel);
                this.serverPivotExporterService.generateServerJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.projectPivotExporterService.generateProjectJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId, pivotMetaDataModel);
                this.folderPivotExporterService.generateRequirementFolderJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId);
                this.folderPivotExporterService.generateTestCaseFolderJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId);
                this.folderPivotExporterService.generateCampaignFolderWithSprintGroupJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId);
                this.requirementPivotExporterService.generateRequirementJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId);
                this.testCasePivotExporterService.generateTestCaseJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId);
                this.testCasePivotExporterService.generateCalledTestCaseJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, projectId);
                this.executionWsPivotExporterService.generateCampaignJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId);
                this.executionWsPivotExporterService.generateIterationJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId, pivotMetaDataModel);
                this.executionWsPivotExporterService.generateTestSuiteJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId, pivotMetaDataModel);
                this.executionWsPivotExporterService.generateExecutionJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId, pivotMetaDataModel);
                this.executionWsPivotExporterService.generateSprintJsonFile(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, tmpAttachmentDir, projectId, pivotMetaDataModel);
                this.writePivotMetaDataModelToZip(jsonFactory, (ArchiveOutputStream<ZipArchiveEntry>)archive, pivotMetaDataModel);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ArchiveException e) {
            throw new ExportPivotException("Error during the generation the export ZIP file: ", e);
        }
        return exportZipFile;
    }

    private void writePivotMetaDataModelToZip(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, PivotMetaDataModel pivotMetaDataModel) throws IOException {
        this.pivotFileManager.writeObjectToZip(jsonFactory, jsonGenerator -> jsonGenerator.writeObject((Object)pivotMetaDataModel), JsonImportFile.METADATA, archive);
    }
}

