/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.jooq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;

public class SubElementRecordProcessor<T>
implements AutoCloseable {
    private ElementContainer<T> elementContainer;
    private final Stream<? extends Record> stream;
    private final Iterator<? extends Record> recordIterator;
    private final Field<Long> mainIdField;
    private final Field<Long> subElementIdField;
    private final Function<Record, T> converter;
    private final BiConsumer<T, Record> appendSubElement;
    private final Class<T> subElementClazz;

    public SubElementRecordProcessor(ResultQuery<? extends Record> query, Field<Long> mainIdField, Field<Long> subElementIdField, Function<Record, T> converter, Class<T> subElementClazz) {
        this.stream = query.fetchStream();
        this.recordIterator = this.stream.iterator();
        this.mainIdField = mainIdField;
        this.subElementIdField = subElementIdField;
        this.converter = converter;
        this.appendSubElement = (a, b) -> {};
        this.elementContainer = this.getNewSubElementContainerFromRecord();
        this.subElementClazz = subElementClazz;
    }

    public SubElementRecordProcessor(ResultQuery<? extends Record> query, Field<Long> mainIdField, Field<Long> subElementIdField, Function<Record, T> converter, BiConsumer<T, Record> appendSubElement, Class<T> subElementClazz) {
        this.stream = query.fetchStream();
        this.recordIterator = this.stream.iterator();
        this.subElementClazz = subElementClazz;
        this.mainIdField = mainIdField;
        this.subElementIdField = subElementIdField;
        this.converter = converter;
        this.appendSubElement = appendSubElement;
        this.elementContainer = this.getNewSubElementContainerFromRecord();
    }

    public Class<T> getSubElementClazz() {
        return this.subElementClazz;
    }

    public List<T> getSubElements(Long idMainElement, boolean isLast) {
        if (Objects.nonNull(this.elementContainer) && idMainElement.equals(this.elementContainer.idMainElement())) {
            ArrayList<T> elements = new ArrayList<T>(this.elementContainer.subElements());
            this.elementContainer.subElements().clear();
            if (!isLast) {
                this.elementContainer = this.getNewSubElementContainerFromRecord();
            }
            return elements;
        }
        return Collections.emptyList();
    }

    public ElementContainer<T> getNewSubElementContainerFromRecord() {
        ArrayList subElements = new ArrayList();
        SubElementWrapper subElement = null;
        Long mainId = null;
        Record record = null;
        while (this.recordIterator.hasNext()) {
            if (this.shouldInitializeFirstRecord(subElements)) {
                record = this.recordIterator.next();
                subElement = this.processRecord(record, subElements);
                mainId = (Long)record.get(this.mainIdField);
                continue;
            }
            if (subElements.isEmpty()) {
                subElement = this.processStoredRecord(subElements);
                mainId = (Long)this.elementContainer.record.get(this.mainIdField);
                continue;
            }
            record = this.recordIterator.next();
            if (this.isSameSubElement(record, subElement)) {
                this.appendSubElement.accept(subElement.element(), record);
                continue;
            }
            if (this.isSameMainElement(record, mainId)) {
                subElement = this.processRecord(record, subElements);
                continue;
            }
            return new ElementContainer(subElements, mainId, record);
        }
        if (this.shouldProcessLastStoredRecord(subElements)) {
            this.processStoredRecord(subElements);
            mainId = (Long)this.elementContainer.record.get(this.mainIdField);
        }
        return new ElementContainer(subElements, mainId, record);
    }

    private boolean shouldInitializeFirstRecord(List<T> pivotSubElements) {
        return this.elementContainer == null && pivotSubElements.isEmpty();
    }

    private boolean shouldProcessLastStoredRecord(List<T> pivotSubElements) {
        return this.elementContainer != null && pivotSubElements.isEmpty() && this.elementContainer.record != null;
    }

    private SubElementWrapper<T> processRecord(Record record, List<T> pivotSubElements) {
        T pivotSubElement = this.converter.apply(record);
        this.appendSubElement.accept(pivotSubElement, record);
        pivotSubElements.add(pivotSubElement);
        return new SubElementWrapper<T>((Long)record.get(this.subElementIdField), pivotSubElement);
    }

    private SubElementWrapper<T> processStoredRecord(List<T> pivotSubElements) {
        return this.processRecord(this.elementContainer.record, pivotSubElements);
    }

    private boolean isSameSubElement(Record record, SubElementWrapper<T> subElement) {
        return this.subElementIdField != null && ((Long)record.get(this.subElementIdField)).equals(subElement.id());
    }

    private boolean isSameMainElement(Record record, Long mainPivotEntityId) {
        return mainPivotEntityId.equals(record.get(this.mainIdField));
    }

    @Override
    public void close() {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    public record ElementContainer<T>(List<T> subElements, Long idMainElement, Record record) {
    }

    private record SubElementWrapper<T>(Long id, T element) {
    }
}

