/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.infolist;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.exception.customfield.CodeAlreadyExistsException;
import org.squashtest.tm.exception.customfield.StringDoesNotMatchesPatternException;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.infolist.IsBoundInfoListAdapter;
import org.squashtest.tm.service.internal.repository.InfoListDao;
import org.squashtest.tm.service.internal.repository.InfoListItemDao;

@Transactional
@Service(value="squashtest.tm.service.InfoListManagerService")
public class InfoListManagerServiceImpl
implements InfoListManagerService {
    public static final String CODE_REGEXP = "^[A-Za-z0-9_]*$";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private InfoListDao infoListDao;
    @Inject
    private InfoListItemDao infoListItemDao;

    @Override
    public InfoList findById(Long id) {
        return (InfoList)this.infoListDao.getReferenceById(id);
    }

    @Override
    public InfoList findByCode(String code) {
        return this.infoListDao.findByCode(code);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeDescription(long infoListId, String newDescription) {
        InfoList infoList = this.findById(infoListId);
        SystemInfoListCode.verifyModificationPermission((InfoList)infoList);
        infoList.setDescription(newDescription);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeLabel(long infoListId, String newLabel) {
        InfoList infoList = this.findById(infoListId);
        SystemInfoListCode.verifyModificationPermission((InfoList)infoList);
        if (StringUtils.equals((CharSequence)infoList.getLabel(), (CharSequence)newLabel)) {
            return;
        }
        this.checkLabelAvailability(newLabel);
        infoList.setLabel(newLabel);
    }

    private void checkLabelAvailability(String label) {
        if (this.infoListDao.findByLabel(label) != null) {
            throw new NameAlreadyInUseException("InfoList", label, "label");
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeCode(long infoListId, String newCode) {
        InfoList infoList = this.findById(infoListId);
        this.checkCodeHasValidPattern(newCode);
        this.checkDuplicateCode(infoList, newCode);
        infoList.setCode(newCode);
    }

    private void checkDuplicateCode(InfoList infoList, String newCode) {
        if (StringUtils.equals((CharSequence)infoList.getCode(), (CharSequence)newCode)) {
            return;
        }
        if (this.infoListDao.findByCode(newCode) != null) {
            throw new CodeAlreadyExistsException(infoList.getCode(), newCode, InfoList.class);
        }
    }

    private void checkDuplicateCode(String code) {
        if (this.infoListDao.findByCode(code) != null) {
            throw new CodeAlreadyExistsException(code, code, InfoList.class);
        }
    }

    @Override
    public void checkCodeHasValidPattern(String newCode) {
        if (StringUtils.isBlank((CharSequence)newCode)) {
            throw new RequiredFieldException("code");
        }
        if (!Pattern.matches(CODE_REGEXP, newCode)) {
            throw new StringDoesNotMatchesPatternException();
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeItemsPositions(long infoListId, int newIndex, List<Long> itemsIds) {
        InfoList infoList = this.findById(infoListId);
        SystemInfoListCode.verifyModificationPermission((InfoList)infoList);
        List items = this.infoListItemDao.findAllById(itemsIds);
        for (InfoListItem item : items) {
            infoList.removeItem(item);
        }
        infoList.addItems(newIndex, items);
    }

    private void remove(long infoListId) {
        InfoList infoList = (InfoList)this.infoListDao.getReferenceById(infoListId);
        SystemInfoListCode.verifyModificationPermission((InfoList)infoList);
        this.infoListDao.unbindFromProject(infoListId);
        this.infoListItemDao.unbindFromLibraryObjects(infoListId);
        for (InfoListItem item : infoList.getItems()) {
            this.infoListItemDao.delete(item);
        }
        this.infoListDao.delete(infoList);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void remove(List<Long> ids) {
        for (long id : ids) {
            this.remove(id);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<IsBoundInfoListAdapter> findAllWithBoundInfo() {
        List<IsBoundInfoListAdapter> unbound = this.createBoundAdapters(this.infoListDao.findAllUnbound(), false);
        List<IsBoundInfoListAdapter> bound = this.createBoundAdapters(this.infoListDao.findAllBound(), true);
        TreeSet<IsBoundInfoListAdapter> res = new TreeSet<IsBoundInfoListAdapter>(new Comparator<IsBoundInfoListAdapter>(){

            @Override
            public int compare(IsBoundInfoListAdapter kore, IsBoundInfoListAdapter sore) {
                return kore.getLabel().compareTo(sore.getLabel());
            }
        });
        res.addAll(bound);
        res.addAll(unbound);
        return this.filterSystemLists(res);
    }

    private List<IsBoundInfoListAdapter> filterSystemLists(Collection<IsBoundInfoListAdapter> lists) {
        ArrayList<IsBoundInfoListAdapter> res = new ArrayList<IsBoundInfoListAdapter>(lists.size());
        for (IsBoundInfoListAdapter list : lists) {
            if (!SystemInfoListCode.isNotSystem((String)list.getCode())) continue;
            res.add(list);
        }
        return res;
    }

    private List<IsBoundInfoListAdapter> createBoundAdapters(List<InfoList> lists, boolean isBound) {
        ArrayList<IsBoundInfoListAdapter> adapted = new ArrayList<IsBoundInfoListAdapter>(lists.size());
        for (InfoList list : lists) {
            adapted.add(new IsBoundInfoListAdapter(list, isBound));
        }
        return adapted;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public InfoList persist(InfoList infoList) {
        return this.persistUnsecured(infoList);
    }

    @Override
    public InfoList persistUnsecured(InfoList infoList) {
        this.checkLabelAvailability(infoList.getLabel());
        this.checkDuplicateCode(infoList.getCode());
        this.checkCodeHasValidPattern(infoList.getCode());
        this.infoListDao.save(infoList);
        for (InfoListItem item : infoList.getItems()) {
            this.infoListItemDao.save(item);
        }
        return infoList;
    }
}

