/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.prittergherkin;

import gherkin.ast.Background;
import gherkin.ast.Comment;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.Location;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.squashtest.tm.service.internal.dto.projectimporterxray.prittergherkin.GherkinDocumentHandlers;
import org.squashtest.tm.service.internal.dto.projectimporterxray.prittergherkin.GherkinDocumentPrinterResult;

class GherkinDocumentPrinterHandlers
implements GherkinDocumentHandlers<GherkinDocumentPrinterResult> {
    private static final int SCENARIO_LEVEL = 1;
    private static final String INDENT = "  ";
    private final Pattern startOfLine = Pattern.compile("^", 8);
    private final List<Comment> comments;

    public GherkinDocumentPrinterHandlers(List<Comment> comments) {
        this.comments = comments;
    }

    @Override
    public GherkinDocumentPrinterResult handleFeature(Feature feature, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        gherkinDocumentPrinterResult.append(GherkinDocumentPrinterHandlers.handleLanguageHeader(feature.getLanguage()));
        return this.appendFeature(gherkinDocumentPrinterResult, feature);
    }

    @Override
    public GherkinDocumentPrinterResult handleBackground(Background background, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        return this.appendBackground(gherkinDocumentPrinterResult, background);
    }

    @Override
    public GherkinDocumentPrinterResult handleDataTable(DataTable dataTable, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        int level = 3;
        return this.appendTableRows(gherkinDocumentPrinterResult, dataTable.getRows(), level);
    }

    @Override
    public GherkinDocumentPrinterResult handleComment(Comment comment, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        this.appendComment(0, gherkinDocumentPrinterResult, comment);
        return gherkinDocumentPrinterResult;
    }

    @Override
    public GherkinDocumentPrinterResult handleDocString(DocString docString, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        String docstringDelimiter = "\"\"\"";
        int level = 3;
        String indent = this.addIndent(level);
        String docStringContent = this.startOfLine.matcher(docString.getContent()).replaceAll(indent);
        return gherkinDocumentPrinterResult.append(indent).append(docstringDelimiter).append(docString.getContentType() == null ? "" : docString.getContentType()).append("\n").append(docStringContent).append("\n").append(indent).append(docstringDelimiter).append("\n");
    }

    @Override
    public GherkinDocumentPrinterResult handleExamples(Examples examples, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        if (examples.getTableHeader() != null) {
            tableRows.add(examples.getTableHeader());
            tableRows.addAll(examples.getTableBody());
        }
        gherkinDocumentPrinterResult = this.appendExamples(gherkinDocumentPrinterResult, examples);
        return this.appendTableRows(gherkinDocumentPrinterResult, tableRows, 3);
    }

    @Override
    public GherkinDocumentPrinterResult handleScenario(Scenario scenario, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        return this.appendScenario(gherkinDocumentPrinterResult, scenario);
    }

    @Override
    public GherkinDocumentPrinterResult handleScenarioOutline(ScenarioOutline scenarioOutline, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        return this.appendScenarioOutline(gherkinDocumentPrinterResult, scenarioOutline);
    }

    @Override
    public GherkinDocumentPrinterResult handleStep(Step step, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        this.appendComments(step.getLocation(), gherkinDocumentPrinterResult, this.comments, 2, true);
        this.appendComments(step.getLocation(), gherkinDocumentPrinterResult, this.comments, 2, false);
        return gherkinDocumentPrinterResult.append(this.addIndent(2)).append(step.getKeyword()).append(step.getText()).append("\n");
    }

    @Override
    public GherkinDocumentPrinterResult handleTableCell(TableCell tableCell, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        return gherkinDocumentPrinterResult;
    }

    @Override
    public GherkinDocumentPrinterResult handleTableRow(TableRow tableRow, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        return gherkinDocumentPrinterResult;
    }

    @Override
    public GherkinDocumentPrinterResult handleTag(Tag tag, GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        return gherkinDocumentPrinterResult;
    }

    @Override
    public void appendNewLine(GherkinDocumentPrinterResult gherkinDocumentPrinterResult) {
        gherkinDocumentPrinterResult.append("\n");
    }

    private static String handleLanguageHeader(String language) {
        return String.format("# language: %s%n", language);
    }

    private String semiColumnAndName(String name) {
        return name == null || name.isEmpty() ? ":" : ": " + name;
    }

    private GherkinDocumentPrinterResult appendScenarioOutline(GherkinDocumentPrinterResult gherkinDocumentPrinterResult, ScenarioOutline scenarioOutline) {
        return this.appendScenarioCommon(gherkinDocumentPrinterResult, scenarioOutline.getLocation(), scenarioOutline.getTags(), scenarioOutline.getSteps(), scenarioOutline.getDescription(), scenarioOutline.getKeyword(), scenarioOutline.getName());
    }

    private GherkinDocumentPrinterResult appendScenario(GherkinDocumentPrinterResult gherkinDocumentPrinterResult, Scenario scenario) {
        return this.appendScenarioCommon(gherkinDocumentPrinterResult, scenario.getLocation(), scenario.getTags(), scenario.getSteps(), scenario.getDescription(), scenario.getKeyword(), scenario.getName());
    }

    private GherkinDocumentPrinterResult appendScenarioCommon(GherkinDocumentPrinterResult gherkinDocumentPrinterResult, Location location, List<Tag> scenarioTags, List<Step> steps, String description, String keyword, String name) {
        this.appendCommentsKeyword(location, gherkinDocumentPrinterResult, this.comments, 1);
        List<Object> tags = scenarioTags != null ? scenarioTags : Collections.emptyList();
        int stepCount = steps != null ? steps.size() : 0;
        String prettyDescription = this.prettyDescription(description, 1);
        this.appendTags(gherkinDocumentPrinterResult, tags, 1, this.comments);
        return gherkinDocumentPrinterResult.append(this.addIndent(1)).append(keyword).append(this.semiColumnAndName(name)).append("\n").append(prettyDescription).append(!prettyDescription.trim().isEmpty() && stepCount > 0 ? "\n" : "");
    }

    private GherkinDocumentPrinterResult appendFeature(GherkinDocumentPrinterResult gherkinDocumentPrinterResult, Feature feature) {
        int level = 0;
        this.appendCommentsKeyword(feature.getLocation(), gherkinDocumentPrinterResult, this.comments, level);
        List tags = feature.getTags() != null ? feature.getTags() : Collections.emptyList();
        this.appendTags(gherkinDocumentPrinterResult, tags, level, this.comments);
        return gherkinDocumentPrinterResult.append(this.addIndent(level)).append(feature.getKeyword()).append(this.semiColumnAndName(feature.getName())).append("\n").append(this.prettyDescription(feature.getDescription(), level));
    }

    private GherkinDocumentPrinterResult appendExamples(GherkinDocumentPrinterResult gherkinDocumentPrinterResult, Examples examples) {
        int level = 2;
        this.appendCommentsKeyword(examples.getLocation(), gherkinDocumentPrinterResult, this.comments, level);
        List tags = examples.getTags() != null ? examples.getTags() : Collections.emptyList();
        String description = this.prettyDescription(examples.getDescription(), level);
        this.appendTags(gherkinDocumentPrinterResult, tags, level, this.comments);
        return gherkinDocumentPrinterResult.append(this.addIndent(level)).append(examples.getKeyword()).append(this.semiColumnAndName(examples.getName())).append("\n").append(description);
    }

    private GherkinDocumentPrinterResult appendBackground(GherkinDocumentPrinterResult gherkinDocumentPrinterResult, Background background) {
        this.appendCommentsKeyword(background.getLocation(), gherkinDocumentPrinterResult, this.comments, 1);
        int stepCount = background.getSteps() != null ? background.getSteps().size() : 0;
        String description = this.prettyDescription(background.getDescription(), 1);
        return gherkinDocumentPrinterResult.append(this.addIndent(1)).append(background.getKeyword()).append(this.semiColumnAndName(background.getName())).append("\n").append(description).append(!description.trim().isEmpty() && stepCount > 0 ? "\n" : "");
    }

    private String prettyDescription(String description, int level) {
        if (description == null || description.trim().isEmpty()) {
            return "";
        }
        return this.addIndent(level + 1) + description.trim() + "\n";
    }

    private void appendTags(GherkinDocumentPrinterResult gherkinDocumentPrinterResult, List<Tag> tags, int level, List<Comment> comments) {
        if (tags.isEmpty()) {
            return;
        }
        String prefix = this.addIndent(level);
        String tagQuote = "";
        this.appendComments(tags.get(0).getLocation(), gherkinDocumentPrinterResult, comments, level, false);
        gherkinDocumentPrinterResult.append(prefix).append(tags.stream().map(tag -> tagQuote + tag.getName() + tagQuote).collect(Collectors.joining(" "))).append("\n");
    }

    private String addIndent(int level) {
        return INDENT.repeat(Math.max(0, level));
    }

    private GherkinDocumentPrinterResult appendTableRows(GherkinDocumentPrinterResult gherkinDocumentPrinterResult, List<TableRow> tableRows, int level) {
        if (tableRows.isEmpty()) {
            return gherkinDocumentPrinterResult;
        }
        int[] maxWidths = new int[tableRows.get(0).getCells().size()];
        Arrays.fill(maxWidths, 0);
        for (TableRow tableRow : tableRows) {
            int j = 0;
            while (j < tableRow.getCells().size()) {
                TableCell tableCell = (TableCell)tableRow.getCells().get(j);
                maxWidths[j] = Math.max(maxWidths[j], GherkinDocumentPrinterHandlers.getStringWidth(this.escapeCell(tableCell.getValue())));
                ++j;
            }
        }
        for (TableRow row : tableRows) {
            this.appendTableRow(gherkinDocumentPrinterResult, row, level, maxWidths, this.comments);
        }
        return gherkinDocumentPrinterResult;
    }

    private List<Comment> popComments(Location currentLocation, List<Comment> comments, int level, boolean previousBlock) {
        ArrayList<Comment> res = new ArrayList<Comment>();
        Iterator<Comment> iter = comments.iterator();
        while (iter.hasNext()) {
            Comment comment = iter.next();
            if (currentLocation.getLine() <= comment.getLocation().getLine() || previousBlock && comment.getText().startsWith(this.addIndent(level))) continue;
            res.add(comment);
            iter.remove();
        }
        return res;
    }

    private void appendTableRow(GherkinDocumentPrinterResult gherkinDocumentPrinterResult, TableRow row, int level, int[] maxWidths, List<Comment> comments) {
        this.appendComments(row.getLocation(), gherkinDocumentPrinterResult, comments, level, false);
        gherkinDocumentPrinterResult.append(this.addIndent(level)).append("| ");
        int j = 0;
        while (j < row.getCells().size()) {
            if (j > 0) {
                gherkinDocumentPrinterResult.append(" | ");
            }
            TableCell tableCell = (TableCell)row.getCells().get(j);
            String escapedCellValue = this.escapeCell(tableCell.getValue());
            int spaceCount = maxWidths[j] - GherkinDocumentPrinterHandlers.getStringWidth(escapedCellValue);
            String spaces = " ".repeat(spaceCount);
            gherkinDocumentPrinterResult.append(escapedCellValue + spaces);
            ++j;
        }
        gherkinDocumentPrinterResult.append(" |\n");
    }

    private void appendCommentsKeyword(Location location, GherkinDocumentPrinterResult gherkinDocumentPrinterResult, List<Comment> comments, int level) {
        this.appendComments(location, gherkinDocumentPrinterResult, comments, level, true);
        gherkinDocumentPrinterResult.append(level == 0 ? "" : "\n");
        this.appendComments(location, gherkinDocumentPrinterResult, comments, level, false);
    }

    private void appendComments(Location location, GherkinDocumentPrinterResult gherkinDocumentPrinterResult, List<Comment> comments, int level, boolean previousBlock) {
        int actualLevel = previousBlock ? level - 1 : level;
        for (Comment nextComment : this.popComments(location, comments, level, previousBlock)) {
            this.appendComment(actualLevel, gherkinDocumentPrinterResult, nextComment);
        }
    }

    private void appendComment(int actualLevel, GherkinDocumentPrinterResult gherkinDocumentPrinterResult, Comment nextComment) {
        if (nextComment.getText() == null || nextComment.getText().trim().isEmpty()) {
            return;
        }
        String comment = nextComment.getText().trim();
        if (!comment.isEmpty()) {
            gherkinDocumentPrinterResult.append(this.addIndent(actualLevel)).append("# " + comment.substring(1).trim()).append("\n");
        }
    }

    private static int getStringWidth(String s) {
        int width = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            width += GherkinDocumentPrinterHandlers.isCJKorFullWidth(character) ? 2 : 1;
            ++n2;
        }
        return width;
    }

    private static boolean isCJKorFullWidth(char character) {
        Pattern pattern = Pattern.compile("[\\u3000-\\u9fff\\uac00-\\ud7af\\uff01-\\uff60]");
        return pattern.matcher(String.valueOf(character)).find();
    }

    private String escapeCell(String s) {
        StringBuilder e = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    e.append("\\\\");
                    break;
                }
                case '\n': {
                    e.append("\\n");
                    break;
                }
                case '|': {
                    e.append("\\|");
                    break;
                }
                default: {
                    e.append(c);
                }
            }
            ++i;
        }
        return e.toString();
    }
}

