/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.springframework.context.MessageSource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.CampaignFolderKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.CampaignKnownIssueFinder;
import org.squashtest.tm.service.internal.display.campaign.AvailableDatasetAppender;
import org.squashtest.tm.service.internal.display.campaign.ReadUnassignedTestPlanHelper;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignDto;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignFolderDto;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignLibraryDto;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignMultiSelectionDto;
import org.squashtest.tm.service.internal.display.dto.campaign.IterationPlanningDto;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.CampaignTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanGridHelpers;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CampaignDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.RequestAliasesConstants;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateCampaignDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.UserContextService;
import org.squashtest.tm.service.user.PartyPreferenceService;

@Service
@Transactional(readOnly=true)
public class CampaignDisplayServiceImpl
implements CampaignDisplayService {
    public static final String DEACTIVATED_USER_I18N_KEY = "administration-workspace.users.manage.deactivated";
    private static final String CAN_READ_CAMPAIGN = "hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ') or hasRole('ROLE_ADMIN')";
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final AvailableDatasetAppender availableDatasetAppender;
    private final CampaignDisplayDao campaignDisplayDao;
    private final CampaignFolderKnownIssueFinder campaignFolderKnownIssueFinder;
    private final CampaignKnownIssueFinder campaignKnownIssueFinder;
    private final CampaignTestPlanManagerService campaignTestPlanManagerService;
    private final CustomFieldValueDisplayDao customFieldValueDisplayDao;
    private final CustomReportDashboardService customReportDashboardService;
    private final DSLContext dslContext;
    private final EntityPathHeaderService entityPathHeaderService;
    private final HibernateCampaignDao hibernateCampaignDao;
    private final IterationDisplayDao iterationDisplayDao;
    private final MilestoneDisplayDao milestoneDisplayDao;
    private final PartyPreferenceService partyPreferenceService;
    private final PermissionEvaluationService permissionEvaluationService;
    private final EntityPathHeaderDao entityPathHeaderDao;
    private final ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper;
    private final UserContextService userContextService;
    private final EntityManager entityManager;
    private final GridConfigurationService gridConfigurationService;
    private final MessageSource messageSource;
    private final CustomItpiLastExecutionFilterDao itpiLastExecutionFilterDao;

    public CampaignDisplayServiceImpl(CampaignDisplayDao campaignDisplayDao, IterationDisplayDao iterationDisplayDao, AttachmentDisplayDao attachmentDisplayDao, CustomFieldValueDisplayDao customFieldValueDisplayDao, MilestoneDisplayDao milestoneDisplayDao, HibernateCampaignDao hibernateCampaignDao, DSLContext dslContext, CampaignKnownIssueFinder campaignKnownIssueFinder, CampaignTestPlanManagerService campaignTestPlanManagerService, CustomReportDashboardService customReportDashboardService, PartyPreferenceService partyPreferenceService, ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper, AvailableDatasetAppender availableDatasetAppender, UserContextService userContextService, PermissionEvaluationService permissionEvaluationService, EntityPathHeaderDao entityPathHeaderDao, CampaignFolderKnownIssueFinder campaignFolderKnownIssueFinder, EntityPathHeaderService entityPathHeaderService, GridConfigurationService gridConfigurationService, EntityManager entityManager, MessageSource messageSource, CustomItpiLastExecutionFilterDao itpiLastExecutionFilterDao) {
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.availableDatasetAppender = availableDatasetAppender;
        this.campaignDisplayDao = campaignDisplayDao;
        this.campaignFolderKnownIssueFinder = campaignFolderKnownIssueFinder;
        this.campaignKnownIssueFinder = campaignKnownIssueFinder;
        this.campaignTestPlanManagerService = campaignTestPlanManagerService;
        this.customFieldValueDisplayDao = customFieldValueDisplayDao;
        this.customReportDashboardService = customReportDashboardService;
        this.dslContext = dslContext;
        this.entityPathHeaderService = entityPathHeaderService;
        this.hibernateCampaignDao = hibernateCampaignDao;
        this.iterationDisplayDao = iterationDisplayDao;
        this.milestoneDisplayDao = milestoneDisplayDao;
        this.partyPreferenceService = partyPreferenceService;
        this.permissionEvaluationService = permissionEvaluationService;
        this.entityPathHeaderDao = entityPathHeaderDao;
        this.readUnassignedTestPlanHelper = readUnassignedTestPlanHelper;
        this.userContextService = userContextService;
        this.gridConfigurationService = gridConfigurationService;
        this.entityManager = entityManager;
        this.messageSource = messageSource;
        this.itpiLastExecutionFilterDao = itpiLastExecutionFilterDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.campaign.CampaignLibrary' ,'READ')  or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=CampaignLibrary.class)
    public CampaignLibraryDto getCampaignLibraryView(@Id long libraryId) {
        CampaignLibraryDto libraryDto = this.campaignDisplayDao.getCampaignLibraryDtoById(libraryId);
        libraryDto.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(libraryDto.getAttachmentListId()));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            libraryDto.setFavoriteDashboardId(dashboardId);
        }
        libraryDto.setNbIssues(this.campaignFolderKnownIssueFinder.countKnownIssues(libraryId));
        libraryDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN));
        libraryDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN));
        return libraryDto;
    }

    @Override
    @PreAuthorize(value="hasPermission(#campFolderId, 'org.squashtest.tm.domain.campaign.CampaignFolder', 'READ') or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=CampaignFolder.class)
    public CampaignFolderDto getCampaignFolderView(@Id long campFolderId) {
        CampaignFolderDto campaignFolderDto = this.campaignDisplayDao.getCampaignFolderDtoById(campFolderId);
        campaignFolderDto.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(campaignFolderDto.getAttachmentListId()));
        campaignFolderDto.setCustomFieldValues(this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.CAMPAIGN_FOLDER, campFolderId));
        campaignFolderDto.setNbIssues(this.campaignFolderKnownIssueFinder.countKnownIssues(campFolderId));
        campaignFolderDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN));
        campaignFolderDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            campaignFolderDto.setFavoriteDashboardId(dashboardId);
        }
        campaignFolderDto.setBreadcrumbs(this.entityPathHeaderService.getCampaignLibraryNodeHeaderBreadcrumbs(campFolderId, true));
        return campaignFolderDto;
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' , 'READ') or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=Campaign.class)
    public CampaignDto getCampaignView(@Id long campaignId) {
        CampaignDto campaignDto = this.campaignDisplayDao.getCampaignDtoById(campaignId);
        campaignDto.setMilestones(this.milestoneDisplayDao.getMilestonesByCampaignId(campaignId));
        campaignDto.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(campaignDto.getAttachmentListId()));
        List<Long> itpiIdsInTCLastExecScope = this.itpiLastExecutionFilterDao.gatherLatestItpiIdsForTCInScopeForCampaign(Collections.singletonList(campaignId));
        campaignDto.setTestPlanStatistics(this.hibernateCampaignDao.findCampaignStatisticsForTCLastExecutionScope(campaignId, itpiIdsInTCLastExecScope));
        campaignDto.setCustomFieldValues(this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.CAMPAIGN, campaignId));
        campaignDto.setNbIssues(this.campaignKnownIssueFinder.countKnownIssues(campaignId));
        this.appendUsers(campaignDto);
        campaignDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN));
        campaignDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            campaignDto.setFavoriteDashboardId(dashboardId);
        }
        this.appendNbTestPlanItems(campaignDto);
        campaignDto.setBreadcrumbs(this.entityPathHeaderService.getCampaignLibraryNodeHeaderBreadcrumbs(campaignId, true));
        return campaignDto;
    }

    private void appendUsers(CampaignDto campaignDto) {
        List<User> users = this.campaignTestPlanManagerService.findAssignableUserForTestPlan(campaignDto.getId());
        campaignDto.setUsers(UserView.fromEntities(users));
    }

    private void appendNbTestPlanItems(CampaignDto campaignDto) {
        String login = this.userContextService.getUsername();
        int count = this.currentUserCanReadUnassigned(campaignDto.getId()) ? this.campaignDisplayDao.getNbTestPlanItem(campaignDto.getId(), null) : this.campaignDisplayDao.getNbTestPlanItem(campaignDto.getId(), login);
        campaignDto.setNbTestPlanItems(count);
    }

    private boolean currentUserCanReadUnassigned(Long campaignId) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), campaignId, "org.squashtest.tm.domain.campaign.Campaign");
    }

    @Override
    public List<IterationPlanningDto> findIterationsPlanningByCampaign(Long campaignId) {
        return this.campaignDisplayDao.findIterationPlanningByCampaign(campaignId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ') or hasRole('ROLE_ADMIN')")
    public GridResponse findTestPlan(Long campaignId, GridRequest gridRequest) {
        String userLoginToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(campaignId, "org.squashtest.tm.domain.campaign.Campaign");
        CampaignTestPlanGrid testPlanGrid = new CampaignTestPlanGrid(campaignId, userLoginToRestrictTo);
        Campaign campaign = (Campaign)this.entityManager.find(Campaign.class, (Object)campaignId);
        Long projectId = campaign.getProject().getId();
        GridResponse gridResponse = testPlanGrid.getRows(gridRequest, this.dslContext);
        this.appendDataRows(gridResponse);
        this.availableDatasetAppender.appendAvailableDatasets(gridResponse);
        gridResponse.setActiveColumnIds(this.gridConfigurationService.findActiveColumnIdsForUserWithProjectId(gridRequest.getGridId(), projectId));
        return gridResponse;
    }

    private void appendDataRows(GridResponse gridResponse) {
        Set<Long> testCaseIds = gridResponse.getDataRows().stream().map(row -> (Long)row.getData().get(RequestAliasesConstants.toCamelCase("TEST_CASE_ID"))).collect(Collectors.toSet());
        Map<Long, String> testCasePathById = this.entityPathHeaderDao.buildTestCasePathByIds(testCaseIds, " / ");
        for (DataRow row2 : gridResponse.getDataRows()) {
            TestPlanGridHelpers.addTestCasePath(row2, testCasePathById);
            TestPlanGridHelpers.formatDeactivatedUserNameInRowData(row2, this.messageSource);
        }
    }

    @Override
    public List<String> retrieveFullNameByCampaignLibraryNodeIds(List<Long> campaignLibraryNodeIds, List<Long> projectIds) {
        return this.campaignDisplayDao.retrieveFullNameByCampaignLibraryNodeIds(campaignLibraryNodeIds, projectIds);
    }

    @Override
    public CampaignMultiSelectionDto getCampaignMultiView(NodeReferences nodeReferences) {
        CampaignMultiSelectionDto campaignMultiSelectionDto = new CampaignMultiSelectionDto();
        campaignMultiSelectionDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN));
        campaignMultiSelectionDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN));
        this.findAndSetMultiSelectionDisabledExecutionStatus(nodeReferences, campaignMultiSelectionDto);
        PartyPreference partyPreference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN.getPreferenceKey());
        if (partyPreference != null) {
            Long dashboardId = Long.valueOf(partyPreference.getPreferenceValue());
            campaignMultiSelectionDto.setFavoriteDashboardId(dashboardId);
        }
        return campaignMultiSelectionDto;
    }

    @Override
    public boolean isMultiSelectionScopeValid(NodeReferences nodeReferences) {
        int nbTestSuitesInScope = nodeReferences.extractNonLibrariesByType(NodeType.TEST_SUITE).size();
        if (nbTestSuitesInScope > 0) {
            return false;
        }
        int nbIterationsInScope = nodeReferences.extractNonLibrariesByType(NodeType.ITERATION).size();
        return nbIterationsInScope == 0 || nbIterationsInScope == nodeReferences.extractNonLibraries().size();
    }

    private void findAndSetMultiSelectionDisabledExecutionStatus(NodeReferences nodeReferences, CampaignMultiSelectionDto campaignMultiSelectionDto) {
        boolean isIterationScope;
        ArrayList<Long> projectIds = new ArrayList<Long>();
        ArrayList<String> finalDisabledExecutionStatuses = new ArrayList<String>();
        Set nodeIds = nodeReferences.extractNonLibraryIds();
        boolean bl = isIterationScope = nodeReferences.extractNonLibrariesByType(NodeType.ITERATION).size() == nodeIds.size();
        if (isIterationScope) {
            projectIds.addAll(this.iterationDisplayDao.findDistinctProjectIdsByIterationIds(nodeIds));
        } else {
            Set libraryIds = nodeReferences.extractLibraryIds();
            projectIds.addAll(this.campaignDisplayDao.findDistinctProjectIdsByCampaignLibraryIds(libraryIds));
            projectIds.addAll(this.campaignDisplayDao.findDistinctProjectIdsByCampaignLibraryNodeIds(nodeIds));
        }
        int nbOfProjectsInPerimeter = projectIds.size();
        List<String> disabledExecutionStatuses = this.campaignDisplayDao.findAllDisabledExecutionStatusByProjectIds(new HashSet<Long>(projectIds));
        if (!disabledExecutionStatuses.isEmpty() && nbOfProjectsInPerimeter > 1) {
            this.filterDisabledStatusesForAllProjects(finalDisabledExecutionStatuses, disabledExecutionStatuses, nbOfProjectsInPerimeter);
        } else if (nbOfProjectsInPerimeter == 1) {
            finalDisabledExecutionStatuses = disabledExecutionStatuses;
        }
        campaignMultiSelectionDto.setDisabledExecutionStatus(finalDisabledExecutionStatuses);
    }

    private List<String> filterDisabledStatusesForAllProjects(List<String> finalDisabledExecutionStatuses, List<String> disabledExecutionStatuses, int nbOfProjects) {
        ListIterator iterator = disabledExecutionStatuses.stream().distinct().toList().listIterator();
        while (iterator.hasNext()) {
            String executionStatus = (String)iterator.next();
            int nbStatusOccurrences = disabledExecutionStatuses.stream().filter(disabledStatus -> disabledStatus.equals(executionStatus)).toList().size();
            if (nbStatusOccurrences != nbOfProjects) continue;
            finalDisabledExecutionStatuses.add(executionStatus);
        }
        return finalDisabledExecutionStatuses;
    }
}

