/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.importer.WithPath;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.CustomFieldValidator;
import org.squashtest.tm.service.internal.batchimport.EntityValidator;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.MilestoneImportHelper;
import org.squashtest.tm.service.internal.batchimport.Milestoned;
import org.squashtest.tm.service.internal.batchimport.Model;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.StepType;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.column.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.column.requirement.LinkedLowLevelRequirementsSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.requirement.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.CoverageInstruction;
import org.squashtest.tm.service.internal.batchimport.column.testcase.CoverageTarget;
import org.squashtest.tm.service.internal.batchimport.column.testcase.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.TestCaseSheetColumn;
import org.squashtest.tm.service.internal.batchimport.instruction.ActionStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.DatasetInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.DatasetParamValueInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.Instruction;
import org.squashtest.tm.service.internal.batchimport.instruction.LinkedLowLevelRequirementInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.ParameterInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.HighLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.LinkedLowLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementLinkTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementImportValidationBag;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.TestCaseImportValidationBag;
import org.squashtest.tm.service.internal.repository.RequirementImportDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.UserContextService;

@Component
@Scope(value="prototype")
public class ValidationFacility
implements Facility {
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    private static final String PERM_READ = "READ";
    private static final String PERM_IMPORT = "IMPORT";
    private static final String TEST_CASE_LIBRARY_CLASSNAME = "org.squashtest.tm.domain.testcase.TestCaseLibrary";
    private static final String REQUIREMENT_VERSION_LIBRARY_CLASSNAME = "org.squashtest.tm.domain.requirement.RequirementLibrary";
    private static final String REQ_VERSION_PATH_SEPARATOR = "::";
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationFacility.class);
    @Value(value="#{@featureManager.isEnabled('MILESTONE')}")
    private boolean milestonesEnabled;
    private final PermissionEvaluationService permissionService;
    private final InfoListItemFinderService infoListItemService;
    private final Model model;
    private final UserDao userDao;
    private final MilestoneImportHelper milestoneHelper;
    private final RequirementLibraryFinderService reqFinderService;
    private final UserContextService userContextService;
    private final TestCaseDao testCaseDao;
    private final EntityValidator entityValidator;
    private final RequirementImportDao requirementImportDao;
    private final ConfigurablePluginManager configurablePluginManager;
    private final CustomFieldValidator cufValidator = new CustomFieldValidator();
    private final CreationStrategy<TestCaseInstruction, TestCaseTarget> testCaseCreationStrategy = new CreationStrategy();
    private final UpdateStrategy<TestCaseInstruction, TestCaseTarget> testCaseUpdateStrategy = new UpdateStrategy();
    private final CreationStrategy<RequirementVersionInstruction, RequirementVersionTarget> requirementVersionCreationStrategy = new CreationStrategy();
    private final UpdateStrategy<RequirementVersionInstruction, RequirementVersionTarget> requirementVersionUpdateStrategy = new UpdateStrategy();

    public ValidationFacility(PermissionEvaluationService permissionService, InfoListItemFinderService infoListItemService, Model model, UserDao userDao, MilestoneImportHelper milestoneHelper, RequirementLibraryFinderService reqFinderService, UserContextService userContextService, TestCaseDao testCaseDao, EntityValidator entityValidator, RequirementImportDao requirementImportDao, ConfigurablePluginManager configurablePluginManager) {
        this.permissionService = permissionService;
        this.infoListItemService = infoListItemService;
        this.model = model;
        this.userDao = userDao;
        this.milestoneHelper = milestoneHelper;
        this.reqFinderService = reqFinderService;
        this.userContextService = userContextService;
        this.testCaseDao = testCaseDao;
        this.entityValidator = entityValidator;
        this.requirementImportDao = requirementImportDao;
        this.configurablePluginManager = configurablePluginManager;
        this.entityValidator.setModel(model);
    }

    public Model getModel() {
        return this.model;
    }

    private static void checkProjectValidity(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Project must not be null");
        }
    }

    private void checkPathForUpdate(TestCaseTarget target, String name, LogTrain logs) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        String path = target.getPath();
        if (!PathUtils.arePathsAndNameConsistents((String)path, (String)name)) {
            String newPath = PathUtils.rename((String)path, (String)name);
            TestCaseTarget newTarget = new TestCaseTarget(newPath);
            TargetStatus newStatus = this.model.getStatus(newTarget);
            if (newStatus.status != Existence.NOT_EXISTS) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.cantrename", path, newPath).build());
            }
        }
    }

    private List<LogEntry> fixMetadata(Target target, AuditableMixin auditable, ImportMode importMode, EntityType type, List<String> activeLogins, String currentUsername) {
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
        String login = auditable.getCreatedBy();
        boolean fixUser = false;
        if (StringUtils.isBlank((CharSequence)login)) {
            fixUser = true;
        } else if (!activeLogins.contains(login)) {
            String warningMessage = null;
            String impactMessage = switch (importMode) {
                case ImportMode.CREATE -> "message.import.log.impact.useCurrentLogin";
                case ImportMode.UPDATE -> "message.import.log.impact.fieldNotChange";
                default -> "message.import.log.impact.fieldNotChange";
            };
            switch (type) {
                case REQUIREMENT_VERSION: {
                    warningMessage = "message.import.log.error.requirement.userNotFound";
                    break;
                }
                case TEST_CASE: {
                    warningMessage = "message.import.log.error.tc.userNotFound";
                    break;
                }
            }
            LogEntry logEntry = LogEntry.warning().forTarget(target).withMessage(warningMessage, new Object[0]).withImpact(impactMessage, new Object[0]).build();
            logEntries.add(logEntry);
            fixUser = true;
        }
        if (fixUser) {
            auditable.setCreatedBy(currentUsername);
        }
        if (auditable.getCreatedOn() == null) {
            auditable.setCreatedOn(new Date());
        }
        return logEntries;
    }

    @Override
    public LogTrain deleteTestCase(TestCaseTarget target) {
        LogEntry hasntPermission;
        LogTrain logs = new LogTrain();
        TargetStatus status = this.model.getStatus(target);
        if (status.getStatus() == Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.notFound", new Object[0]).build());
        }
        if ((hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target, (Target)target)) != null) {
            logs.addEntry(hasntPermission);
        }
        if (this.model.isCalled(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.cannotRemoveCalledTestCase", new Object[0]).build());
        }
        if (this.model.isTestCaseLockedByMilestones(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        return logs;
    }

    private void checkActionStepAddition(ActionStepInstruction instruction) {
        LogEntry indexCheckLog;
        TestStepTarget target = (TestStepTarget)instruction.getTarget();
        ActionTestStep testStep = instruction.getTestStep();
        Map<String, String> cufValues = instruction.getCustomFields();
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        logs.append(this.cufValidator.checkCreateCustomFields(target, cufValues, this.model.getTestStepCufs(target)));
        LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        TestCaseTarget testCase = target.getTestCase();
        TargetStatus tcStatus = this.model.getStatus(testCase);
        if ((tcStatus.status == Existence.TO_BE_CREATED || tcStatus.status == Existence.EXISTS) && (indexCheckLog = this.checkStepIndex(ImportMode.CREATE, target, ImportStatus.WARNING, "message.import.log.impact.testStepAddedAtMaxPosition")) != null) {
            logs.addEntry(indexCheckLog);
        }
        this.checkParamNameInString(target, logs, testStep.getAction(), StepSheetColumn.TC_STEP_ACTION);
        this.checkParamNameInString(target, logs, testStep.getExpectedResult(), StepSheetColumn.TC_STEP_EXPECTED_RESULT);
        instruction.addLogs(logs);
    }

    private void checkParamNameInString(Target target, LogTrain logs, String action, TemplateColumn column) {
        boolean hasInvalidParameterNamesInAction = Parameter.hasInvalidParameterNamesInString((String)action);
        if (hasInvalidParameterNamesInAction) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.step.param.wrongFormat", column.getHeader()).build());
        }
    }

    public void checkCallStepCreation(CallStepInstruction instruction) {
        LogEntry indexCheckLog;
        LogEntry hasntCallPermission;
        TestStepTarget target = (TestStepTarget)instruction.getTarget();
        TestCaseTarget calledTestCase = instruction.getCalledTC();
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        logs.append(this.entityValidator.validateCallStep(target, calledTestCase, instruction.getDatasetInfo(), ImportMode.CREATE));
        LogEntry hasntOwnerPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntOwnerPermission != null) {
            logs.addEntry(hasntOwnerPermission);
        }
        if ((hasntCallPermission = this.checkPermissionOnProject(PERM_READ, calledTestCase, (Target)target)) != null) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.callStep.calledTcNotReadable", new Object[0]).withImpact("message.import.log.impact.callStepImportedAsActionStep", new Object[0]).build());
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        if ((indexCheckLog = this.checkStepIndex(ImportMode.CREATE, target, ImportStatus.WARNING, "message.import.log.impact.testStepAddedAtMaxPosition")) != null) {
            logs.addEntry(indexCheckLog);
        }
        instruction.addLogs(logs);
    }

    @Override
    public LogTrain updateActionStep(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        boolean exists;
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        logs.append(this.cufValidator.checkUpdateCustomFields(target, cufValues, this.model.getTestStepCufs(target)));
        LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        if (!(exists = this.model.stepExists(target))) {
            if (target.getIndex() == null) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.empty", new Object[0]).build());
            } else if (target.getIndex() < 0) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.negative", new Object[0]).build());
            } else {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.notexists", new Object[0]).build());
            }
        } else {
            StepType type = this.model.getType(target);
            if (type != StepType.ACTION) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.notanactionstep", new Object[0]).build());
            }
        }
        this.checkParamNameInString(target, logs, testStep.getAction(), StepSheetColumn.TC_STEP_ACTION);
        this.checkParamNameInString(target, logs, testStep.getExpectedResult(), StepSheetColumn.TC_STEP_EXPECTED_RESULT);
        return logs;
    }

    @Override
    public LogTrain updateCallStep(TestStepTarget target, CallTestStep testStep, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfos, ActionTestStep actionStepBackup) {
        boolean exists;
        LogEntry hasntCallPermission;
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        logs.append(this.entityValidator.validateCallStep(target, calledTestCase, paramInfos, ImportMode.UPDATE));
        LogEntry hasntOwnerPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntOwnerPermission != null) {
            logs.addEntry(hasntOwnerPermission);
        }
        if ((hasntCallPermission = this.checkPermissionOnProject(PERM_READ, calledTestCase, (Target)target)) != null) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.callStep.calledTcNotReadable", new Object[0]).build());
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        if (!(exists = this.model.stepExists(target))) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.notexists", new Object[0]).build());
        } else {
            StepType type = this.model.getType(target);
            if (type != StepType.CALL) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcStep.notacallstep", new Object[0]).build());
            }
            if (this.model.wouldCreateCycle(target, calledTestCase)) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.callStep.cyclicCalls", target.getTestCase().getPath(), calledTestCase.getPath()).build());
            }
        }
        return logs;
    }

    @Override
    public LogTrain deleteTestStep(TestStepTarget target) {
        LogEntry indexCheckLog;
        LogTrain logs = this.entityValidator.basicTestStepChecks(target);
        LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        if (this.model.isTestCaseLockedByMilestones(target.getTestCase())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
        }
        if ((indexCheckLog = this.checkStepIndex(ImportMode.DELETE, target, ImportStatus.FAILURE, null)) != null) {
            logs.addEntry(indexCheckLog);
        }
        return logs;
    }

    private void checkParameterCreation(ParameterInstruction instruction) {
        LogEntry hasNoPermission;
        ParameterTarget target = (ParameterTarget)instruction.getTarget();
        LogTrain logs = this.entityValidator.basicParameterChecks(target);
        if (this.model.doesParameterExists(target)) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.param.alreadyexists", new Object[0]).withImpact("message.import.log.impact.paramupdate", new Object[0]).build());
        }
        if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getOwner(), (Target)target)) != null) {
            logs.addEntry(hasNoPermission);
        }
        instruction.addLogs(logs);
    }

    @Override
    public LogTrain updateParameter(ParameterTarget target, Parameter param) {
        LogEntry hasNoPermission;
        LogTrain logs = this.entityValidator.basicParameterChecks(target);
        if (!this.model.doesParameterExists(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.param.notFound", new Object[0]).build());
        }
        if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getOwner(), (Target)target)) != null) {
            logs.addEntry(hasNoPermission);
        }
        return logs;
    }

    @Override
    public LogTrain deleteParameter(ParameterTarget target) {
        LogEntry hasNoPermission;
        LogTrain logs = new LogTrain();
        if (!this.model.doesParameterExists(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.param.notFound", new Object[0]).build());
        }
        if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getOwner(), (Target)target)) != null) {
            logs.addEntry(hasNoPermission);
        }
        return logs;
    }

    @Override
    public LogTrain failsafeUpdateParameterValue(DatasetTarget dataset, ParameterTarget param, String value, boolean isUpdate) {
        LogTrain junk = this.entityValidator.basicDatasetCheck(dataset);
        LogTrain logs = this.entityValidator.basicParameterValueChecks(param);
        logs.setForAll(dataset);
        if (!logs.hasCriticalErrors() && !junk.hasCriticalErrors()) {
            LogEntry hasNoPermission;
            if (!this.model.isParamInDataset(param, dataset)) {
                logs.addEntry(LogEntry.failure().forTarget(dataset).withMessage("message.import.log.error.tc.dataset.paramOwnerNotFound", new Object[0]).build());
            }
            if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, dataset.getTestCase(), (Target)dataset)) != null) {
                logs.addEntry(hasNoPermission);
            }
        }
        return logs;
    }

    private void checkDatasetCreation(DatasetInstruction instruction) {
        DatasetTarget target = (DatasetTarget)instruction.getTarget();
        LogTrain logs = this.entityValidator.basicDatasetCheck(target);
        LogEntry hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, target.getTestCase(), (Target)target);
        if (hasNoPermission != null) {
            logs.addEntry(hasNoPermission);
        }
        instruction.addLogs(logs);
    }

    @Override
    public LogTrain deleteDataset(DatasetTarget dataset) {
        LogEntry hasNoPermission;
        LogTrain logs = this.entityValidator.basicDatasetCheck(dataset);
        if (this.model.datasetNotExist(dataset)) {
            logs.addEntry(LogEntry.failure().forTarget(dataset).withMessage("message.import.log.error.tc.dataset.notFound", new Object[0]).build());
        }
        if ((hasNoPermission = this.checkPermissionOnProject(PERM_IMPORT, dataset.getTestCase(), (Target)dataset)) != null) {
            logs.addEntry(hasNoPermission);
        }
        return logs;
    }

    private LogEntry checkPermissionOnProject(String permission, TestCaseTarget target, Target checkedTarget) {
        LogEntry entry = null;
        Long libid = this.model.getProjectStatus(target.getProject()).getTestCaseLibraryId();
        if (libid != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, permission, libid, TEST_CASE_LIBRARY_CLASSNAME)) {
            entry = LogEntry.failure().forTarget(checkedTarget).withMessage("message.import.log.error.unsuficientRight", permission, target.getPath()).build();
        }
        return entry;
    }

    private LogEntry checkPermissionOnProject(String permission, RequirementVersionTarget target, Target checkedTarget) {
        LogEntry entry = null;
        Long libid = this.model.getProjectStatus(target.getProject()).getRequirementLibraryId();
        if (libid != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, permission, libid, REQUIREMENT_VERSION_LIBRARY_CLASSNAME)) {
            entry = LogEntry.failure().forTarget(checkedTarget).withMessage("message.import.log.error.unsuficientRight", permission, target.getPath()).build();
        }
        return entry;
    }

    private LogEntry checkStepIndex(ImportMode mode, TestStepTarget target, ImportStatus importStatus, String optionalImpact) {
        Integer index = target.getIndex();
        LogEntry entry = null;
        if (index == null) {
            entry = LogEntry.status(importStatus).forTarget(target).withMessage("message.import.log.error.tc.tcStep.empty", new Object[0]).withImpact(optionalImpact, new Object[0]).build();
        } else if (index < 0) {
            entry = LogEntry.status(importStatus).forTarget(target).withMessage("message.import.log.error.tc.tcStep.negative", new Object[0]).withImpact(optionalImpact, new Object[0]).build();
        } else if (!(this.model.stepExists(target) || this.model.indexIsFirstAvailable(target) && mode == ImportMode.CREATE)) {
            entry = LogEntry.status(importStatus).forTarget(target).withMessage("message.import.log.error.tc.tcStep.numberOverNextPosition", new Object[0]).withImpact(optionalImpact, new Object[0]).build();
        }
        return entry;
    }

    @Override
    public void createTestCases(List<TestCaseInstruction> instructions, Project project) {
        ValidationFacility.checkProjectValidity(project);
        Set<TestCaseTarget> targets = instructions.stream().map(Instruction::getTarget).collect(Collectors.toSet());
        this.model.initStatuses(targets);
        TestCaseImportValidationBag bag = this.buildValidationBag(instructions, project.getId(), project.getTestCaseLibrary().getId());
        instructions.forEach(instruction -> this.checkTestCaseCreation((TestCaseInstruction)instruction, bag));
    }

    private TestCaseImportValidationBag buildValidationBag(List<TestCaseInstruction> instructions, Long projectId, Long testCaseLibraryId) {
        String currentUsername = this.userContextService.getUsername();
        List<String> activeLogins = this.collectActiveLogins(instructions);
        List<String> uuidList = this.collectExistingTestCaseUuids(instructions);
        Set<String> naturesConsistency = this.collectConsistentNatures(instructions, projectId);
        Set<String> typesConsistency = this.collectConsistentTypes(instructions, projectId);
        InfoListItem defaultNature = this.infoListItemService.findDefaultTestCaseNature(projectId);
        InfoListItem defaultType = this.infoListItemService.findDefaultTestCaseType(projectId);
        return new TestCaseImportValidationBag(testCaseLibraryId, activeLogins, uuidList, naturesConsistency, defaultNature, typesConsistency, defaultType, currentUsername);
    }

    private List<String> collectActiveLogins(List<TestCaseInstruction> instructions) {
        Set createdByList = instructions.stream().map(instruction -> instruction.getTestCase().getCreatedBy()).filter(user -> !Strings.isBlank((String)user)).collect(Collectors.toSet());
        return createdByList.isEmpty() ? Collections.emptyList() : this.userDao.filterActiveUserLogins(createdByList);
    }

    private List<String> collectRequirementActiveLogins(List<RequirementVersionInstruction> instructions) {
        Set createdByList = instructions.stream().map(instruction -> instruction.getRequirementVersion().getCreatedBy()).filter(user -> !Strings.isBlank((String)user)).collect(Collectors.toSet());
        return createdByList.isEmpty() ? Collections.emptyList() : this.userDao.filterActiveUserLogins(createdByList);
    }

    private List<String> collectExistingTestCaseUuids(List<TestCaseInstruction> instructions) {
        Set uuids = instructions.stream().map(instruction -> instruction.getTestCase().getUuid()).filter(user -> !Strings.isBlank((String)user)).collect(Collectors.toSet());
        return uuids.isEmpty() ? Collections.emptyList() : this.testCaseDao.filterExistingTestCaseUuids(uuids);
    }

    private Set<String> collectConsistentNatures(List<TestCaseInstruction> instructions, Long projectId) {
        Set<String> natures = instructions.stream().map(TestCaseInstruction::getTestCase).filter(testCase -> testCase.getNature() != null).map(testCase -> testCase.getNature().getCode()).filter(code -> !Strings.isBlank((String)code)).collect(Collectors.toSet());
        return this.infoListItemService.filterConsistentNatures(projectId, natures);
    }

    private Set<String> collectConsistentCategories(List<RequirementVersionInstruction> instructions, Long projectId) {
        Set<String> natures = instructions.stream().map(RequirementVersionInstruction::getRequirementVersion).filter(requirementVersion -> requirementVersion.getCategory() != null).map(testCase -> testCase.getCategory().getCode()).filter(code -> !Strings.isBlank((String)code)).collect(Collectors.toSet());
        return this.infoListItemService.filterConsistentCategories(projectId, natures);
    }

    private Set<String> collectConsistentTypes(List<TestCaseInstruction> instructions, Long projectId) {
        Set<String> types = instructions.stream().map(TestCaseInstruction::getTestCase).filter(testCase -> testCase.getType() != null).map(testCase -> testCase.getType().getCode()).filter(code -> !Strings.isBlank((String)code)).collect(Collectors.toSet());
        return this.infoListItemService.filterConsistentTypes(projectId, types);
    }

    private void checkTestCaseCreation(TestCaseInstruction instr, TestCaseImportValidationBag validationBag) {
        LogEntry hasntPermission;
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        String path = target.getPath();
        TestCase testCase = instr.getTestCase();
        String name = testCase.getName();
        Map<String, String> cufValues = instr.getCustomFields();
        TargetStatus status = this.model.getStatus(target);
        LogTrain logs = this.entityValidator.createTestCaseChecks(target, testCase, validationBag);
        logs.append(this.cufValidator.checkCreateCustomFields(target, cufValues, this.model.getTestCaseCufs(target)));
        if (status.getStatus() != Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.alreadyexists", target.getPath()).withImpact("message.import.log.impact.tc.renamed", new Object[0]).build());
        }
        if ((hasntPermission = this.checkPermissionOnProject(validationBag.testCaseLibraryId(), target)) != null) {
            logs.addEntry(hasntPermission);
        }
        if (!StringUtils.isBlank((CharSequence)name) && !PathUtils.arePathsAndNameConsistents((String)path, (String)name)) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.inconsistentNameAndPath", path, name).build());
        }
        this.testCaseCreationStrategy.validateMilestones(instr, logs);
        List<LogEntry> logEntries = this.fixMetadata(target, (AuditableMixin)testCase, ImportMode.CREATE, EntityType.TEST_CASE, validationBag.activeLogins(), validationBag.currentUsername());
        logs.addEntries(logEntries);
        this.checkParamNameInString(target, logs, testCase.getPrerequisite(), TestCaseSheetColumn.TC_PRE_REQUISITE);
        if (!StringUtils.isBlank((CharSequence)testCase.getUuid())) {
            if (validationBag.existingUuids().contains(testCase.getUuid())) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.uuid.alreadyExisting", testCase.getUuid()).build());
            } else {
                Pattern uuidPattern = Pattern.compile("[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}");
                if (!uuidPattern.matcher(testCase.getUuid()).matches()) {
                    logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.uuid.wrongFormat", new Object[0]).build());
                }
            }
        }
        instr.addLogs(logs);
    }

    private LogEntry checkPermissionOnProject(Long testCaseLibraryId, TestCaseTarget target) {
        if (testCaseLibraryId != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_IMPORT, testCaseLibraryId, TEST_CASE_LIBRARY_CLASSNAME)) {
            return LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unsuficientRight", PERM_IMPORT, target.getPath()).build();
        }
        return null;
    }

    private LogEntry checkPermissionOnProject(Long requirementLibraryId, RequirementVersionTarget target) {
        if (requirementLibraryId != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_IMPORT, requirementLibraryId, REQUIREMENT_VERSION_LIBRARY_CLASSNAME)) {
            return LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unsuficientRight", PERM_IMPORT, target.getPath()).build();
        }
        return null;
    }

    @Override
    public LogTrain updateTestCase(TestCaseInstruction instr) {
        TestCase testCase = instr.getTestCase();
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        Map<String, String> cufValues = instr.getCustomFields();
        LogTrain logs = new LogTrain();
        String name = testCase.getName();
        TargetStatus status = this.model.getStatus(target);
        if (status.getStatus() == Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.notFound", new Object[0]).build());
        } else {
            ProjectTargetStatus projectStatus = this.model.getProjectStatus(target.getProject());
            TestCaseImportValidationBag bag = this.buildValidationBag(Collections.singletonList(instr), projectStatus.getId(), projectStatus.getTestCaseLibraryId());
            logs.append(this.entityValidator.updateTestCaseChecks(target, testCase, bag));
            logs.append(this.cufValidator.checkUpdateCustomFields(target, cufValues, this.model.getTestCaseCufs(target)));
            this.checkPathForUpdate(target, name, logs);
            LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target, (Target)target);
            if (hasntPermission != null) {
                logs.addEntry(hasntPermission);
            }
            if (this.model.isTestCaseLockedByMilestones(target)) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.milestone.locked", new Object[0]).build());
            }
            List<LogEntry> logEntries = this.fixMetadata(target, (AuditableMixin)testCase, ImportMode.UPDATE, EntityType.TEST_CASE, bag.activeLogins(), bag.currentUsername());
            logs.addEntries(logEntries);
            this.testCaseUpdateStrategy.validateMilestones(instr, logs);
            this.checkParamNameInString(target, logs, testCase.getPrerequisite(), TestCaseSheetColumn.TC_PRE_REQUISITE);
        }
        return logs;
    }

    @Override
    public void updateRequirementVersions(List<RequirementVersionInstruction> instructions, Project project) {
        ValidationFacility.checkProjectValidity(project);
        this.preValidationInit(instructions);
        RequirementImportValidationBag bag = this.buildRequirementValidationBag(instructions, project.getId(), project.getRequirementLibrary().getId());
        instructions.forEach(instruction -> instruction.addLogs(this.updateRequirementVersion((RequirementVersionInstruction)instruction, bag)));
    }

    @Override
    public void createRequirementVersions(List<RequirementVersionInstruction> instructions, Project project) {
        ValidationFacility.checkProjectValidity(project);
        this.preValidationInit(instructions);
        this.checkRequirementVersionsCreation(instructions, project);
    }

    private void preValidationInit(List<RequirementVersionInstruction> instructions) {
        HashSet<RequirementVersionTarget> targets = new HashSet<RequirementVersionTarget>();
        for (RequirementVersionInstruction instruction : instructions) {
            this.entityValidator.preVersionValidation(instruction);
            targets.add((RequirementVersionTarget)instruction.getTarget());
        }
        this.model.mainInitRequirements(targets);
    }

    private void checkRequirementVersionsCreation(List<RequirementVersionInstruction> instructions, Project project) {
        RequirementImportValidationBag bag = this.buildRequirementValidationBag(instructions, project.getId(), project.getRequirementLibrary().getId());
        instructions.forEach(instruction -> this.requirementVersionCreationValidation((RequirementVersionInstruction)instruction, bag));
        instructions.forEach(this::checkNonImportableFlagPostProcess);
    }

    private RequirementImportValidationBag buildRequirementValidationBag(List<RequirementVersionInstruction> instructions, Long projectId, Long requirementLibraryId) {
        String currentUsername = this.userContextService.getUsername();
        List<String> activeLogins = this.collectRequirementActiveLogins(instructions);
        Set<String> naturesConsistency = this.collectConsistentCategories(instructions, projectId);
        InfoListItem defaultNature = this.infoListItemService.findDefaultRequirementCategory(projectId);
        return new RequirementImportValidationBag(requirementLibraryId, projectId, activeLogins, naturesConsistency, defaultNature, currentUsername);
    }

    private void requirementVersionCreationValidation(RequirementVersionInstruction instr, RequirementImportValidationBag validationBag) {
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        RequirementTarget reqTarget = target.getRequirement();
        RequirementVersion reqVersion = instr.getRequirementVersion();
        Map<String, String> cufValues = instr.getCustomFields();
        LOGGER.debug("Req-Import - In Validation Facility for create {} version {}", new Object[]{target.getPath(), target.getVersion()});
        LogTrain logs = this.entityValidator.createRequirementVersionChecks(target, reqVersion, validationBag);
        this.checkFolderConflict(instr, logs);
        this.checkImportedRequirementVersionStatusForCreate(target, reqVersion);
        logs.append(this.cufValidator.checkCreateCustomFields(target, cufValues, this.model.getRequirementVersionCufs(target)));
        LogEntry hasntPermission = this.checkPermissionOnProject(validationBag.requirementLibraryId(), target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        this.checkAndFixRequirementVersionNumber(target, logs);
        this.entityValidator.createHighLevelRequirementChecks(target, logs);
        this.checkNatureUnicity(target, logs);
        this.checkAndFixNameConsistency(target, reqVersion);
        this.requirementVersionCreationStrategy.validateMilestones(instr, logs);
        this.checkMilestonesAlreadyUsedInRequirement(instr, logs);
        logs.addEntries(this.fixMetadata(target, (AuditableMixin)reqVersion, ImportMode.CREATE, EntityType.REQUIREMENT_VERSION, validationBag.activeLogins(), validationBag.currentUsername()));
        if (!logs.hasCriticalErrors()) {
            this.model.updateRequirementVersionStatus(target, new TargetStatus(Existence.TO_BE_CREATED), (List<String>)instr.getMilestones());
            if (this.model.getStatus(reqTarget).getStatus() == Existence.NOT_EXISTS) {
                this.model.updateRequirementStatus(reqTarget, new TargetStatus(Existence.TO_BE_CREATED));
            }
        } else {
            instr.fatalError();
        }
        instr.addLogs(logs);
    }

    private void checkNonImportableFlagPostProcess(RequirementVersionInstruction instr) {
        this.entityValidator.checkImportableFlag((RequirementVersionTarget)instr.getTarget(), instr.getLogTrain());
    }

    private void checkImportedRequirementVersionStatusForCreate(RequirementVersionTarget target, RequirementVersion reqVersion) {
        RequirementStatus requirementVersionStatus = reqVersion.getStatus();
        if (requirementVersionStatus != null && requirementVersionStatus != RequirementStatus.WORK_IN_PROGRESS) {
            target.setImportedRequirementStatus(requirementVersionStatus);
            reqVersion.setStatus(RequirementStatus.WORK_IN_PROGRESS);
        }
    }

    private void checkExistingRequirementVersionStatus(RequirementVersionTarget target, LogTrain logs, RequirementVersion importedVersion) {
        if (logs.hasCriticalErrors()) {
            return;
        }
        Requirement requirement = this.reqFinderService.findRequirement(target.getRequirement().getId());
        RequirementVersion existingVersion = requirement.findRequirementVersion(target.getVersion().intValue());
        RequirementStatus persistedStatus = existingVersion.getStatus();
        if (target.getRequirement().isSynchronized() || this.isUpdatable(existingVersion, importedVersion)) {
            target.setImportedRequirementStatus(importedVersion.getStatus());
            if (!persistedStatus.equals((Object)importedVersion.getStatus())) {
                importedVersion.updateStatusWithoutCheck(persistedStatus);
            }
        } else if (this.isReqTransformation(requirement, target)) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warn.reqVersionLockedStatusWithNatureTransformation", RequirementSheetColumn.REQ_NATURE.header).withImpact("message.import.log.impact.requirement.reqVersionLockedStatusWithNatureTransformation", new Object[0]).build());
            target.setImportedRequirementStatus(persistedStatus);
            importedVersion.updateStatusWithoutCheck(persistedStatus);
        } else {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.statusLocked", new Object[0]).build());
        }
    }

    public boolean isUpdatable(RequirementVersion existingVersion, RequirementVersion update) {
        boolean isSameVersion;
        if (existingVersion.getStatus().isRequirementModifiable()) {
            return true;
        }
        boolean bl = isSameVersion = existingVersion.getReference().equals(update.getReference()) && existingVersion.getName().equals(update.getName()) && existingVersion.getDescription().equals(update.getDescription()) && existingVersion.getCriticality().equals((Object)update.getCriticality()) && existingVersion.getStatus().equals((Object)update.getStatus());
        return isSameVersion && existingVersion.getCategory().getCode().equals(update.getCategory().getCode());
    }

    private boolean isReqTransformation(Requirement requirement, RequirementVersionTarget target) {
        return requirement.isHighLevel() ^ target.getRequirement().isHighLevel();
    }

    private LogTrain updateRequirementVersion(RequirementVersionInstruction instr, RequirementImportValidationBag bag) {
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        RequirementVersion reqVersion = instr.getRequirementVersion();
        Map<String, String> cufValues = instr.getCustomFields();
        LogTrain logs = this.entityValidator.updateRequirementChecks(target, reqVersion, bag);
        if (this.abortIfHasCriticalErrors(logs, instr)) {
            return logs;
        }
        this.checkMilestoneLock(target, logs);
        if (this.abortIfHasCriticalErrors(logs, instr)) {
            return logs;
        }
        this.checkIfImportingSynchronizedRequirement(target, logs, bag.projectId());
        if (this.abortIfHasCriticalErrors(logs, instr)) {
            return logs;
        }
        this.checkRequirementVersionExists(target, logs);
        this.checkExistingRequirementVersionStatus(target, logs, reqVersion);
        if (this.abortIfHasCriticalErrors(logs, instr)) {
            return logs;
        }
        logs.append(this.cufValidator.checkUpdateCustomFields(target, cufValues, this.model.getRequirementVersionCufs(target)));
        this.entityValidator.highLevelRequirementUpdateTests(target, logs);
        if (this.abortIfHasCriticalErrors(logs, instr)) {
            return logs;
        }
        LogEntry hasntPermission = this.checkPermissionOnProject(PERM_IMPORT, target, (Target)target);
        if (hasntPermission != null) {
            logs.addEntry(hasntPermission);
        }
        this.checkAndFixNameConsistency(target, reqVersion);
        this.requirementVersionUpdateStrategy.validateMilestones(instr, logs);
        this.checkMilestonesAlreadyUsedInRequirement(instr, logs);
        logs.addEntries(this.fixMetadata(target, (AuditableMixin)reqVersion, ImportMode.UPDATE, EntityType.REQUIREMENT_VERSION, bag.activeLogins(), bag.currentUsername()));
        if (logs.hasCriticalErrors()) {
            instr.fatalError();
        }
        return logs;
    }

    private boolean abortIfHasCriticalErrors(LogTrain logs, RequirementVersionInstruction instr) {
        if (logs.hasCriticalErrors()) {
            instr.fatalError();
            return true;
        }
        return false;
    }

    private void checkMilestoneLock(RequirementVersionTarget target, LogTrain logs) {
        if (this.model.isRequirementVersionLockedByMilestones(target)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.milestoneLocked", new Object[0]).build());
        }
    }

    private void checkIfImportingSynchronizedRequirement(RequirementVersionTarget target, LogTrain logs, Long projectId) {
        RequirementTarget requirementTarget = target.getRequirement();
        if (!requirementTarget.isSynchronized() || !requirementTarget.isImportingSynchronizedReq()) {
            return;
        }
        boolean isSyncPluginActive = this.configurablePluginManager.isPluginFoundAndActivated(projectId, requirementTarget.getRemoteSynchronisationKind());
        if (isSyncPluginActive && requirementTarget.isSynchronizedInCurrentPerimeter()) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.synchronized", new Object[0]).build());
        }
    }

    private void checkRequirementVersionExists(RequirementVersionTarget target, LogTrain logs) {
        TargetStatus status = this.model.getStatus(target);
        TargetStatus reqStatus = this.model.getStatus(target.getRequirement());
        if (reqStatus.getStatus() != Existence.EXISTS || reqStatus.getId() == null) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.notExists", new Object[0]).build());
        } else if (status.getStatus() != Existence.EXISTS || status.getId() == null) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.notExists", new Object[0]).build());
        } else {
            target.getRequirement().setId(reqStatus.getId());
        }
    }

    private void checkFolderConflict(RequirementVersionInstruction instr, LogTrain logs) {
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        if (this.model.isRequirementFolder(target)) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warning.reqPathisFolder", new Object[0]).withImpact("message.import.log.impact.requirement.reqRenamed", new Object[0]).build());
            this.fixPathFolderConflict(instr);
        }
    }

    private void fixPathFolderConflict(RequirementVersionInstruction instr) {
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        target.getRequirement().setPath(this.appendReqNameSuffix(target.getPath()));
        String name = PathUtils.extractEntityName((String)target.getPath());
        instr.getRequirementVersion().setName(name);
    }

    private String appendReqNameSuffix(String name) {
        return name + "-Copie1";
    }

    private void checkAndFixNameConsistency(RequirementVersionTarget target, RequirementVersion reqVersion) {
        if (!this.model.isCurrentVersion(target)) {
            return;
        }
        String reqName = PathUtils.extractEntityName((String)target.getPath());
        String reqVersionName = reqVersion.getName();
        if (!(reqName = PathUtils.unescapePathPartSlashes((String)reqName)).equals(reqVersionName)) {
            target.setUnconsistentName(reqVersionName);
            reqVersion.setName(reqName);
        }
    }

    private void checkMilestonesAlreadyUsedInRequirement(RequirementVersionInstruction instr, LogTrain logs) {
        Collection milestones = instr.getMilestones();
        RequirementVersionTarget target = (RequirementVersionTarget)instr.getTarget();
        for (String milestone : milestones) {
            if (!this.model.checkMilestonesAlreadyUsedInRequirement(milestone, target)) continue;
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.milestone.used", RequirementSheetColumn.REQ_VERSION_MILESTONE.header).withImpact("message.import.log.impact.milestone.notBinded", new Object[0]).build());
        }
    }

    private void checkNatureUnicity(RequirementVersionTarget target, LogTrain logs) {
        if (target.getVersion() <= 1) {
            return;
        }
        if (!this.model.isSameNature(target.getRequirement())) {
            this.addRequirementNatureCollisionErrorEntry(logs, target);
        }
    }

    private void addRequirementNatureCollisionErrorEntry(LogTrain logs, RequirementVersionTarget target) {
        logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.nature.collision", RequirementSheetColumn.REQ_NATURE.header).build());
    }

    private void checkAndFixRequirementVersionNumber(RequirementVersionTarget target, LogTrain logs) {
        if (target.getVersion() == null || target.getVersion() <= 0) {
            this.fixVersionNumber(target, logs, "message.import.log.error.requirement.version.null", "message.import.log.impact.versionModified");
        }
        Existence requirementVersionStatus = this.model.getStatus(target).getStatus();
        Existence requirementStatus = this.model.getStatus(target.getRequirement()).getStatus();
        LOGGER.debug("ReqImport Checking for version number: {}", new Object[]{target.getVersion()});
        LOGGER.debug("ReqImport Status of version: {} {}", new Object[]{target.getVersion(), requirementVersionStatus});
        if (!Existence.NOT_EXISTS.equals((Object)requirementStatus) && !Existence.NOT_EXISTS.equals((Object)requirementVersionStatus)) {
            this.fixVersionNumber(target, logs, "message.import.log.error.requirement.version.collision", "message.import.log.impact.versionModified");
        }
        this.checkPreviousVersionExistsAndReplaceVersionNumber(target, logs, requirementVersionStatus, requirementStatus);
    }

    private void checkPreviousVersionExistsAndReplaceVersionNumber(RequirementVersionTarget target, LogTrain logs, Existence requirementVersionStatus, Existence requirementStatus) {
        if (requirementVersionStatus != Existence.NOT_EXISTS || target.getVersion() <= 1) {
            return;
        }
        if (requirementStatus == Existence.NOT_EXISTS || !this.model.existPriorVersion(target)) {
            this.fixVersionNumber(target, logs, "message.import.log.error.requirement.version.previousNotExists", "message.import.log.impact.versionModifiedToPreviousNumber");
        }
    }

    private void fixVersionNumber(RequirementVersionTarget target, LogTrain logs, String errorMessage, String impactMessage) {
        this.model.fixRequirementVersion(target);
        logs.addEntry(LogEntry.warning().forTarget(target).withMessage(errorMessage, RequirementSheetColumn.REQ_VERSION_NUM.header).withImpact(impactMessage, new Object[0]).build());
    }

    @Override
    public LogTrain deleteRequirementVersion(RequirementVersionInstruction instr) {
        throw new NotImplementedException("Implement me");
    }

    public boolean areMilestoneValid(TestCaseInstruction instr) {
        LogTrain dummy = new LogTrain();
        this.testCaseUpdateStrategy.validateMilestones(instr, dummy);
        return dummy.hasNoErrorWhatsoever();
    }

    @Override
    public void createCoverages(List<CoverageInstruction> instructions, Project project) {
        HashMap simulatedNewCoverages = new HashMap();
        ValidationFacility.checkProjectValidity(project);
        this.preCoverageValidation(instructions);
        Set<Long> versionIds = instructions.stream().filter(instruction -> !instruction.hasCriticalErrors()).map(instruction -> this.model.getRequirementVersionId(((CoverageTarget)instruction.getTarget()).getRequirementVersion())).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<Long> requirementIds = instructions.stream().filter(instruction -> !instruction.hasCriticalErrors()).map(instruction -> this.model.getRequirementId(((CoverageTarget)instruction.getTarget()).getRequirementVersion())).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, List<Long>> existingVerifiedVersions = this.requirementImportDao.findVerifiedTestCaseIdsByVersionIds(versionIds);
        Map<Long, RequirementStatus> requirementStatuses = this.requirementImportDao.findRequirementStatusesByVersionIds(versionIds);
        Map<Long, Map<Long, Long>> existingCoverages = this.requirementImportDao.findExistingCoveragesByRequirementIds(requirementIds);
        instructions.stream().filter(instruction -> !instruction.hasCriticalErrors()).forEach(instruction -> this.checkCoverageCreation((CoverageInstruction)instruction, existingVerifiedVersions, simulatedNewCoverages, requirementStatuses, existingCoverages));
    }

    private void checkCoverageCreation(CoverageInstruction instruction, Map<Long, List<Long>> existingVerifiedVersions, Map<String, List<String>> simulatedVerifiedVersionsToAdd, Map<Long, RequirementStatus> requirementStatuses, Map<Long, Map<Long, Long>> existingCoverages) {
        TargetStatus testCaseStatus;
        TargetStatus requirementStatus;
        CoverageTarget target = (CoverageTarget)instruction.getTarget();
        RequirementVersionTarget versionTarget = target.getRequirementVersion();
        TargetStatus versionStatus = this.model.getStatus(versionTarget);
        if (!ValidationFacility.coversExitingEntities(instruction, versionStatus, requirementStatus = this.model.getStatus(versionTarget.getRequirement()), testCaseStatus = this.model.getStatus(target.getTestCase()))) {
            return;
        }
        if (!this.hasPermissions(instruction)) {
            return;
        }
        this.setTargetIds(target, requirementStatus, testCaseStatus);
        Long versionId = versionStatus.getId();
        if (Existence.TO_BE_CREATED.equals((Object)testCaseStatus.getStatus()) || Existence.TO_BE_CREATED.equals((Object)versionStatus.getStatus())) {
            this.checkDuplicateToBeCreatedAndSimulateAdd(instruction, target.getTcPath(), versionId, versionTarget, simulatedVerifiedVersionsToAdd);
        } else if (!this.isDuplicateExisting(instruction, versionId, testCaseStatus.getId(), existingVerifiedVersions, versionStatus, requirementStatuses)) {
            this.handleExistingCoverage(instruction, requirementStatus.getId(), testCaseStatus.getId(), existingCoverages);
        }
    }

    private void setTargetIds(CoverageTarget target, TargetStatus requirementStatus, TargetStatus testCaseStatus) {
        target.getTestCase().setId(testCaseStatus.getId());
        target.getRequirementVersion().getRequirement().setId(requirementStatus.getId());
    }

    private void checkDuplicateToBeCreatedAndSimulateAdd(CoverageInstruction instruction, String tcPath, Long versionId, RequirementVersionTarget versionTarget, Map<String, List<String>> addedVerifiedVersions) {
        Object key = versionId != null ? String.valueOf(versionId) : String.valueOf(versionTarget.getVersion()) + REQ_VERSION_PATH_SEPARATOR + versionTarget.getPath();
        List existingCoveragesForReq = addedVerifiedVersions.getOrDefault(key, Collections.emptyList());
        if (existingCoveragesForReq.contains(tcPath)) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.warning.linkAlreadyExist", "message.import.log.impact.line.ignored", new Object[0]);
            return;
        }
        addedVerifiedVersions.computeIfAbsent((String)key, k -> new ArrayList()).add(tcPath);
    }

    private boolean isDuplicateExisting(CoverageInstruction instruction, Long versionId, Long tcId, Map<Long, List<Long>> existingVerifiedVersions, TargetStatus versionStatus, Map<Long, RequirementStatus> requirementStatuses) {
        List existingCoveragesForReq = existingVerifiedVersions.getOrDefault(versionId, Collections.emptyList());
        if (existingCoveragesForReq.contains(tcId)) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.warning.linkAlreadyExist", "message.import.log.impact.line.ignored", new Object[0]);
            return true;
        }
        existingVerifiedVersions.computeIfAbsent(versionId, k -> new ArrayList()).add(tcId);
        if (versionStatus.getStatus() == Existence.EXISTS && !requirementStatuses.get(versionId).isRequirementLinkable()) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirement.version.statusLocked", null, new Object[0]);
            return true;
        }
        return false;
    }

    private void handleExistingCoverage(CoverageInstruction instruction, Long requirementId, Long tcId, Map<Long, Map<Long, Long>> existingCoverages) {
        Long existingCoverageId = (Long)existingCoverages.getOrDefault(requirementId, Collections.emptyMap()).get(tcId);
        if (existingCoverageId != null) {
            instruction.setCoverageId(existingCoverageId);
        }
    }

    private static boolean coversExitingEntities(CoverageInstruction instruction, TargetStatus versionStatus, TargetStatus requirementStatus, TargetStatus testCaseStatus) {
        if (requirementStatus.getStatus() == Existence.NOT_EXISTS) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirement.notExists", null, new Object[0]);
            return false;
        }
        if (versionStatus.getStatus() == Existence.NOT_EXISTS) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirement.version.notExists", null, new Object[0]);
            return false;
        }
        if (testCaseStatus.getStatus() == Existence.NOT_EXISTS) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.tc.notFound", null, ((CoverageTarget)instruction.getTarget()).getTcPath());
            return false;
        }
        return true;
    }

    private boolean hasPermissions(CoverageInstruction instruction) {
        boolean hasPermission = true;
        CoverageTarget coverageTarget = (CoverageTarget)instruction.getTarget();
        String tcPath = coverageTarget.getTcPath();
        Long tcLibraryId = this.model.getProjectStatus(coverageTarget.getTestCase().getProject()).getTestCaseLibraryId();
        if (tcLibraryId != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_IMPORT, tcLibraryId, TEST_CASE_LIBRARY_CLASSNAME)) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.unsuficientRight", null, PERM_IMPORT, tcPath);
            hasPermission = false;
        }
        String reqPath = coverageTarget.getReqPath();
        Long reqLibraryId = this.model.getProjectStatus(coverageTarget.getRequirementVersion().getProject()).getRequirementLibraryId();
        if (reqLibraryId != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, PERM_IMPORT, reqLibraryId, REQUIREMENT_VERSION_LIBRARY_CLASSNAME)) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.unsuficientRight", null, PERM_IMPORT, reqPath);
            hasPermission = false;
        }
        return hasPermission;
    }

    private void preCoverageValidation(List<CoverageInstruction> coverageInstructions) {
        HashSet<RequirementVersionTarget> requirementVersionTargets = new HashSet<RequirementVersionTarget>();
        HashSet<TestCaseTarget> testCaseTargets = new HashSet<TestCaseTarget>();
        for (CoverageInstruction instruction : coverageInstructions) {
            this.entityValidator.preCoverageValidation(instruction);
            if (instruction.hasCriticalErrors()) continue;
            CoverageTarget target = (CoverageTarget)instruction.getTarget();
            RequirementTarget reqTarget = new RequirementTarget(target.getReqPath());
            RequirementVersionTarget reqVersionTarget = new RequirementVersionTarget(reqTarget, target.getReqVersion());
            target.setRequirementVersion(reqVersionTarget);
            requirementVersionTargets.add(reqVersionTarget);
            TestCaseTarget tcTarget = new TestCaseTarget(target.getTcPath());
            target.setTestCase(tcTarget);
            testCaseTargets.add(tcTarget);
        }
        this.model.initRequirements(requirementVersionTargets);
        this.model.mainInitTestCase(testCaseTargets);
    }

    @Override
    public void createOrUpdateRequirementLinks(List<RequirementLinkInstruction> instructions, Project project) {
        ValidationFacility.checkProjectValidity(project);
        this.preRequirementLinkValidation(instructions);
        Set<Long> versionIds = instructions.stream().map(Instruction::getTarget).flatMap(target -> Stream.of(this.model.getRequirementVersionId(target.getSourceVersion()), this.model.getRequirementVersionId(target.getDestVersion()))).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, Map<Long, Long>> existingLinks = this.requirementImportDao.findExistingLinksByVersionIds(versionIds);
        Map<Long, RequirementStatus> requirementStatuses = this.requirementImportDao.findRequirementStatusesByVersionIds(versionIds);
        String defaultRole = this.requirementImportDao.getDefaultRequirementVersionLinkRole();
        instructions.stream().filter(instruction -> !instruction.hasCriticalErrors()).forEach(instruction -> this.checkRequirementLink((RequirementLinkInstruction)instruction, requirementStatuses, existingLinks, defaultRole));
    }

    private void checkRequirementLink(RequirementLinkInstruction instruction, Map<Long, RequirementStatus> requirementStatuses, Map<Long, Map<Long, Long>> linkIdByVersions, String defaultRole) {
        RequirementLinkTarget target = (RequirementLinkTarget)instruction.getTarget();
        RequirementVersionTarget sourceVersion = target.getSourceVersion();
        this.existAndLinkable(instruction, sourceVersion, requirementStatuses, "message.import.log.error.requirementlinks.malformed-sourcepath", "message.import.log.error.requirementlinks.source-notexist");
        RequirementVersionTarget dest = target.getDestVersion();
        this.existAndLinkable(instruction, dest, requirementStatuses, "message.import.log.error.requirementlinks.malformed-destpath", "message.import.log.error.requirementlinks.dest-notexist");
        if (!instruction.hasCriticalErrors() && target.getSourceVersion().equals(target.getDestVersion())) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirementlinks.linking-same-requirement", "message.import.log.impact.line.ignored", new Object[0]);
            return;
        }
        this.checkRequirementLinkRole(instruction, defaultRole);
        Long sourceId = this.model.getRequirementVersionId(sourceVersion);
        Long destId = this.model.getRequirementVersionId(dest);
        Long existingOutboundLinkId = (Long)linkIdByVersions.getOrDefault(sourceId, Collections.emptyMap()).get(destId);
        Long existingInboundLinkId = (Long)linkIdByVersions.getOrDefault(destId, Collections.emptyMap()).get(sourceId);
        if (existingOutboundLinkId != null && existingInboundLinkId != null) {
            target.setExistingOutboundLinkId(existingOutboundLinkId);
            target.setExistingInboundLinkId(existingInboundLinkId);
        }
    }

    private void preRequirementLinkValidation(List<RequirementLinkInstruction> requirementLinkInstructions) {
        HashSet<RequirementVersionTarget> requirementVersionTargets = new HashSet<RequirementVersionTarget>();
        for (RequirementLinkInstruction instruction : requirementLinkInstructions) {
            this.entityValidator.preRequirementLinkValidation(instruction);
            if (instruction.hasCriticalErrors()) continue;
            RequirementLinkTarget target = (RequirementLinkTarget)instruction.getTarget();
            requirementVersionTargets.add(target.getSourceVersion());
            requirementVersionTargets.add(target.getDestVersion());
        }
        this.model.initRequirements(requirementVersionTargets);
    }

    @Override
    public void createOrUpdateLinkedLowLevelRequirements(List<LinkedLowLevelRequirementInstruction> instructions) {
        this.preLinkedLowLevelRequirementValidation(instructions);
        HashSet<Long> standardIds = new HashSet<Long>();
        HashSet<Long> requirementIds = new HashSet<Long>();
        for (LinkedLowLevelRequirementInstruction instruction2 : instructions) {
            Long highLevelId;
            if (instruction2.hasCriticalErrors()) continue;
            LinkedLowLevelRequirementTarget target = (LinkedLowLevelRequirementTarget)instruction2.getTarget();
            Long standardId = this.model.getRequirementId(target.getStandardRequirementTarget());
            if (standardId != null) {
                standardIds.add(standardId);
                requirementIds.add(standardId);
            }
            if ((highLevelId = this.model.getRequirementId(target.getHighLevelRequirementTarget())) == null) continue;
            requirementIds.add(highLevelId);
        }
        Map<Long, Long> existingHighLevelLinks = this.requirementImportDao.findExistingHighLevelLinksByRequirementIds(standardIds);
        Map<Long, RequirementStatus> requirementStatuses = this.requirementImportDao.findRequirementStatusesByRequirementIds(requirementIds);
        Set<Long> requirementChild = this.requirementImportDao.filterRequirementChild(requirementIds);
        instructions.stream().filter(instruction -> !instruction.hasCriticalErrors()).forEach(instruction -> this.checkLinkedLowLevel((LinkedLowLevelRequirementInstruction)instruction, requirementStatuses, existingHighLevelLinks, requirementChild));
    }

    private void preLinkedLowLevelRequirementValidation(List<LinkedLowLevelRequirementInstruction> linkedLowLevelRequirementInstructions) {
        HashSet<RequirementTarget> targets = new HashSet<RequirementTarget>();
        for (LinkedLowLevelRequirementInstruction instruction : linkedLowLevelRequirementInstructions) {
            this.entityValidator.preLinkedLowLevelRequirementValidation(instruction);
            if (instruction.hasCriticalErrors()) continue;
            LinkedLowLevelRequirementTarget target = (LinkedLowLevelRequirementTarget)instruction.getTarget();
            HighLevelRequirementTarget highLevelRequirementTarget = new HighLevelRequirementTarget(target.getHighLevelReqPath());
            RequirementTarget standardReqTarget = new RequirementTarget(target.getStandardReqPath());
            target.setHighLevelRequirementTarget(highLevelRequirementTarget);
            target.setStandardRequirementTarget(standardReqTarget);
            targets.add(highLevelRequirementTarget);
            targets.add(standardReqTarget);
        }
        this.model.loadRequirements(targets);
    }

    private void checkLinkedLowLevel(LinkedLowLevelRequirementInstruction instruction, Map<Long, RequirementStatus> requirementStatuses, Map<Long, Long> existingHighLevelLinks, Set<Long> requirementChild) {
        LinkedLowLevelRequirementTarget target = (LinkedLowLevelRequirementTarget)instruction.getTarget();
        HighLevelRequirementTarget highLevelTarget = target.getHighLevelRequirementTarget();
        RequirementTarget standardTarget = target.getStandardRequirementTarget();
        if (!this.validateRequirementExists(instruction, highLevelTarget, true) || !this.validateRequirementExists(instruction, standardTarget, false)) {
            return;
        }
        Long standardId = this.model.getRequirementId(standardTarget);
        Long highLevelId = this.model.getRequirementId(highLevelTarget);
        this.checkLinkedLowLevelRequirementPermissions(instruction, highLevelId, target.getHighLevelReqPath());
        this.checkLinkedLowLevelRequirementPermissions(instruction, standardId, target.getStandardReqPath());
        if (instruction.hasCriticalErrors()) {
            return;
        }
        if (requirementChild.contains(standardId)) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirement.cannotLinkToChildLowLevelRequirement", null, LinkedLowLevelRequirementsSheetColumn.STANDARD_REQ_PATH.getHeader());
            return;
        }
        ValidationFacility.validateRequirementStatus(instruction, requirementStatuses, standardId);
        ValidationFacility.validateRequirementStatus(instruction, requirementStatuses, highLevelId);
        if (instruction.hasCriticalErrors()) {
            return;
        }
        ValidationFacility.checkExistingHighLevelLink(instruction, existingHighLevelLinks, standardId, highLevelId);
    }

    private static void validateRequirementStatus(LinkedLowLevelRequirementInstruction instruction, Map<Long, RequirementStatus> requirementStatuses, Long requirementId) {
        RequirementStatus status = requirementStatuses.get(requirementId);
        if (status != null && !status.isRequirementLinkable()) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirement.version.statusLocked", null, new Object[0]);
        }
    }

    private static void checkExistingHighLevelLink(LinkedLowLevelRequirementInstruction instruction, Map<Long, Long> existingLinks, Long standardId, Long highLevelId) {
        Long existingLinkId = existingLinks.get(standardId);
        if (existingLinkId == null) {
            return;
        }
        if (existingLinkId.equals(highLevelId)) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.warning.linkAlreadyExist", "message.import.log.impact.line.ignored", new Object[0]);
        } else {
            instruction.addLogEntry(ImportStatus.WARNING, "message.import.log.warning.reqAlreadyLinkedToHighLvlReq", "message.import.log.impact.requirement.highLvlReqReferenceLoss", new Object[0]);
        }
    }

    private boolean validateRequirementExists(LinkedLowLevelRequirementInstruction instruction, RequirementTarget target, boolean isHighLevel) {
        boolean isValidType;
        Long id = this.model.getRequirementId(target);
        if (id == null) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirement.notExists", null, isHighLevel ? LinkedLowLevelRequirementsSheetColumn.HIGH_LEVEL_REQ_PATH.getHeader() : LinkedLowLevelRequirementsSheetColumn.STANDARD_REQ_PATH.getHeader());
            return false;
        }
        boolean bl = isValidType = isHighLevel == this.model.isHighLevelRequirement(target);
        if (!isValidType) {
            instruction.addLogEntry(ImportStatus.FAILURE, isHighLevel ? "message.import.log.error.requirement.requirementNotHighLevel" : "message.import.log.error.requirement.requirementNotStandard", null, new Object[0]);
            return false;
        }
        return true;
    }

    private void checkLinkedLowLevelRequirementPermissions(LinkedLowLevelRequirementInstruction instruction, Long requirementId, String requirementPath) {
        if (!this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, Permissions.READ.name(), requirementId, Requirement.class.getSimpleName())) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.unsuficientRight", null, Permissions.READ.name(), requirementPath);
            return;
        }
        if (!this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, Permissions.LINK.name(), requirementId, Requirement.class.getSimpleName())) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.unsuficientRight", null, Permissions.LINK.name(), requirementPath);
        }
    }

    @Override
    public LogTrain deleteRequirementLink(RequirementLinkInstruction instr) {
        return this.requirementsExistAndLinkable(instr);
    }

    private void checkRequirementLinkRole(RequirementLinkInstruction instr, String defaultRole) {
        String role = instr.getRelationRole();
        if (StringUtils.isBlank((CharSequence)role)) {
            instr.addLogEntry(ImportStatus.WARNING, "message.import.log.warning.requirementlinks.role-not-set", "message.import.log.impact.requirementlinks.role-not-set", new Object[0]);
            instr.setRelationRole(defaultRole);
            return;
        }
        Set<String> allRoles = this.model.getRequirementLinkRoles();
        if (!allRoles.contains(role)) {
            instr.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirementlinks.role-not-exists", role, new Object[0]);
        }
    }

    private void existAndLinkable(RequirementLinkInstruction instr, RequirementVersionTarget versionTarget, Map<Long, RequirementStatus> requirementStatuses, String malformedPathMessage, String nonexistentMessage) {
        if (!versionTarget.isWellFormed()) {
            instr.addLogEntry(ImportStatus.FAILURE, malformedPathMessage, null, versionTarget.getPath());
            return;
        }
        ProjectTargetStatus projectStatus = this.model.getProjectStatus(versionTarget.getProject());
        if (projectStatus.getStatus() != Existence.EXISTS) {
            instr.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.tc.tcPath.projectNotFound", null, new Object[0]);
            return;
        }
        Long requirementLibraryId = projectStatus.getRequirementLibraryId();
        if (requirementLibraryId != null && !this.permissionService.hasRoleOrPermissionOnObject(ROLE_ADMIN, Permissions.LINK.name(), requirementLibraryId, REQUIREMENT_VERSION_LIBRARY_CLASSNAME)) {
            instr.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.unsuficientRight", null, Permissions.LINK.name(), versionTarget.getPath());
            return;
        }
        TargetStatus versionStatus = this.model.getStatus(versionTarget);
        if (versionStatus.getStatus() != Existence.EXISTS && versionStatus.getStatus() != Existence.TO_BE_CREATED) {
            instr.addLogEntry(ImportStatus.FAILURE, nonexistentMessage, null, new Object[0]);
            return;
        }
        Long versionId = this.model.getRequirementVersionId(versionTarget);
        if (versionId != null) {
            RequirementStatus status = requirementStatuses.get(versionId);
            if (!status.isRequirementLinkable()) {
                instr.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirementlinks.not-linkable", null, new Object[0]);
            }
        } else if (!versionTarget.getImportedRequirementStatus().isRequirementLinkable()) {
            instr.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirementlinks.not-linkable", null, new Object[0]);
        }
    }

    private LogTrain requirementsExistAndLinkable(RequirementLinkInstruction instr) {
        LogTrain logs = new LogTrain();
        RequirementLinkTarget linkTarget = (RequirementLinkTarget)instr.getTarget();
        RequirementVersionTarget source = linkTarget.getSourceVersion();
        this.existAndLinkable(linkTarget, source, logs, "message.import.log.error.requirementlinks.malformed-sourcepath", "message.import.log.error.requirementlinks.source-notexist");
        RequirementVersionTarget dest = linkTarget.getDestVersion();
        this.existAndLinkable(linkTarget, dest, logs, "message.import.log.error.requirementlinks.malformed-destpath", "message.import.log.error.requirementlinks.dest-notexist");
        if (!logs.hasCriticalErrors() && linkTarget.getSourceVersion().equals(linkTarget.getDestVersion())) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage("message.import.log.error.requirementlinks.linking-same-requirement", new Object[0]).build());
        }
        return logs;
    }

    private void existAndLinkable(RequirementLinkTarget linkTarget, RequirementVersionTarget versionTarget, LogTrain logs, String malformedPathMessage, String nonexistentMessage) {
        LogEntry entry;
        if (!versionTarget.isWellFormed()) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage(malformedPathMessage, versionTarget.getPath()).build());
            return;
        }
        ProjectTargetStatus projectStatus = this.model.getProjectStatus(versionTarget.getProject());
        if (projectStatus.getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
            return;
        }
        TargetStatus versionStatus = this.model.getStatus(versionTarget);
        if (versionStatus.getStatus() != Existence.EXISTS && versionStatus.getStatus() != Existence.TO_BE_CREATED) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage(nonexistentMessage, new Object[0]).build());
            return;
        }
        Long reqId = this.reqFinderService.findNodeIdByPath(versionTarget.getPath());
        if (reqId != null) {
            Requirement req = this.reqFinderService.findRequirement(reqId);
            RequirementVersion reqVersion = req.findRequirementVersion(versionTarget.getVersion().intValue());
            if (!reqVersion.getStatus().isRequirementLinkable()) {
                logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage("message.import.log.error.requirementlinks.not-linkable", new Object[0]).build());
                return;
            }
        } else if (!versionTarget.getImportedRequirementStatus().isRequirementLinkable()) {
            logs.addEntry(LogEntry.failure().forTarget(linkTarget).withMessage("message.import.log.error.requirementlinks.not-linkable", new Object[0]).build());
            return;
        }
        if ((entry = this.checkPermissionOnProject("LINK", versionTarget, (Target)linkTarget)) != null) {
            logs.addEntry(entry);
        }
    }

    @Override
    public void createParameters(List<ParameterInstruction> parameterInstructions, Project project) {
        ValidationFacility.checkProjectValidity(project);
        Set<TestCaseTarget> testCaseTargets = parameterInstructions.stream().map(instruction -> {
            ParameterTarget target = (ParameterTarget)instruction.getTarget();
            target.setName(instruction.getParameter().getName());
            return target.getOwner();
        }).collect(Collectors.toSet());
        this.model.initParameters(testCaseTargets);
        parameterInstructions.forEach(this::checkParameterCreation);
    }

    @Override
    public void createDatasets(List<DatasetInstruction> instructions, Project project) {
        ValidationFacility.checkProjectValidity(project);
        Set<TestCaseTarget> testCaseTargets = instructions.stream().map(instruction -> ((DatasetTarget)instruction.getTarget()).getTestCase()).collect(Collectors.toSet());
        this.model.initStatuses(testCaseTargets);
        instructions.forEach(this::checkDatasetCreation);
    }

    @Override
    public void addActionSteps(List<ActionStepInstruction> instructions, Project project) {
        ValidationFacility.checkProjectValidity(project);
        Set<TestCaseTarget> testCaseTargets = instructions.stream().map(instruction -> ((TestStepTarget)instruction.getTarget()).getTestCase()).collect(Collectors.toSet());
        this.model.initStatuses(testCaseTargets);
        instructions.forEach(this::checkActionStepAddition);
    }

    @Override
    public void addCallSteps(List<CallStepInstruction> instructions, Project project) {
        ValidationFacility.checkProjectValidity(project);
        this.initializationsForCallSteps(instructions);
        instructions.forEach(this::checkCallStepCreation);
    }

    private void initializationsForCallSteps(List<CallStepInstruction> instructions) {
        Map targetsByProject = instructions.stream().flatMap(i -> Stream.of(((TestStepTarget)i.getTarget()).getTestCase(), i.getCalledTC())).collect(Collectors.groupingBy(TestCaseTarget::getProject, Collectors.toSet()));
        HashSet<Long> ids = new HashSet<Long>();
        for (Map.Entry entry : targetsByProject.entrySet()) {
            Map<TestCaseTarget, Long> targetIds = this.model.getTargetIds(entry.getValue());
            instructions.stream().filter(i -> targetIds.containsKey(((TestStepTarget)i.getTarget()).getTestCase()) && targetIds.containsKey(i.getCalledTC())).flatMap(i -> Stream.of(((TestStepTarget)i.getTarget()).getTestCase(), i.getCalledTC())).map(targetIds::get).forEach(ids::add);
        }
        if (ids.isEmpty()) {
            return;
        }
        this.model.initRecursiveCallGraph(ids);
    }

    @Override
    public void addDatasetParametersValues(List<DatasetParamValueInstruction> instructions, Project project) {
        ValidationFacility.checkProjectValidity(project);
        Set<TestCaseTarget> testCaseTargets = instructions.stream().flatMap(i -> Stream.of(((DatasetTarget)i.getTarget()).getTestCase(), i.getParameterTarget().getOwner())).collect(Collectors.toSet());
        this.model.initStatuses(testCaseTargets);
        this.model.initCallGraph(testCaseTargets);
        instructions.forEach(this::checkDatasetParameterValueCreation);
    }

    private void checkDatasetParameterValueCreation(DatasetParamValueInstruction instruction) {
        LogTrain logs = this.failsafeUpdateParameterValue((DatasetTarget)instruction.getTarget(), instruction.getParameterTarget(), instruction.getDatasetValue().getValue(), false);
        instruction.addLogs(logs);
    }

    private abstract class AbstractMilestonesValidationStrategy<I extends Instruction<T>, T extends Target & WithPath> {
        private AbstractMilestonesValidationStrategy() {
        }

        public void validateMilestones(I instr, LogTrain logs) {
            Object target = ((Instruction)instr).getTarget();
            if (!ValidationFacility.this.milestonesEnabled && !((Milestoned)instr).getMilestones().isEmpty()) {
                logs.addEntry(this.logEntry().forTarget((Target)target).withMessage("message.import.log.error.milestoneFeatureDeactivated", new Object[0]).build());
            }
            if (ValidationFacility.this.milestonesEnabled) {
                MilestoneImportHelper.Partition existing = ValidationFacility.this.milestoneHelper.partitionExisting(((Milestoned)instr).getMilestones());
                MilestoneImportHelper.Partition bindables = ValidationFacility.this.milestoneHelper.partitionBindable(existing.passing, ((WithPath)target).getProject());
                logs.addEntries(this.logUnknownMilestones(target, existing.rejected));
                logs.addEntries(this.logUnbindableMilestones(target, bindables.rejected));
            }
        }

        protected abstract LogEntry.Builder logEntry();

        protected List<LogEntry> logUnbindableMilestones(T target, List<String> rejected) {
            ArrayList<LogEntry> logs = new ArrayList<LogEntry>(rejected.size());
            for (String name : rejected) {
                logs.add(this.logEntry().forTarget((Target)target).withMessage("message.import.log.error.milestone.wrongStatus", name).build());
            }
            return logs;
        }

        protected List<LogEntry> logUnknownMilestones(T target, List<String> rejected) {
            ArrayList<LogEntry> logs = new ArrayList<LogEntry>(rejected.size());
            for (String name : rejected) {
                logs.add(this.logEntry().forTarget((Target)target).withMessage("message.import.log.error.milestone.unknown", name).build());
            }
            return logs;
        }
    }

    private final class CreationStrategy<I extends Instruction<T>, T extends Target & WithPath>
    extends AbstractMilestonesValidationStrategy<I, T> {
        private CreationStrategy() {
        }

        @Override
        protected LogEntry.Builder logEntry() {
            return LogEntry.failure();
        }
    }

    private final class UpdateStrategy<I extends Instruction<T>, T extends Target & WithPath>
    extends AbstractMilestonesValidationStrategy<I, T> {
        private UpdateStrategy() {
        }

        @Override
        protected LogEntry.Builder logEntry() {
            return LogEntry.warning();
        }
    }
}

