/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration;

import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.domain.artificialintelligence.AiUsageName;
import org.squashtest.tm.domain.artificialintelligence.ProjectAiConfiguration;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.testcasegeneration.AiTestCaseGenerationViewService;
import org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration.AiTestCaseGenerationViewServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.display.dto.PromptDto;
import org.squashtest.tm.service.internal.repository.AiUsageDao;
import org.squashtest.tm.service.internal.repository.ProjectAiConfigurationDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.display.AiTestCaseGenerationDisplayDao;
import org.squashtest.tm.service.internal.repository.display.PromptDisplayDao;
import org.squashtest.tm.service.internal.templaterenderer.HandlebarsTemplateRenderer;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class AiTestCaseGenerationViewServiceImpl
implements AiTestCaseGenerationViewService {
    private static final String REQUIREMENT = "requirement";
    private final PromptDisplayDao promptDisplayDao;
    private final UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;
    private final ProjectAiConfigurationDao projectAiConfigurationDao;
    private final AiUsageDao aiUsageDao;
    private final AiTestCaseGenerationDisplayDao aiTestCaseGenerationDisplayDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private final UserDao userDao;
    private final RequirementVersionDao requirementVersionDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AiTestCaseGenerationViewServiceImpl(PromptDisplayDao promptDisplayDao, UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService, ProjectAiConfigurationDao projectAiConfigurationDao, AiUsageDao aiUsageDao, AiTestCaseGenerationDisplayDao aiTestCaseGenerationDisplayDao, PermissionEvaluationService permissionEvaluationService, UserDao userDao, RequirementVersionDao requirementVersionDao) {
        this.promptDisplayDao = promptDisplayDao;
        this.ultimateLicenseAvailabilityService = ultimateLicenseAvailabilityService;
        this.projectAiConfigurationDao = projectAiConfigurationDao;
        this.aiUsageDao = aiUsageDao;
        this.aiTestCaseGenerationDisplayDao = aiTestCaseGenerationDisplayDao;
        this.permissionEvaluationService = permissionEvaluationService;
        this.userDao = userDao;
        this.requirementVersionDao = requirementVersionDao;
    }

    @Override
    @IsUltimateLicenseAvailable
    public List<PromptDto> findAllPromptsByRequirementVersionId(Long requirementVersionId) {
        List<PromptDto> prompts = this.promptDisplayDao.findAllForClassicTcGenerationByReqVersionId(requirementVersionId);
        String requirementDescription = String.format("<br><br>%s", this.requirementVersionDao.findDescription(requirementVersionId));
        prompts.forEach(prompt -> {
            PromptDto promptDto = prompt;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, (Object)promptDto);
            Object[] objectArray = new Object[]{promptDto, joinPoint};
            AiTestCaseGenerationViewServiceImpl$AjcClosure1 aiTestCaseGenerationViewServiceImpl$AjcClosure1 = new AiTestCaseGenerationViewServiceImpl$AjcClosure1(objectArray);
            String userPromptWithRequirement = HandlebarsTemplateRenderer.renderTemplate((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(aiTestCaseGenerationViewServiceImpl$AjcClosure1.linkClosureAndJoinPoint(16)), Map.of(REQUIREMENT, requirementDescription));
            prompt.setUserPromptTemplate(userPromptWithRequirement);
        });
        return prompts;
    }

    @Override
    public boolean canGenerateTestCases(Long requirementVersionId) {
        if (!this.ultimateLicenseAvailabilityService.isAvailable()) {
            return false;
        }
        if (this.isRequirementVersionIncorrect(requirementVersionId)) {
            return false;
        }
        if (!this.isUserAllowedToCreateTestCases()) {
            return false;
        }
        return this.isAiProjectConfigurationCorrect(requirementVersionId);
    }

    boolean isRequirementVersionIncorrect(Long requirementVersionId) {
        RequirementVersion requirementVersion = this.requirementVersionDao.findById(requirementVersionId).orElse(null);
        return requirementVersion == null || RequirementStatus.OBSOLETE.equals((Object)requirementVersion.getStatus()) || requirementVersion.getDescription().isBlank();
    }

    boolean isUserAllowedToCreateTestCases() {
        Long userId = this.userDao.findUserId(UserContextHolder.getUsername());
        return this.permissionEvaluationService.hasAtLeastOneTestCaseCreationPermissionOrAdmin(userId);
    }

    boolean isAiProjectConfigurationCorrect(Long requirementVersionId) {
        Long projectIdLinkedToRequirement = this.requirementVersionDao.findProjectIdByRequirementVersionId(requirementVersionId);
        Long aiUsageId = this.aiUsageDao.findAiUsageIdByUsage(AiUsageName.CLASSIC_TEST_CASE_GENERATION);
        ProjectAiConfiguration configuration = this.projectAiConfigurationDao.findByProjectIdAndAiUsageId(projectIdLinkedToRequirement, aiUsageId);
        if (configuration == null) {
            return false;
        }
        if (configuration.getAiServer() == null) {
            return false;
        }
        if (configuration.getPromptSet() == null) {
            return false;
        }
        if (configuration.getPromptSet().getPrompts().isEmpty()) {
            return false;
        }
        return this.aiTestCaseGenerationDisplayDao.isAiServerProperlyConfigured(configuration.getAiServer().getId(), aiUsageId, projectIdLinkedToRequirement);
    }

    static {
        AiTestCaseGenerationViewServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getUserPromptTemplate_aroundBody0(PromptDto promptDto, JoinPoint joinPoint) {
        return promptDto.getUserPromptTemplate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AiTestCaseGenerationViewServiceImpl.java", AiTestCaseGenerationViewServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getUserPromptTemplate", "org.squashtest.tm.service.internal.display.dto.PromptDto", "", "", "", "java.lang.String"), 89);
    }
}

