/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence;

import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.service.Result;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerCouldNotExecuteRequestException;
import org.squashtest.tm.exception.artificialintelligence.server.MaxTokenLimitReachedException;
import org.squashtest.tm.service.internal.artificialintelligence.AiAssistant;

public class AiChatClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiChatClient.class);
    private AiAssistant aiAssistant;

    public AiChatClient(AiAssistant aiAssistant) {
        this.aiAssistant = aiAssistant;
    }

    public Result<String> doChat(String userMessage) {
        Result<String> response;
        try {
            response = this.aiAssistant.doChat(userMessage);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while sending request to AI server", (Throwable)e);
            throw new AiServerCouldNotExecuteRequestException(e.getMessage());
        }
        this.checkIfMaxLimitTokenReached(response);
        return response;
    }

    private void checkIfMaxLimitTokenReached(Result<String> response) {
        if (FinishReason.LENGTH == response.finishReason()) {
            throw new MaxTokenLimitReachedException();
        }
    }
}

