/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testplanitem;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.campaign.SprintNotLinkableException;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testplanitem.SprintTestPlanItemManager;

@Service
@Transactional
public class SprintTestPlanItemManagerImpl
implements SprintTestPlanItemManager {
    private final CampaignNodeDeletionHandler deletionHandler;
    private final PermissionEvaluationService permissionEvaluationService;
    private final UserDao userDao;
    private final SprintReqVersionDao sprintReqVersionDao;

    public SprintTestPlanItemManagerImpl(CampaignNodeDeletionHandler deletionHandler, PermissionEvaluationService permissionEvaluationService, UserDao userDao, SprintReqVersionDao sprintReqVersionDao) {
        this.deletionHandler = deletionHandler;
        this.permissionEvaluationService = permissionEvaluationService;
        this.userDao = userDao;
        this.sprintReqVersionDao = sprintReqVersionDao;
    }

    @Override
    public void applyFastPass(List<Long> testPlanItemIds, String statusName) {
        this.permissionEvaluationService.checkPermission(testPlanItemIds, Permissions.EXECUTE.name(), TestPlanItem.class.getName());
        List<SprintReqVersion> sprintReqVersions = this.sprintReqVersionDao.findWithSprintByTestPlanItemIds(testPlanItemIds);
        Map<SprintReqVersion, List> testPlanItemsBySprintReqVersion = sprintReqVersions.stream().collect(Collectors.toMap(sprintReqVersion -> sprintReqVersion, sprintReqVersion -> sprintReqVersion.getTestPlan().getTestPlanItems().stream().filter(item -> testPlanItemIds.contains(item.getId())).toList()));
        ExecutionStatus status = ExecutionStatus.valueOf((String)statusName);
        String login = UserContextHolder.getUsername();
        User user = this.userDao.findUserByLogin(login);
        if (testPlanItemsBySprintReqVersion.entrySet().stream().allMatch(entry -> SprintStatus.CLOSED.equals((Object)((SprintReqVersion)entry.getKey()).getSprint().getStatus()))) {
            throw new SprintClosedException();
        }
        testPlanItemsBySprintReqVersion.forEach((sprintReqVersion, testPlanItems) -> {
            if (!SprintStatus.CLOSED.equals((Object)sprintReqVersion.getSprint().getStatus())) {
                testPlanItems.forEach(testPlanItem -> testPlanItem.applyFastPass(status, user));
            }
        });
    }

    @Override
    public void deleteSprintReqVersionTestPlanItems(Long sprintReqVersionId, List<Long> testPlanItemIds) {
        this.performDeleteSprintReqVersionTestPlanItems(sprintReqVersionId, testPlanItemIds, true);
    }

    @Override
    public void deleteSprintReqVersionTestPlanItemsWithoutException(Long sprintReqVersionId, List<Long> testPlanItemIds) {
        this.performDeleteSprintReqVersionTestPlanItems(sprintReqVersionId, testPlanItemIds, false);
    }

    private void performDeleteSprintReqVersionTestPlanItems(Long sprintReqVersionId, List<Long> testPlanItemIds, boolean shouldThrowException) {
        if (testPlanItemIds.isEmpty()) {
            return;
        }
        SprintStatus sprintStatus = this.sprintReqVersionDao.findSprintStatus(sprintReqVersionId);
        if (SprintStatus.CLOSED.equals((Object)sprintStatus)) {
            throw new SprintNotLinkableException();
        }
        List<Long> itemsToRemove = this.sprintReqVersionDao.findSprintReqVersionTestPlanItems(sprintReqVersionId, testPlanItemIds);
        if (!itemsToRemove.isEmpty()) {
            this.deletionHandler.removeTestPlanItems(testPlanItemIds, shouldThrowException);
        }
    }
}

