/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.display.requirements.RequirementPathFinderService;
import org.squashtest.tm.service.internal.display.dto.requirement.HighLevelRequirementVersionDto;
import org.squashtest.tm.service.internal.dto.HighLevelRequirementExceptionSummary;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.display.HighLevelRequirementDisplayDao;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component
@Transactional
public class HighLevelRequirementServiceImpl
implements HighLevelRequirementService {
    @PersistenceContext
    private final EntityManager entityManager;
    private final PermissionEvaluationService permissionEvaluationService;
    private final RequirementDao requirementDao;
    private final HighLevelRequirementDisplayDao highLevelRequirementDisplayDao;
    private final RequirementPathFinderService requirementsPathService;

    public HighLevelRequirementServiceImpl(EntityManager entityManager, PermissionEvaluationService permissionEvaluationService, RequirementDao requirementDao, HighLevelRequirementDisplayDao highLevelRequirementDisplayDao, RequirementPathFinderService requirementsPathService) {
        this.entityManager = entityManager;
        this.permissionEvaluationService = permissionEvaluationService;
        this.requirementDao = requirementDao;
        this.highLevelRequirementDisplayDao = highLevelRequirementDisplayDao;
        this.requirementsPathService = requirementsPathService;
    }

    @Override
    public void linkToHighLevelRequirement(Long highLevelRequirementId, Long lowLevelRequirementId) {
        boolean requirementIsNotChild;
        HighLevelRequirement highLevelRequirement = (HighLevelRequirement)this.entityManager.find(HighLevelRequirement.class, (Object)highLevelRequirementId);
        Requirement lowLevelRequirement = (Requirement)this.entityManager.find(Requirement.class, (Object)lowLevelRequirementId);
        boolean permOnLowReq = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.LINK.name(), lowLevelRequirement);
        boolean permOnHighReq = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ.name(), highLevelRequirement);
        boolean bl = requirementIsNotChild = !this.requirementDao.checkIfRequirementIsChild(lowLevelRequirementId);
        if (permOnHighReq && permOnLowReq) {
            if (requirementIsNotChild) {
                lowLevelRequirement.setHighLevelRequirement(highLevelRequirement);
                this.addHighLevelRequirementLinkToChildren(lowLevelRequirementId, highLevelRequirement);
            }
        } else {
            throw new AccessDeniedException("No permissions...");
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'LINK') or hasRole('ROLE_ADMIN')")
    public void unlinkToHighLevelRequirement(Long requirementId) {
        Requirement lowLevelRequirement = (Requirement)this.entityManager.find(Requirement.class, (Object)requirementId);
        lowLevelRequirement.setHighLevelRequirement(null);
        List<Long> allChildrenIds = this.requirementDao.findAllChildrenIdsFromRequirementId(lowLevelRequirement.getId());
        List children = this.requirementDao.findAllByIds(allChildrenIds);
        children.forEach(child -> child.setHighLevelRequirement(null));
    }

    @Override
    @PreAuthorize(value="hasPermission(#highLevelRequirementId, 'org.squashtest.tm.domain.requirement.HighLevelRequirement', 'LINK') or hasRole('ROLE_ADMIN')")
    @UsedInPlugin(names={PluginName.API_REST})
    public void bindRequirementsToHighLevelRequirement(Long highLevelRequirementId, List<Long> lowLevelRequirementIds, HighLevelRequirementExceptionSummary summary) {
        this.bindRequirementsToHighLevelRequirementUnsecured(highLevelRequirementId, lowLevelRequirementIds, summary, true);
    }

    @Override
    public void bindRequirementsToHighLevelRequirementUnsecured(Long highLevelRequirementId, List<Long> lowLevelRequirementIds, HighLevelRequirementExceptionSummary summary, boolean withCheckPermissionOnRequirements) {
        HighLevelRequirement highLevelRequirement = (HighLevelRequirement)this.entityManager.find(HighLevelRequirement.class, (Object)highLevelRequirementId);
        List<Long> allRequirementIdsWithoutFolder = this.requirementDao.findAllRequirementsIdsByNodes(lowLevelRequirementIds);
        if (withCheckPermissionOnRequirements) {
            this.checkPermissionOnRequirements(allRequirementIdsWithoutFolder);
        }
        List<Requirement> requirementList = this.requirementDao.findAllByIds(allRequirementIdsWithoutFolder);
        List<Requirement> filteredRequirementList = this.removeChildrenReqWithAncestorInSelection(requirementList, allRequirementIdsWithoutFolder);
        for (Requirement requirement : filteredRequirementList) {
            boolean canBindToHighLevelRequirement = this.canBindToHighLevelRequirement((Requirement)highLevelRequirement, requirement, summary);
            if (!canBindToHighLevelRequirement) continue;
            requirement.setHighLevelRequirement(highLevelRequirement);
            this.addHighLevelRequirementLinkToChildren(requirement.getId(), highLevelRequirement);
        }
    }

    private List<Requirement> removeChildrenReqWithAncestorInSelection(List<Requirement> requirementList, List<Long> allRequirementIdsWithoutFolder) {
        ArrayList<Requirement> filteredRequirementList = new ArrayList<Requirement>();
        requirementList.forEach(requirement -> {
            boolean requirementIsChild = this.requirementDao.checkIfRequirementIsChild(requirement.getId());
            if (!requirementIsChild) {
                filteredRequirementList.add((Requirement)requirement);
            } else if (!this.checkIfAncestorIsInSelection(allRequirementIdsWithoutFolder, requirement.getId())) {
                filteredRequirementList.add((Requirement)requirement);
            }
        });
        return filteredRequirementList;
    }

    @Override
    public void addHighLevelRequirementLinkToChildren(Long lowLevelRequirementId, HighLevelRequirement highLevelRequirement) {
        List<Long> allChildrenIds = this.requirementDao.findAllChildrenIdsFromRequirementId(lowLevelRequirementId);
        List children = this.requirementDao.findAllByIds(allChildrenIds);
        children.forEach(child -> child.setHighLevelRequirement(highLevelRequirement));
    }

    private boolean checkIfAncestorIsInSelection(List<Long> allRequirementIdsWithoutFolder, Long requirementId) {
        Long ancestorId = this.requirementDao.findRequirementAncestorId(requirementId);
        return allRequirementIdsWithoutFolder.contains(ancestorId);
    }

    private void checkPermissionOnRequirements(List<Long> requirementIds) {
        this.permissionEvaluationService.checkPermission(requirementIds, Permissions.READ.name(), Requirement.class.getName());
    }

    private boolean canBindToHighLevelRequirement(Requirement highLevelRequirement, Requirement requirement, HighLevelRequirementExceptionSummary summary) {
        Long highLevelRequirementId = highLevelRequirement.getId();
        return !this.checkIfLinkAlreadyExists(highLevelRequirementId, requirement, summary) && !this.checkIfHighLevelRequirementsInSelection(requirement, summary) && !this.checkIfAlreadyLinkedToAnotherHighLevelRequirement(highLevelRequirementId, requirement, summary) && !this.checkIfVersionsAreLinkable(highLevelRequirement.getCurrentVersion(), requirement.getCurrentVersion(), summary) && !this.checkIfChildRequirementsIsInSelection(requirement, summary);
    }

    @Override
    @PreAuthorize(value="hasPermission(#highLevelRequirementId, 'org.squashtest.tm.domain.requirement.HighLevelRequirement', 'LINK') or hasRole('ROLE_ADMIN')")
    @UsedInPlugin(names={PluginName.API_REST})
    public void unbindRequirementFromHighLevelRequirement(Long highLevelRequirementId, List<Long> lowLevelRequirementIds) {
        List requirementList = this.requirementDao.findAllByIds(lowLevelRequirementIds);
        for (Requirement requirement : requirementList) {
            if (this.requirementDao.checkIfRequirementIsChild(requirement.getId())) continue;
            requirement.setHighLevelRequirement(null);
            this.removeHighLevelRequirementLinkFromChildren(requirement.getId());
        }
    }

    private void removeHighLevelRequirementLinkFromChildren(Long lowLevelRequirementId) {
        List<Long> allChildrenIds = this.requirementDao.findAllChildrenIdsFromRequirementId(lowLevelRequirementId);
        List children = this.requirementDao.findAllByIds(allChildrenIds);
        children.forEach(child -> child.setHighLevelRequirement(null));
    }

    @Override
    public List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> findLinkedLowLevelRequirements(Long requirementId) {
        List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> linkedLowLevelRequirementDtoList = this.highLevelRequirementDisplayDao.findLinkedLowLevelRequirements(requirementId);
        for (HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto linkedLowLevelRequirementDto : linkedLowLevelRequirementDtoList) {
            linkedLowLevelRequirementDto.setPath(this.requirementsPathService.buildRequirementLinkPath(linkedLowLevelRequirementDto.getRequirementId(), linkedLowLevelRequirementDto.getProjectName()));
        }
        return linkedLowLevelRequirementDtoList;
    }

    @Override
    public Map<Long, List<Long>> findLinkedLowLevelReqIdsMappedByHighLevelReqIdFromVersionIds(List<Long> versionIds) {
        return this.highLevelRequirementDisplayDao.findAllLinkedLowLevelReqIdsMappedByHighLevelReqIdFromVersionIds(versionIds);
    }

    @Override
    @UsedInPlugin(names={PluginName.API_REST})
    public List<Requirement> findStandardRequirementsByHighLvlReqId(Long highLevelRequirementId) {
        Set<Long> linkedLowLevelReqIds = this.highLevelRequirementDisplayDao.findStandardRequirementsByHighLvlReqId(highLevelRequirementId);
        return this.requirementDao.findAllByIds(linkedLowLevelReqIds);
    }

    private boolean checkIfVersionsAreLinkable(RequirementVersion reqVersion, RequirementVersion relatedReqVersion, HighLevelRequirementExceptionSummary summary) {
        if (!reqVersion.isLinkable() || !relatedReqVersion.isLinkable()) {
            summary.getRequirementWithNotLinkableStatus().add(relatedReqVersion.getFullName());
            return true;
        }
        return false;
    }

    private boolean checkIfChildRequirementsIsInSelection(Requirement requirement, HighLevelRequirementExceptionSummary summary) {
        if (this.requirementDao.checkIfRequirementIsChild(requirement.getId())) {
            summary.getChildRequirementsInSelection().add(requirement.getCurrentVersion().getFullName());
            return true;
        }
        return false;
    }

    private boolean checkIfLinkAlreadyExists(Long reqId, Requirement relatedReq, HighLevelRequirementExceptionSummary summary) {
        HighLevelRequirement highLevelRequirement = relatedReq.getHighLevelRequirement();
        if (highLevelRequirement != null && reqId.equals(highLevelRequirement.getId())) {
            summary.getAlreadyLinked().add(relatedReq.getCurrentVersion().getFullName());
            return true;
        }
        return false;
    }

    private boolean checkIfHighLevelRequirementsInSelection(Requirement requirement, HighLevelRequirementExceptionSummary summary) {
        if (requirement.isHighLevel()) {
            summary.getHighLevelRequirementsInSelection().add(requirement.getCurrentVersion().getFullName());
            return true;
        }
        return false;
    }

    private boolean checkIfAlreadyLinkedToAnotherHighLevelRequirement(Long reqId, Requirement requirement, HighLevelRequirementExceptionSummary summary) {
        HighLevelRequirement highLevelRequirement = requirement.getHighLevelRequirement();
        if (requirement.getHighLevelRequirement() != null && !reqId.equals(highLevelRequirement.getId())) {
            summary.getAlreadyLinkedToAnotherHighLevelRequirement().add(requirement.getCurrentVersion().getFullName());
            return true;
        }
        return false;
    }
}

