/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.converters;

import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.stereotype.Service;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignStatus;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverviewStatus;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationStatus;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintReqVersionValidationStatus;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValueDto;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedNumericValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedRichValue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEvent;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEventType;
import org.squashtest.tm.domain.execution.KeywordExecution;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.execution.SessionNoteKind;
import org.squashtest.tm.domain.infolist.DenormalizedNature;
import org.squashtest.tm.domain.infolist.DenormalizedType;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.DenormalizedValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListItemPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.CampaignPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IssuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IterationPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SessionEventPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SessionNotePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SessionOverviewPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintReqVersionPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestSuitePivot;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure11;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure13;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure15;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.pivot.converters.ExecutionWorkspaceConverterServiceImpl$AjcClosure9;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.ExecutionPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.SprintPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Service(value="ExecutionWorkspaceConverterService")
public class ExecutionWorkspaceConverterServiceImpl
implements ExecutionWorkspaceConverterService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    @Override
    public Campaign pivotToCampaign(CampaignPivot campaignPivot) {
        Campaign campaign = new Campaign();
        campaign.setName(campaignPivot.getName());
        CampaignPivot campaignPivot2 = campaignPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)campaignPivot2);
        Object[] objectArray = new Object[]{this, campaignPivot2, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure1 executionWorkspaceConverterServiceImpl$AjcClosure1 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure1(objectArray);
        campaign.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        Optional.ofNullable(campaignPivot.getReference()).ifPresent(arg_0 -> ((Campaign)campaign).setReference(arg_0));
        Optional.ofNullable(campaignPivot.getStatus()).ifPresent(arg_0 -> ((Campaign)campaign).setStatus(arg_0));
        campaign.setScheduledEndDate(campaignPivot.getScheduledEndDate());
        campaign.setScheduledStartDate(campaignPivot.getScheduledStartDate());
        campaign.setUnsafeActualPeriod(campaignPivot.isActualStartDateAuto(), campaignPivot.isActualEndDateAuto(), campaignPivot.getActualStartDate(), campaignPivot.getActualEndDate());
        campaign.setCreatedBy(campaignPivot.getCreatedBy());
        campaign.setCreatedOn(campaignPivot.getCreatedOn());
        return campaign;
    }

    @Override
    public Iteration pivotToIteration(IterationPivot iterationPivot) {
        Iteration iteration = new Iteration();
        iteration.setName(iterationPivot.getName());
        IterationPivot iterationPivot2 = iterationPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)iterationPivot2);
        Object[] objectArray = new Object[]{this, iterationPivot2, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure3 executionWorkspaceConverterServiceImpl$AjcClosure3 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure3(objectArray);
        iteration.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)));
        Optional.ofNullable(iterationPivot.getReference()).ifPresent(arg_0 -> ((Iteration)iteration).setReference(arg_0));
        Optional.ofNullable(iterationPivot.getStatus()).ifPresent(arg_0 -> ((Iteration)iteration).setStatus(arg_0));
        iteration.setScheduledEndDate(iterationPivot.getScheduledEndDate());
        iteration.setScheduledStartDate(iterationPivot.getScheduledStartDate());
        iteration.setUnsafeActualPeriod(iterationPivot.isActualStartDateAuto(), iterationPivot.isActualEndDateAuto(), iterationPivot.getActualStartDate(), iterationPivot.getActualEndDate());
        iteration.setCreatedBy(iterationPivot.getCreatedBy());
        iteration.setCreatedOn(iterationPivot.getCreatedOn());
        return iteration;
    }

    @Override
    public TestSuite pivotToTestSuite(TestSuitePivot testSuitePivot, PivotImportMetadata pivotImportMetadata) {
        TestSuite testSuite = new TestSuite();
        testSuite.setName(testSuitePivot.getName());
        TestSuitePivot testSuitePivot2 = testSuitePivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)testSuitePivot2);
        Object[] objectArray = new Object[]{this, testSuitePivot2, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure5 executionWorkspaceConverterServiceImpl$AjcClosure5 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure5(objectArray);
        testSuite.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112)));
        Optional.ofNullable(this.getAvailableStatus(testSuitePivot.getStatus(), pivotImportMetadata)).ifPresent(arg_0 -> ((TestSuite)testSuite).setExecutionStatus(arg_0));
        testSuite.setCreatedBy(testSuitePivot.getCreatedBy());
        testSuite.setCreatedOn(testSuitePivot.getCreatedOn());
        return testSuite;
    }

    @Override
    public ExploratorySessionOverview pivotToExploratorySessionOverview(SessionOverviewPivot sessionOverviewPivot) {
        ExploratorySessionOverview sessionOverview = new ExploratorySessionOverview();
        sessionOverview.setName(sessionOverviewPivot.getName());
        sessionOverview.setCharter(sessionOverviewPivot.getCharter());
        sessionOverview.setUnsafeSessionStatus(sessionOverviewPivot.getStatus().name());
        sessionOverview.setUnsafeSessionDuration(sessionOverviewPivot.getSessionDuration());
        sessionOverview.setUnsafeDueDate(sessionOverviewPivot.getDueDate());
        sessionOverview.setUnsafeComments(sessionOverviewPivot.getComment());
        Optional.ofNullable(sessionOverviewPivot.getReference()).ifPresent(arg_0 -> ((ExploratorySessionOverview)sessionOverview).setReference(arg_0));
        return sessionOverview;
    }

    @Override
    public ExploratoryExecutionEvent pivotToExploratoryExecutionEvent(SessionEventPivot sessionEventPivot) {
        ExploratoryExecutionEvent sessionEvent = new ExploratoryExecutionEvent();
        sessionEvent.setAuthor(sessionEventPivot.getAuthor());
        sessionEvent.setDate(sessionEventPivot.getEventDate());
        sessionEvent.setEventType(sessionEventPivot.getEventType());
        return sessionEvent;
    }

    @Override
    public SessionNote pivotToSessionNote(SessionNotePivot sessionNotePivot) {
        SessionNote sessionNote = new SessionNote();
        sessionNote.setContent(sessionNotePivot.getContent());
        sessionNote.setKind(sessionNotePivot.getSessionNoteKind());
        sessionNote.setNoteOrder(sessionNotePivot.getNoteOrder().intValue());
        sessionNote.setCreatedBy(sessionNotePivot.getCreatedBy());
        sessionNote.setCreatedOn(sessionNotePivot.getCreatedOn());
        return sessionNote;
    }

    @Override
    public Execution pivotToExecution(ExecutionPivot executionPivot, PivotImportMetadata pivotImportMetadata) {
        Execution execution = this.getExecution(executionPivot);
        execution.setOrder(executionPivot.getExecutionOrder());
        execution.setDescription(executionPivot.getComment());
        execution.setCreatedBy(executionPivot.getCreatedBy());
        execution.setCreatedOn(executionPivot.getCreatedOn());
        Optional.ofNullable(this.getAvailableStatus(executionPivot.getStatus(), pivotImportMetadata)).ifPresent(arg_0 -> ((Execution)execution).setUnsafeExecutionStatus(arg_0));
        this.appendTestCaseDenormalized(execution, executionPivot.getTestCase());
        return execution;
    }

    private void appendTestCaseDenormalized(Execution execution, ExecutionPivot.TestCasePivotDenormalize testCasePivotDenormalize) {
        execution.setName(testCasePivotDenormalize.getName());
        ExecutionPivot.TestCasePivotDenormalize testCasePivotDenormalize2 = testCasePivotDenormalize;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)testCasePivotDenormalize2);
        Object[] objectArray = new Object[]{this, testCasePivotDenormalize2, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure7 executionWorkspaceConverterServiceImpl$AjcClosure7 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure7(objectArray);
        execution.setTcdescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112)));
        Optional.ofNullable(testCasePivotDenormalize.getDatasetLabel()).ifPresent(arg_0 -> ((Execution)execution).setUnsafeDatasetLabel(arg_0));
        Optional.ofNullable(testCasePivotDenormalize.getReference()).ifPresent(arg_0 -> ((Execution)execution).setReference(arg_0));
        ExecutionPivot.TestCasePivotDenormalize testCasePivotDenormalize3 = testCasePivotDenormalize;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)testCasePivotDenormalize3);
        Object[] objectArray2 = new Object[]{this, testCasePivotDenormalize3, joinPoint2};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure9 executionWorkspaceConverterServiceImpl$AjcClosure9 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure9(objectArray2);
        Optional.ofNullable((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure9.linkClosureAndJoinPoint(4112))).ifPresent(arg_0 -> ((Execution)execution).setPrerequisite(arg_0));
        Optional.ofNullable(testCasePivotDenormalize.getStatus()).ifPresent(arg_0 -> ((Execution)execution).setStatus(arg_0));
        Optional.ofNullable(testCasePivotDenormalize.getImportance()).ifPresent(arg_0 -> ((Execution)execution).setImportance(arg_0));
        Optional.ofNullable(testCasePivotDenormalize.getNature()).ifPresent(nature -> execution.setNature(new DenormalizedNature(nature.getLabel(), nature.getCode(), nature.getIconName())));
        Optional.ofNullable(testCasePivotDenormalize.getType()).ifPresent(type -> execution.setType(new DenormalizedType(type.getLabel(), type.getCode(), type.getIconName())));
    }

    private Execution getExecution(ExecutionPivot executionPivot) {
        return switch (executionPivot.getTestCase().getTestCaseKind()) {
            case TestCaseKind.STANDARD -> new Execution();
            case TestCaseKind.KEYWORD -> new KeywordExecution();
            case TestCaseKind.GHERKIN -> this.pivotToScriptedExecution(executionPivot);
            case TestCaseKind.EXPLORATORY -> this.pivotToExploratoryExecution(executionPivot);
            default -> throw new MatchException(null, null);
        };
    }

    private Execution pivotToScriptedExecution(ExecutionPivot executionPivot) {
        ScriptedExecution scriptedExecution = new ScriptedExecution();
        scriptedExecution.setScriptName(executionPivot.getTestCase().getName());
        return scriptedExecution;
    }

    private Execution pivotToExploratoryExecution(ExecutionPivot executionPivot) {
        ExploratoryExecution exploratoryExecution = new ExploratoryExecution();
        Optional.ofNullable(executionPivot.isReviewed()).ifPresent(arg_0 -> ((ExploratoryExecution)exploratoryExecution).setReviewed(arg_0));
        exploratoryExecution.setTaskDivision(executionPivot.getTaskDivision());
        return exploratoryExecution;
    }

    @Override
    public DenormalizedFieldValue pivotToDenormalizedFieldValue(DenormalizedValuePivot denormalizedValuePivot, Long holderId, DenormalizedFieldHolderType holderType, CustomFieldValue customFieldValue) {
        DenormalizedFieldValueDto denormalizedFieldValueDto = DenormalizedFieldValueDto.builder().withCustomFieldValue(customFieldValue).withCode(denormalizedValuePivot.getCode()).withDenormalizedFieldHolderId(holderId).withDenormalizedFieldHolderType(holderType).withInputType(denormalizedValuePivot.getInputType()).withLabel(denormalizedValuePivot.getLabel()).withPosition(denormalizedValuePivot.getPosition().intValue()).withValue(denormalizedValuePivot.getValue()).build();
        return this.getDenormalizedFieldValue(denormalizedFieldValueDto);
    }

    private DenormalizedFieldValue getDenormalizedFieldValue(DenormalizedFieldValueDto denormalizedFieldValueDto) {
        return switch (denormalizedFieldValueDto.inputType()) {
            case InputType.RICH_TEXT -> new DenormalizedRichValue(denormalizedFieldValueDto);
            case InputType.NUMERIC -> new DenormalizedNumericValue(denormalizedFieldValueDto);
            default -> new DenormalizedFieldValue(denormalizedFieldValueDto);
        };
    }

    @Override
    public ExecutionStep pivotToExecutionStep(ExecutionStepPivot executionStepPivot, PivotImportMetadata pivotImportMetadata) {
        ExecutionStep executionStep = new ExecutionStep();
        Optional.ofNullable(this.getAvailableStatus(executionStepPivot.getStatus(), pivotImportMetadata)).ifPresent(arg_0 -> ((ExecutionStep)executionStep).setExecutionStatus(arg_0));
        ExecutionStepPivot.StepPivotDenormalized stepPivotDenormalized = executionStepPivot.getStepPivotDenormalized();
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)stepPivotDenormalized);
        Object[] objectArray = new Object[]{this, stepPivotDenormalized, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure11 executionWorkspaceConverterServiceImpl$AjcClosure11 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure11(objectArray);
        Optional.ofNullable((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure11.linkClosureAndJoinPoint(4112))).ifPresent(arg_0 -> ((ExecutionStep)executionStep).setAction(arg_0));
        ExecutionStepPivot.StepPivotDenormalized stepPivotDenormalized2 = executionStepPivot.getStepPivotDenormalized();
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)stepPivotDenormalized2);
        Object[] objectArray2 = new Object[]{this, stepPivotDenormalized2, joinPoint2};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure13 executionWorkspaceConverterServiceImpl$AjcClosure13 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure13(objectArray2);
        Optional.ofNullable((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure13.linkClosureAndJoinPoint(4112))).ifPresent(arg_0 -> ((ExecutionStep)executionStep).setExpectedResult(arg_0));
        executionStep.setComment(executionStepPivot.getComment());
        executionStep.setCreatedBy(executionStepPivot.getCreatedBy());
        executionStep.setCreatedOn(executionStepPivot.getCreatedOn());
        return executionStep;
    }

    @Override
    public Issue pivotToIssue(IssuePivot issuePivot, BugTracker bugTracker) {
        Issue issue = new Issue();
        issue.setBugtracker(bugTracker);
        issue.setRemoteIssueId(issuePivot.getRemoteIssueId());
        issue.setAdditionalData(issuePivot.getAdditionalData());
        return issue;
    }

    @Override
    public Sprint pivotToSprint(SprintPivot sprintPivot) {
        Sprint sprint = new Sprint();
        sprint.setName(sprintPivot.getName());
        SprintPivot sprintPivot2 = sprintPivot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)sprintPivot2);
        Object[] objectArray = new Object[]{this, sprintPivot2, joinPoint};
        ExecutionWorkspaceConverterServiceImpl$AjcClosure15 executionWorkspaceConverterServiceImpl$AjcClosure15 = new ExecutionWorkspaceConverterServiceImpl$AjcClosure15(objectArray);
        sprint.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspaceConverterServiceImpl$AjcClosure15.linkClosureAndJoinPoint(4112)));
        sprint.setReference(sprintPivot.getReference());
        sprint.setStatus(this.getSprintStatus(sprintPivot));
        sprint.setStartDate(sprintPivot.getStartDate());
        sprint.setEndDate(sprintPivot.getEndDate());
        sprint.setCreatedBy(sprintPivot.getCreatedBy());
        sprint.setCreatedOn(sprintPivot.getCreatedOn());
        return sprint;
    }

    private SprintStatus getSprintStatus(SprintPivot sprintPivot) {
        return switch (sprintPivot.getStatus()) {
            case SprintStatus.FUTURE -> SprintStatus.UPCOMING;
            case SprintStatus.ACTIVE -> SprintStatus.OPEN;
            default -> sprintPivot.getStatus();
        };
    }

    @Override
    public SprintReqVersion pivotToSprintReqVersion(Sprint sprint, SprintReqVersionPivot sprintReqVersionPivot) {
        SprintReqVersion sprintReqVersion = new SprintReqVersion(sprint);
        sprintReqVersion.setName(sprintReqVersionPivot.getName());
        sprintReqVersion.setDescription(sprintReqVersionPivot.getDescription());
        sprintReqVersion.setReference(sprintReqVersionPivot.getReference());
        sprintReqVersion.setStatus(sprintReqVersionPivot.getStatus());
        sprintReqVersion.setCriticality(sprintReqVersionPivot.getCriticality());
        sprintReqVersion.setCategory(sprintReqVersionPivot.getCategory());
        sprintReqVersion.setMode(sprintReqVersionPivot.getMode());
        Optional.ofNullable(sprintReqVersionPivot.getMode()).ifPresent(arg_0 -> ((SprintReqVersion)sprintReqVersion).setMode(arg_0));
        Optional.ofNullable(sprintReqVersionPivot.getValidationStatus()).ifPresent(arg_0 -> ((SprintReqVersion)sprintReqVersion).setValidationStatus(arg_0));
        sprintReqVersion.setCreatedBy(sprintReqVersionPivot.getCreatedBy());
        sprintReqVersion.setCreatedOn(sprintReqVersionPivot.getCreatedOn());
        return sprintReqVersion;
    }

    @Override
    public ExecutionStatus getAvailableStatus(ExecutionStatus executionStatus, PivotImportMetadata pivotImportMetadata) {
        if (executionStatus == null) {
            return null;
        }
        return pivotImportMetadata.getPivotOptions().getExecutionStatusConversion().getOrDefault(executionStatus, executionStatus);
    }

    @Override
    public CampaignPivot campaignRecordToCampaignPivot(Record record) {
        CampaignPivot campaignPivot = new CampaignPivot();
        campaignPivot.setPivotId((Long)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID));
        campaignPivot.setName((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME));
        campaignPivot.setDescription((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION));
        campaignPivot.setReference((String)record.get((Field)Tables.CAMPAIGN.REFERENCE));
        campaignPivot.setStatus(CampaignStatus.valueOf((String)((String)record.get((Field)Tables.CAMPAIGN.CAMPAIGN_STATUS))));
        campaignPivot.setActualStartDateAuto((Boolean)record.get((Field)Tables.CAMPAIGN.ACTUAL_START_AUTO));
        campaignPivot.setActualEndDateAuto((Boolean)record.get((Field)Tables.CAMPAIGN.ACTUAL_END_AUTO));
        campaignPivot.setActualStartDate((Date)record.get((Field)Tables.CAMPAIGN.ACTUAL_START_DATE));
        campaignPivot.setActualEndDate((Date)record.get((Field)Tables.CAMPAIGN.ACTUAL_END_DATE));
        campaignPivot.setScheduledStartDate((Date)record.get((Field)Tables.CAMPAIGN.SCHEDULED_START_DATE));
        campaignPivot.setScheduledEndDate((Date)record.get((Field)Tables.CAMPAIGN.SCHEDULED_END_DATE));
        Long parentId = (Long)record.get((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID);
        if (parentId != null) {
            campaignPivot.setParentType(EntityType.CAMPAIGN_FOLDER);
            campaignPivot.setParentId(parentId, "F");
        } else {
            campaignPivot.setParentType(EntityType.CAMPAIGN_LIBRARY);
        }
        campaignPivot.setCreatedBy((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_BY));
        campaignPivot.setCreatedOn((Date)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_ON));
        campaignPivot.setLastModifiedBy((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_BY));
        campaignPivot.setLastModifiedOn((Date)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_ON));
        return campaignPivot;
    }

    @Override
    public IterationPivot iterationRecordToIterationPivot(Record record) {
        IterationPivot iterationPivot = new IterationPivot();
        iterationPivot.setPivotId((Long)record.get((Field)Tables.ITERATION.ITERATION_ID));
        iterationPivot.setName((String)record.get((Field)Tables.ITERATION.NAME));
        iterationPivot.setDescription((String)record.get((Field)Tables.ITERATION.DESCRIPTION));
        iterationPivot.setReference((String)record.get((Field)Tables.ITERATION.REFERENCE));
        iterationPivot.setStatus(IterationStatus.valueOf((String)((String)record.get((Field)Tables.ITERATION.ITERATION_STATUS))));
        iterationPivot.setActualStartDateAuto((Boolean)record.get((Field)Tables.ITERATION.ACTUAL_START_AUTO));
        iterationPivot.setActualEndDateAuto((Boolean)record.get((Field)Tables.ITERATION.ACTUAL_END_AUTO));
        iterationPivot.setActualStartDate((Date)record.get((Field)Tables.ITERATION.ACTUAL_START_DATE));
        iterationPivot.setActualEndDate((Date)record.get((Field)Tables.ITERATION.ACTUAL_END_DATE));
        iterationPivot.setScheduledStartDate((Date)record.get((Field)Tables.ITERATION.SCHEDULED_START_DATE));
        iterationPivot.setScheduledEndDate((Date)record.get((Field)Tables.ITERATION.SCHEDULED_END_DATE));
        iterationPivot.setParentType(EntityType.CAMPAIGN);
        iterationPivot.setParentId((Long)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID), "CP");
        iterationPivot.setCreatedBy((String)record.get((Field)Tables.ITERATION.CREATED_BY));
        iterationPivot.setCreatedOn((Date)record.get((Field)Tables.ITERATION.CREATED_ON));
        iterationPivot.setLastModifiedBy((String)record.get((Field)Tables.ITERATION.LAST_MODIFIED_BY));
        iterationPivot.setLastModifiedOn((Date)record.get((Field)Tables.ITERATION.LAST_MODIFIED_ON));
        return iterationPivot;
    }

    @Override
    public TestSuitePivot testSuiteRecordToTestSuitePivot(Record record) {
        TestSuitePivot testSuitePivot = new TestSuitePivot();
        testSuitePivot.setPivotId((Long)record.get((Field)Tables.TEST_SUITE.ID));
        testSuitePivot.setName((String)record.get((Field)Tables.TEST_SUITE.NAME));
        testSuitePivot.setDescription((String)record.get((Field)Tables.TEST_SUITE.DESCRIPTION));
        testSuitePivot.setStatus(ExecutionStatus.valueOf((String)((String)record.get((Field)Tables.TEST_SUITE.EXECUTION_STATUS))));
        testSuitePivot.setParentType(EntityType.ITERATION);
        testSuitePivot.setParentId((Long)record.get((Field)Tables.ITERATION_TEST_SUITE.ITERATION_ID), "IT");
        testSuitePivot.setCreatedBy((String)record.get((Field)Tables.TEST_SUITE.CREATED_BY));
        testSuitePivot.setCreatedOn((Date)record.get((Field)Tables.TEST_SUITE.CREATED_ON));
        testSuitePivot.setLastModifiedBy((String)record.get((Field)Tables.TEST_SUITE.LAST_MODIFIED_BY));
        testSuitePivot.setLastModifiedOn((Date)record.get((Field)Tables.TEST_SUITE.LAST_MODIFIED_ON));
        return testSuitePivot;
    }

    @Override
    public SprintPivot sprintRecordToSprintPivot(Record record) {
        SprintPivot sprintPivot = new SprintPivot();
        sprintPivot.setPivotId((Long)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID));
        sprintPivot.setName((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME));
        sprintPivot.setDescription((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION));
        sprintPivot.setReference((String)record.get((Field)Tables.SPRINT.REFERENCE));
        sprintPivot.setStatus(SprintStatus.valueOf((String)((String)record.get((Field)Tables.SPRINT.STATUS))));
        sprintPivot.setStartDate((Date)record.get((Field)Tables.SPRINT.START_DATE));
        sprintPivot.setEndDate((Date)record.get((Field)Tables.SPRINT.END_DATE));
        EntityType parentType = EntityType.valueOf((String)((String)record.get(SprintPivotDao.PARENT_TYPE_FIELD, String.class)));
        sprintPivot.setParentType(parentType);
        if (!EntityType.CAMPAIGN_LIBRARY.equals((Object)parentType)) {
            sprintPivot.setParentId((Long)record.get((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID), "F");
        }
        sprintPivot.setCreatedBy((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_BY));
        sprintPivot.setCreatedOn((Date)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CREATED_ON));
        sprintPivot.setLastModifiedBy((String)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_BY));
        sprintPivot.setLastModifiedOn((Date)record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_ON));
        return sprintPivot;
    }

    @Override
    public SprintReqVersionPivot sprintRecordToSprintReqVersionPivot(Record record) {
        SprintReqVersionPivot sprintReqVersionPivot = new SprintReqVersionPivot();
        sprintReqVersionPivot.setPivotId((Long)record.get((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID));
        sprintReqVersionPivot.setReference((String)record.get((Field)Tables.SPRINT_REQ_VERSION.REFERENCE));
        sprintReqVersionPivot.setName((String)record.get((Field)Tables.SPRINT_REQ_VERSION.NAME));
        sprintReqVersionPivot.setDescription((String)record.get((Field)Tables.SPRINT_REQ_VERSION.DESCRIPTION));
        sprintReqVersionPivot.setStatus((String)record.get((Field)Tables.SPRINT_REQ_VERSION.STATUS));
        sprintReqVersionPivot.setCriticality((String)record.get((Field)Tables.SPRINT_REQ_VERSION.CRITICALITY));
        sprintReqVersionPivot.setCategory((String)record.get((Field)Tables.SPRINT_REQ_VERSION.CATEGORY));
        sprintReqVersionPivot.setRequirementVersionId((Long)record.get((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID));
        Optional.ofNullable((String)record.get((Field)Tables.SPRINT_REQ_VERSION.MODE)).ifPresent(mode -> sprintReqVersionPivot.setMode(ManagementMode.valueOf((String)mode)));
        Optional.ofNullable((String)record.get((Field)Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS)).ifPresent(status -> sprintReqVersionPivot.setValidationStatus(SprintReqVersionValidationStatus.valueOf((String)status)));
        sprintReqVersionPivot.setCreatedBy((String)record.get((Field)Tables.SPRINT_REQ_VERSION.CREATED_BY));
        sprintReqVersionPivot.setCreatedOn((Date)record.get((Field)Tables.SPRINT_REQ_VERSION.CREATED_ON));
        sprintReqVersionPivot.setLastModifiedBy((String)record.get((Field)Tables.SPRINT_REQ_VERSION.LAST_MODIFIED_BY));
        sprintReqVersionPivot.setLastModifiedOn((Date)record.get((Field)Tables.SPRINT_REQ_VERSION.LAST_MODIFIED_ON));
        return sprintReqVersionPivot;
    }

    @Override
    public TestPlanItemPivot campaignTpiRecordToTpiPivot(Record record) {
        return this.getTestPlanItemPivot((Long)record.get((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID), (Long)record.get((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID), (Long)record.get((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.DATASET_ID));
    }

    @Override
    public TestPlanItemPivot tpiRecordToTpiPivot(Record record) {
        TestPlanItemPivot testPlanItemPivot = this.getTpiPivotFromTpiRecord(record);
        if (record.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID) != null) {
            testPlanItemPivot.setSessionOverview(this.testPlanItemRecordToSessionOverviewPivot(record));
        }
        return testPlanItemPivot;
    }

    private TestPlanItemPivot getTpiPivotFromTpiRecord(Record record) {
        TestPlanItemPivot testPlanItemPivot = this.getTestPlanItemPivot((Long)record.get((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID), (Long)record.get((Field)Tables.TEST_PLAN_ITEM.TCLN_ID), (Long)record.get((Field)Tables.TEST_PLAN_ITEM.DATASET_ID));
        testPlanItemPivot.setTestCaseLabel((String)record.get((Field)Tables.TEST_PLAN_ITEM.LABEL));
        Optional.ofNullable((String)record.get((Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS)).ifPresent(status -> testPlanItemPivot.setExecutionStatus(ExecutionStatus.valueOf((String)status)));
        testPlanItemPivot.setCreatedBy((String)record.get((Field)Tables.TEST_PLAN_ITEM.CREATED_BY));
        testPlanItemPivot.setCreatedOn((Date)record.get((Field)Tables.TEST_PLAN_ITEM.CREATED_ON));
        testPlanItemPivot.setLastModifiedBy((String)record.get((Field)Tables.TEST_PLAN_ITEM.LAST_MODIFIED_BY));
        testPlanItemPivot.setLastModifiedOn((Date)record.get((Field)Tables.TEST_PLAN_ITEM.LAST_MODIFIED_ON));
        testPlanItemPivot.setLastExecutedBy((String)record.get((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY));
        testPlanItemPivot.setLastExecutedOn((Date)record.get((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON));
        return testPlanItemPivot;
    }

    private TestPlanItemPivot getTestPlanItemPivot(Long testPlanItemId, Long tclnId, Long datasetId) {
        TestPlanItemPivot testPlanItemPivot = new TestPlanItemPivot();
        testPlanItemPivot.setPivotId(testPlanItemId);
        if (Objects.nonNull(tclnId)) {
            testPlanItemPivot.setTestCaseId(tclnId);
            if (Objects.nonNull(datasetId)) {
                testPlanItemPivot.setDatasetId(datasetId);
            }
        }
        return testPlanItemPivot;
    }

    private SessionOverviewPivot testPlanItemRecordToSessionOverviewPivot(Record record) {
        SessionOverviewPivot sessionOverviewPivot = new SessionOverviewPivot();
        sessionOverviewPivot.setPivotId((Long)record.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID));
        sessionOverviewPivot.setName((String)record.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.NAME));
        sessionOverviewPivot.setReference((String)record.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.REFERENCE));
        sessionOverviewPivot.setCharter((String)record.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.CHARTER));
        sessionOverviewPivot.setComment((String)record.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.COMMENTS));
        sessionOverviewPivot.setSessionDuration((Integer)record.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.SESSION_DURATION));
        sessionOverviewPivot.setDueDate((Date)record.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.DUE_DATE));
        sessionOverviewPivot.setStatus(ExploratorySessionOverviewStatus.valueOf((String)((String)record.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.SESSION_STATUS))));
        return sessionOverviewPivot;
    }

    @Override
    public ExecutionPivot executionRecordToExecutionPivot(Record record) {
        ExecutionPivot executionPivot = new ExecutionPivot();
        executionPivot.setPivotId((Long)record.get((Field)Tables.EXECUTION.EXECUTION_ID));
        executionPivot.setComment((String)record.get((Field)Tables.EXECUTION.DESCRIPTION));
        executionPivot.setExecutionOrder((Integer)record.get((Field)Tables.EXECUTION.EXECUTION_ORDER));
        executionPivot.setStatus(ExecutionStatus.valueOf((String)((String)record.get((Field)Tables.EXECUTION.EXECUTION_STATUS))));
        executionPivot.setTestPlanItemId((Long)record.get((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID));
        executionPivot.setTestCase(this.executionRecordToTestCasePivotDenormalize(record));
        executionPivot.setReviewed((Boolean)record.get((Field)Tables.EXPLORATORY_EXECUTION.REVIEWED));
        executionPivot.setTaskDivision((String)record.get((Field)Tables.EXPLORATORY_EXECUTION.TASK_DIVISION));
        executionPivot.setCreatedBy((String)record.get((Field)Tables.EXECUTION.CREATED_BY));
        executionPivot.setCreatedOn((Date)record.get((Field)Tables.EXECUTION.CREATED_ON));
        executionPivot.setLastModifiedBy((String)record.get((Field)Tables.EXECUTION.LAST_MODIFIED_BY));
        executionPivot.setLastModifiedOn((Date)record.get((Field)Tables.EXECUTION.LAST_MODIFIED_ON));
        executionPivot.setLastExecutedBy((String)record.get((Field)Tables.EXECUTION.LAST_EXECUTED_BY));
        executionPivot.setLastExecutedOn((Date)record.get((Field)Tables.EXECUTION.LAST_EXECUTED_ON));
        return executionPivot;
    }

    private ExecutionPivot.TestCasePivotDenormalize executionRecordToTestCasePivotDenormalize(Record record) {
        ExecutionPivot.TestCasePivotDenormalize testCasePivotDenormalize = new ExecutionPivot.TestCasePivotDenormalize();
        testCasePivotDenormalize.setPivotId((Long)record.get((Field)Tables.TEST_PLAN_ITEM.TCLN_ID));
        testCasePivotDenormalize.setTestCaseKind(TestCaseKind.valueOf((String)((String)record.get(TestCasePivotDao.TC_KIND))));
        testCasePivotDenormalize.setReference((String)record.get((Field)Tables.EXECUTION.REFERENCE));
        testCasePivotDenormalize.setName((String)record.get((Field)Tables.EXECUTION.NAME));
        testCasePivotDenormalize.setDescription((String)record.get((Field)Tables.EXECUTION.TC_DESCRIPTION));
        testCasePivotDenormalize.setStatus(TestCaseStatus.valueOf((String)((String)record.get((Field)Tables.EXECUTION.TC_STATUS))));
        testCasePivotDenormalize.setImportance(TestCaseImportance.valueOf((String)((String)record.get((Field)Tables.EXECUTION.IMPORTANCE))));
        testCasePivotDenormalize.setDatasetLabel((String)record.get((Field)Tables.EXECUTION.DATASET_LABEL));
        testCasePivotDenormalize.setPrerequisite((String)record.get((Field)Tables.EXECUTION.PREREQUISITE));
        testCasePivotDenormalize.setNature(this.executionRecordToInfoListItemPivotDenormalize(record, (Field<String>)Tables.EXECUTION.TC_NAT_CODE, (Field<String>)Tables.EXECUTION.TC_NAT_LABEL, (Field<String>)Tables.EXECUTION.TC_NAT_ICON_NAME));
        testCasePivotDenormalize.setType(this.executionRecordToInfoListItemPivotDenormalize(record, (Field<String>)Tables.EXECUTION.TC_TYP_CODE, (Field<String>)Tables.EXECUTION.TC_TYP_LABEL, (Field<String>)Tables.EXECUTION.TC_TYP_ICON_NAME));
        return testCasePivotDenormalize;
    }

    private InfoListItemPivot executionRecordToInfoListItemPivotDenormalize(Record record, Field<String> codeField, Field<String> labelField, Field<String> iconNameField) {
        InfoListItemPivot infoListItemPivot = new InfoListItemPivot();
        infoListItemPivot.setCode((String)record.get(codeField));
        infoListItemPivot.setLabel((String)record.get(labelField));
        infoListItemPivot.setIconName((String)record.get(iconNameField));
        return infoListItemPivot;
    }

    @Override
    public ExecutionStepPivot executionStepRecordToExecutionStepPivot(Record record) {
        ExecutionStepPivot executionStepPivot = new ExecutionStepPivot();
        executionStepPivot.setPivotId((Long)record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID));
        executionStepPivot.setComment((String)record.get((Field)Tables.EXECUTION_STEP.COMMENT));
        executionStepPivot.setStatus(ExecutionStatus.valueOf((String)((String)record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STATUS))));
        executionStepPivot.setLastExecutedOn((Date)record.get((Field)Tables.EXECUTION_STEP.LAST_EXECUTED_ON));
        executionStepPivot.setLastExecutedBy((String)record.get((Field)Tables.EXECUTION_STEP.LAST_EXECUTED_BY));
        executionStepPivot.setCreatedBy((String)record.get((Field)Tables.EXECUTION_STEP.CREATED_BY));
        executionStepPivot.setCreatedOn((Date)record.get((Field)Tables.EXECUTION_STEP.CREATED_ON));
        executionStepPivot.setLastModifiedBy((String)record.get((Field)Tables.EXECUTION_STEP.LAST_MODIFIED_BY));
        executionStepPivot.setLastModifiedOn((Date)record.get((Field)Tables.EXECUTION_STEP.LAST_MODIFIED_ON));
        Long stepId = (Long)record.get((Field)Tables.EXECUTION_STEP.TEST_STEP_ID);
        if (Objects.nonNull(stepId)) {
            TestCaseKind testCaseKind = TestCaseKind.valueOf((String)((String)record.get(TestCasePivotDao.TC_KIND)));
            switch (testCaseKind) {
                case STANDARD: {
                    executionStepPivot.setTestStepId(stepId, "AS");
                    break;
                }
                case KEYWORD: {
                    executionStepPivot.setTestStepId(stepId, "KW");
                    break;
                }
            }
        }
        executionStepPivot.setStepPivotDenormalized(this.executionStepRecordToStepPivotDenormalized(record));
        return executionStepPivot;
    }

    private ExecutionStepPivot.StepPivotDenormalized executionStepRecordToStepPivotDenormalized(Record record) {
        ExecutionStepPivot.StepPivotDenormalized stepPivotDenormalized = new ExecutionStepPivot.StepPivotDenormalized();
        stepPivotDenormalized.setAction((String)record.get((Field)Tables.EXECUTION_STEP.ACTION));
        stepPivotDenormalized.setExpectedResult((String)record.get((Field)Tables.EXECUTION_STEP.EXPECTED_RESULT));
        return stepPivotDenormalized;
    }

    @Override
    public SessionEventPivot sessionEventRecordToSessionEventPivot(Record record) {
        SessionEventPivot sessionEventPivot = new SessionEventPivot();
        sessionEventPivot.setPivotId((Long)record.get((Field)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_ID));
        sessionEventPivot.setAuthor((String)record.get((Field)Tables.EXPLORATORY_EXECUTION_EVENT.AUTHOR));
        sessionEventPivot.setEventDate((Date)record.get((Field)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_DATE));
        sessionEventPivot.setEventType(ExploratoryExecutionEventType.valueOf((String)((String)record.get((Field)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_TYPE))));
        return sessionEventPivot;
    }

    @Override
    public SessionNotePivot sessionNoteRecordToSessionNotePivot(Record record) {
        SessionNotePivot sessionNotePivot = new SessionNotePivot();
        sessionNotePivot.setPivotId((Long)record.get((Field)Tables.SESSION_NOTE.NOTE_ID));
        sessionNotePivot.setContent((String)record.get((Field)Tables.SESSION_NOTE.CONTENT));
        sessionNotePivot.setSessionNoteKind(SessionNoteKind.valueOf((String)((String)record.get((Field)Tables.SESSION_NOTE.KIND))));
        sessionNotePivot.setNoteOrder((Integer)record.get((Field)Tables.SESSION_NOTE.NOTE_ORDER));
        sessionNotePivot.setCreatedBy((String)record.get((Field)Tables.SESSION_NOTE.CREATED_BY));
        sessionNotePivot.setCreatedOn((Date)record.get((Field)Tables.SESSION_NOTE.CREATED_ON));
        sessionNotePivot.setLastModifiedBy((String)record.get((Field)Tables.SESSION_NOTE.LAST_MODIFIED_BY));
        sessionNotePivot.setLastModifiedOn((Date)record.get((Field)Tables.SESSION_NOTE.LAST_MODIFIED_ON));
        return sessionNotePivot;
    }

    @Override
    public DenormalizedValuePivot recordToDenormalizedValuePivot(Record record) {
        DenormalizedValuePivot denormalizedValuePivot = new DenormalizedValuePivot();
        denormalizedValuePivot.setPivotId((Long)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.DFV_ID));
        denormalizedValuePivot.setCustomFieldId((Long)record.get((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID));
        denormalizedValuePivot.setHolderId((Long)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID));
        denormalizedValuePivot.setHolderType(DenormalizedFieldHolderType.valueOf((String)((String)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE))));
        denormalizedValuePivot.setInputType(InputType.valueOf((String)((String)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.INPUT_TYPE))));
        denormalizedValuePivot.setLabel((String)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.LABEL));
        denormalizedValuePivot.setCode((String)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.CODE));
        denormalizedValuePivot.setValue((String)record.get(ExecutionPivotDao.DENORMALIZED_VALUE));
        denormalizedValuePivot.setPosition((Integer)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.POSITION));
        return denormalizedValuePivot;
    }

    @Override
    public IssuePivot issueRecordToIssuePivot(Record record) {
        IssuePivot issuePivot = new IssuePivot();
        issuePivot.setPivotId((Long)record.get((Field)Tables.ISSUE.ISSUE_ID));
        issuePivot.setHolderId((Long)record.get(TestCasePivotDao.HOLDER_ID));
        issuePivot.setHolderType(EntityType.valueOf((String)((String)record.get(TestCasePivotDao.HOLDER_TYPE))));
        issuePivot.setRemoteIssueId((String)record.get((Field)Tables.ISSUE.REMOTE_ISSUE_ID));
        issuePivot.setBugtrackerPivotId((Long)record.get((Field)Tables.ISSUE.BUGTRACKER_ID));
        issuePivot.setAdditionalData((String)record.get((Field)Tables.ISSUE.ADDITIONAL_DATA));
        return issuePivot;
    }

    static {
        ExecutionWorkspaceConverterServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getDescription_aroundBody0(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, CampaignPivot campaignPivot, JoinPoint joinPoint) {
        return campaignPivot.getDescription();
    }

    static final /* synthetic */ String getDescription_aroundBody2(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, IterationPivot iterationPivot, JoinPoint joinPoint) {
        return iterationPivot.getDescription();
    }

    static final /* synthetic */ String getDescription_aroundBody4(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, TestSuitePivot testSuitePivot, JoinPoint joinPoint) {
        return testSuitePivot.getDescription();
    }

    static final /* synthetic */ String getDescription_aroundBody6(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, ExecutionPivot.TestCasePivotDenormalize testCasePivotDenormalize, JoinPoint joinPoint) {
        return testCasePivotDenormalize.getDescription();
    }

    static final /* synthetic */ String getPrerequisite_aroundBody8(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, ExecutionPivot.TestCasePivotDenormalize testCasePivotDenormalize, JoinPoint joinPoint) {
        return testCasePivotDenormalize.getPrerequisite();
    }

    static final /* synthetic */ String getAction_aroundBody10(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, ExecutionStepPivot.StepPivotDenormalized stepPivotDenormalized, JoinPoint joinPoint) {
        return stepPivotDenormalized.getAction();
    }

    static final /* synthetic */ String getExpectedResult_aroundBody12(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, ExecutionStepPivot.StepPivotDenormalized stepPivotDenormalized, JoinPoint joinPoint) {
        return stepPivotDenormalized.getExpectedResult();
    }

    static final /* synthetic */ String getDescription_aroundBody14(ExecutionWorkspaceConverterServiceImpl executionWorkspaceConverterServiceImpl, SprintPivot sprintPivot, JoinPoint joinPoint) {
        return sprintPivot.getDescription();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExecutionWorkspaceConverterServiceImpl.java", ExecutionWorkspaceConverterServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.CampaignPivot", "", "", "", "java.lang.String"), 115);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IterationPivot", "", "", "", "java.lang.String"), 135);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestSuitePivot", "", "", "", "java.lang.String"), 156);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionPivot$TestCasePivotDenormalize", "", "", "", "java.lang.String"), 218);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getPrerequisite", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionPivot$TestCasePivotDenormalize", "", "", "", "java.lang.String"), 222);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getAction", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionStepPivot$StepPivotDenormalized", "", "", "", "java.lang.String"), 297);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getExpectedResult", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionStepPivot$StepPivotDenormalized", "", "", "", "java.lang.String"), 299);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintPivot", "", "", "", "java.lang.String"), 320);
    }
}

