/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.AiServices;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.promptset.Prompt;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerNoCredentialsException;
import org.squashtest.tm.service.artificialintelligence.AiChatClientProvider;
import org.squashtest.tm.service.internal.artificialintelligence.AiAssistant;
import org.squashtest.tm.service.internal.artificialintelligence.AiChatClient;
import org.squashtest.tm.service.internal.artificialintelligence.server.ChatModelProviderHelper;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;
import org.squashtest.tm.service.internal.repository.PromptDao;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Service
@Transactional
public class AiChatClientProviderImpl
implements AiChatClientProvider {
    private final StoredCredentialsManager credentialsManager;
    private final PromptDao promptDao;

    public AiChatClientProviderImpl(StoredCredentialsManager credentialsManager, PromptDao promptDao) {
        this.credentialsManager = credentialsManager;
        this.promptDao = promptDao;
    }

    @Override
    public AiChatClient createAiChatClient(AiServerDto aiServerDto, String systemPrompt) {
        return this.doCreateAiChatClient(aiServerDto, systemPrompt);
    }

    @Override
    public AiChatClient createAiChatClient(AiServerDto aiServerDto, Long promptId) {
        Prompt prompt = (Prompt)this.promptDao.findById(promptId).orElseThrow(() -> new IllegalArgumentException("Prompt not found"));
        return this.doCreateAiChatClient(aiServerDto, prompt.getSystemPromptTemplate());
    }

    private AiChatClient doCreateAiChatClient(AiServerDto aiServerDto, String prompt) {
        TokenAuthCredentials credentials = (TokenAuthCredentials)this.credentialsManager.unsecuredFindAppLevelCredentials(aiServerDto.getId());
        if (credentials == null) {
            throw new AiServerNoCredentialsException(aiServerDto.getName());
        }
        ChatModel model = ChatModelProviderHelper.buildChatModelForAiServer(aiServerDto, credentials);
        AiAssistant aiAssistant = (AiAssistant)AiServices.builder(AiAssistant.class).systemMessageProvider(chatMemoryId -> prompt).chatModel(model).build();
        return new AiChatClient(aiAssistant);
    }
}

