/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.archive;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.squashtest.tm.exception.ZipCorruptedException;
import org.squashtest.tm.service.internal.archive.ArchiveReader;
import org.squashtest.tm.service.internal.archive.Entry;

public class ZipReader
implements ArchiveReader {
    private ZipArchiveInputStream zipStream;
    private String encoding = "UTF8";
    private ZipReaderEntry currentEntry;
    private ZipReaderEntry nextEntry;

    public ZipReader(InputStream stream, String encoding) {
        this.doSetEncoding(encoding);
        this.doSetStream(stream);
    }

    @Override
    public void setEncoding(String encoding) {
        this.doSetEncoding(encoding);
    }

    private void doSetEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setStream(InputStream stream) {
        this.doSetStream(stream);
    }

    private void doSetStream(InputStream stream) {
        this.zipStream = new ZipArchiveInputStream(stream, this.encoding, false);
    }

    @Override
    public void close() {
        try {
            this.zipStream.close();
        }
        catch (IOException ex) {
            throw new ZipCorruptedException((Throwable)ex);
        }
    }

    @Override
    public boolean hasNext() {
        this.readNext();
        return this.nextEntry != null;
    }

    @Override
    public Entry next() {
        if (this.nextEntry == null) {
            this.readNext();
        }
        this.currentEntry = this.nextEntry;
        this.nextEntry = null;
        return this.currentEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void readNext() {
        try {
            ZipArchiveEntry entry = this.zipStream.getNextEntry();
            this.nextEntry = entry != null ? new ZipReaderEntry((InputStream)this.zipStream, (ArchiveEntry)entry) : null;
        }
        catch (IOException ex) {
            throw new ZipCorruptedException((Throwable)ex);
        }
    }

    private static class UnclosableStream
    extends InputStream {
        private InputStream innerStream;

        public UnclosableStream(InputStream stream) {
            this.innerStream = stream;
        }

        @Override
        public int read() throws IOException {
            return this.innerStream.read();
        }

        @Override
        public void close() {
        }
    }

    private static final class ZipReaderEntry
    implements Entry {
        private InputStream zipStream;
        private String name;
        private boolean isDirectory;

        private ZipReaderEntry(InputStream stream, String name, boolean isDirectory) {
            this.zipStream = stream;
            this.name = this.stripSuffix(name);
            this.isDirectory = isDirectory;
        }

        private ZipReaderEntry(InputStream stream, ArchiveEntry entry) {
            this(stream, "/" + entry.getName(), entry.isDirectory());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.getName().replaceAll(".*/", "");
        }

        @Override
        public Entry getParent() {
            return new ZipReaderEntry(null, this.getParentString(), true);
        }

        private String getParentString() {
            String res = this.getName().replaceAll("/[^/]*$", "");
            if (res != null && res.isEmpty()) {
                res = "/";
            }
            return res;
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        @Override
        public boolean isFile() {
            return !this.isDirectory;
        }

        @Override
        public InputStream getStream() {
            if (this.isFile()) {
                return new UnclosableStream(this.zipStream);
            }
            return null;
        }

        private String stripSuffix(String original) {
            String res;
            String string = res = original.charAt(original.length() - 1) == '/' ? original.substring(0, original.length() - 1) : original;
            if (res.isEmpty()) {
                res = "/";
            }
            return res;
        }
    }
}

