/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.scmserver;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.exception.scmserver.ScmMissingFolderException;

public final class ScmRepositoryManifest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmRepositoryManifest.class);
    private static final String MISSING_WORKING_FOLDER_LOG_ERROR_MESSAGE = "Attempted to write files in the working folder of repository {} at path {} but could not find it. \nPlease check that the repository is well initialized on local server.";
    private ScmRepository scm;
    private boolean useCache = true;
    private Set<String> pathCache = new HashSet<String>();
    private final Path workFolderPath;

    public ScmRepositoryManifest(ScmRepository scm) {
        this(scm, true);
    }

    ScmRepositoryManifest(ScmRepository scm, boolean useCache) {
        this.scm = scm;
        this.workFolderPath = this.initWorkingFolderPath();
        this.useCache = useCache;
        if (useCache) {
            this.initCache();
        }
    }

    private final void initCache() {
        try {
            this.pathCache = this.scm.listWorkingFolderContent().stream().map(this::getRelativePath).collect(Collectors.toSet());
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot list content of scm '" + this.scm.getName() + "'", ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error(MISSING_WORKING_FOLDER_LOG_ERROR_MESSAGE, new Object[]{this.scm.getName(), this.scm.getWorkingFolder().toString(), ex});
            throw new ScmMissingFolderException((Throwable)ex, this.scm.getName());
        }
    }

    private final Path initWorkingFolderPath() {
        String baseDir = this.scm.getRepositoryPath();
        if (baseDir == null) {
            throw new IllegalArgumentException("the repository '" + this.scm.getName() + "' has no base directory defined !");
        }
        String folderPath = (String)StringUtils.defaultIfBlank((CharSequence)this.scm.getWorkingFolderPath(), (CharSequence)"");
        return Paths.get(baseDir, folderPath);
    }

    public Optional<File> locateTest(String pattern, Long tcId) {
        Collection<File> files = this.useCache ? this.searchInCache(pattern) : this.searchOnDrive(pattern);
        if (files.size() > 1) {
            LOGGER.warn("found two files more more that are possible candidates for test '{}'. This is an unexpected situation. The commit routine will proceed with the first file in lexicographic order.", new Object[]{tcId});
        }
        return files.stream().sorted(Comparator.comparing(File::getName)).findFirst();
    }

    public Stream<String> streamTestsRelativePath() throws IOException {
        Stream<String> stream = this.useCache ? this.pathCache.stream() : this.scm.listWorkingFolderContent().stream().map(this::getRelativePath);
        return stream;
    }

    public String getRelativePath(File file) {
        Path testPath = Paths.get(file.getAbsolutePath(), new String[0]).normalize();
        Path relative = this.workFolderPath.toAbsolutePath().relativize(testPath);
        return FilenameUtils.normalizeNoEndSeparator((String)relative.toString(), (boolean)true);
    }

    private Collection<File> searchOnDrive(String regex) {
        String pattern = "^" + regex + "$";
        File workingFolder = this.scm.getWorkingFolder();
        return FileUtils.listFiles((File)workingFolder, (IOFileFilter)new FilenamePatternFilter(pattern), (IOFileFilter)FileFilterUtils.trueFileFilter());
    }

    private Collection<File> searchInCache(String regex) {
        Pattern pattern = Pattern.compile("^" + regex + "$");
        return this.pathCache.stream().filter(entry -> {
            String fileName = new File((String)entry).getName();
            return pattern.matcher(fileName).find();
        }).map(relPath -> new File(this.scm.getWorkingFolder(), (String)relPath)).toList();
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public ScmRepository getScm() {
        return this.scm;
    }

    private static class FilenamePatternFilter
    implements IOFileFilter {
        private String pattern;

        FilenamePatternFilter(String pattern) {
            this.pattern = pattern;
        }

        public boolean accept(File file) {
            String filename = file.getName();
            return filename.matches(this.pattern);
        }

        public boolean accept(File dir, String name) {
            return name.matches(this.pattern);
        }
    }
}

