/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.Record6;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.execution.LastExecutionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.VerifyingTestCaseDto;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.display.VerifyingTestCaseDisplayDao;

@Repository
public class VerifyingTestCaseDisplayDaoImpl
implements VerifyingTestCaseDisplayDao {
    private final RequirementDao requirementDao;
    private final DSLContext dsl;

    public VerifyingTestCaseDisplayDaoImpl(DSLContext dsl, RequirementDao requirementDao) {
        this.dsl = dsl;
        this.requirementDao = requirementDao;
    }

    @Override
    public List<VerifyingTestCaseDto> findByRequirementVersionIds(Set<Long> requirementVersionIds) {
        SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> milestoneDates = this.getMilestoneDates();
        List verifyingTestCaseDtos = this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID.as("ID"), (SelectField)Tables.TEST_CASE.REFERENCE, (SelectField)Tables.TEST_CASE.TC_STATUS.as("STATUS"), (SelectField)Tables.TEST_CASE.IMPORTANCE, (SelectField)Tables.TEST_CASE.EXECUTION_MODE, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)DSL.field((String)"MILESTONE_LABELS"), (SelectField)DSL.field((String)"MILESTONE_MIN_DATE"), (SelectField)DSL.field((String)"MILESTONE_MAX_DATE")).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).leftJoin(milestoneDates).on(milestoneDates.field("ID", Long.class).eq((Field)Tables.TEST_CASE.TCLN_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.in(requirementVersionIds)).fetchInto(VerifyingTestCaseDto.class);
        if (!verifyingTestCaseDtos.isEmpty()) {
            this.appendLastExecutionData(verifyingTestCaseDtos);
        }
        return verifyingTestCaseDtos;
    }

    @Override
    public List<VerifyingTestCaseDto> findByHighLevelRequirementVersionId(Long highLevelRequirementVersionId) {
        List<VerifyingTestCaseDto> directlyLinkedVerifyingTestCases = this.findByRequirementVersionIds(new HashSet<Long>(Collections.singletonList(highLevelRequirementVersionId)));
        Long highLevelRequirementId = this.requirementDao.findRequirementIdFromVersionId(highLevelRequirementVersionId);
        Set<Long> linkedRequirementIds = this.findLinkedLowLevelRequirementIds(highLevelRequirementId);
        if (linkedRequirementIds.isEmpty()) {
            return directlyLinkedVerifyingTestCases;
        }
        List<Long> descendantIds = this.requirementDao.findDescendantRequirementIds(new ArrayList<Long>(linkedRequirementIds));
        linkedRequirementIds.addAll(descendantIds);
        Set<Long> linkedRequirementCurrentVersionIds = this.requirementDao.findRequirementCurrentVersionIdsFromRequirementIds(linkedRequirementIds);
        List<VerifyingTestCaseDto> lowLevelReqVerifyingTestCases = this.findByRequirementVersionIds(linkedRequirementCurrentVersionIds);
        lowLevelReqVerifyingTestCases.forEach(testCase -> testCase.setDirectlyLinked(false));
        return Stream.concat(directlyLinkedVerifyingTestCases.stream(), lowLevelReqVerifyingTestCases.stream()).toList();
    }

    private Set<Long> findLinkedLowLevelRequirementIds(Long requirementId) {
        return this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).where(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Object)requirementId)).fetchSet((Field)Tables.REQUIREMENT.RLN_ID);
    }

    private SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> getMilestoneDates() {
        return DSL.select((SelectField)Tables.TEST_CASE.TCLN_ID.as("ID"), (SelectField)DSL.min((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MIN_DATE"), (SelectField)DSL.max((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MAX_DATE"), (SelectField)DSL.listAgg((Field)Tables.MILESTONE.LABEL, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.MILESTONE.END_DATE.asc()}).as("MILESTONE_LABELS")).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).groupBy(new GroupField[]{Tables.TEST_CASE.TCLN_ID, Tables.MILESTONE_TEST_CASE.TEST_CASE_ID});
    }

    private void appendLastExecutionData(List<VerifyingTestCaseDto> verifyingTestCaseDtos) {
        Map<Long, LastExecutionDto> lastExecutionDtoByTclnId = this.getLastExecutionDtoByTclnId(verifyingTestCaseDtos);
        verifyingTestCaseDtos.forEach(verifyingTestCaseDto -> {
            LastExecutionDto lastExecutionDto = (LastExecutionDto)lastExecutionDtoByTclnId.get(verifyingTestCaseDto.getId());
            if (Objects.nonNull(lastExecutionDto)) {
                verifyingTestCaseDto.setLastExecutionStatus(lastExecutionDto.executionStatus());
                verifyingTestCaseDto.setLatestExecutionId(lastExecutionDto.executionId());
                verifyingTestCaseDto.setLastExecutedOn(lastExecutionDto.lastExecutedOn());
            }
        });
    }

    private SelectHavingStep<Record2<Long, Timestamp>> getLastExecutedOnDate(Collection<Long> testCaseIds) {
        return this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)DSL.max((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON).as("MAX_LAST_EXECUTED_ON")).from((TableLike)Tables.TEST_PLAN_ITEM).where(Tables.TEST_PLAN_ITEM.TCLN_ID.in(testCaseIds)).groupBy(new GroupField[]{Tables.TEST_PLAN_ITEM.TCLN_ID});
    }

    private Map<Long, LastExecutionDto> getLastExecutionDtoByTclnId(List<VerifyingTestCaseDto> verifyingTestCaseDtos) {
        if (verifyingTestCaseDtos.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, LastExecutionDto> resultMap = new HashMap<Long, LastExecutionDto>();
        Map<Long, String> testCaseModes = verifyingTestCaseDtos.stream().collect(Collectors.toMap(VerifyingTestCaseDto::getId, VerifyingTestCaseDto::getExecutionMode, (existing, replacement) -> existing));
        this.fetchLastExecutionIntoMapByTclnId(resultMap, testCaseModes);
        return resultMap;
    }

    private void fetchLastExecutionIntoMapByTclnId(Map<Long, LastExecutionDto> resultMap, Map<Long, String> testCaseModes) {
        Set<Long> testCaseIds = testCaseModes.keySet();
        SelectHavingStep<Record2<Long, Timestamp>> tpiLastExecutedOnDate = this.getLastExecutedOnDate(testCaseIds);
        SelectConditionStep<Record4<Long, Timestamp, Long, Integer>> maxLastExecuted = this.getMaxLastExecutionData(testCaseIds);
        Stream results = this.dsl.selectDistinct((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)maxLastExecuted.field("EXECUTION_ID", Long.class).as("EXECUTION_ID"), (SelectField)maxLastExecuted.field("LAST_EXECUTED_ON", Timestamp.class).as("LAST_EXECUTED_ON"), (SelectField)Tables.TEST_PLAN_ITEM.OVERVIEW_ID, (SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, (SelectField)tpiLastExecutedOnDate.field("MAX_LAST_EXECUTED_ON", Timestamp.class).as("MAX_LAST_EXECUTED_ON")).from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin(tpiLastExecutedOnDate).on(tpiLastExecutedOnDate.field("TCLN_ID", Long.class).eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID).and(tpiLastExecutedOnDate.field("MAX_LAST_EXECUTED_ON", Timestamp.class).eq((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON))).leftJoin(maxLastExecuted).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(maxLastExecuted.field("TEST_PLAN_ITEM_ID", Long.class)).and(maxLastExecuted.field("ROW_NUMBER", Integer.class).eq((Object)1))).where(Tables.TEST_PLAN_ITEM.TCLN_ID.in(testCaseIds)).fetchStream();
        this.parseLastExecutionResultsIntoMapByTclnId(resultMap, results, testCaseModes);
    }

    private SelectConditionStep<Record4<Long, Timestamp, Long, Integer>> getMaxLastExecutionData(Set<Long> testCaseIds) {
        return DSL.select((SelectField)Tables.EXECUTION.TEST_PLAN_ITEM_ID.as("TEST_PLAN_ITEM_ID"), (SelectField)Tables.EXECUTION.LAST_EXECUTED_ON.as("LAST_EXECUTED_ON"), (SelectField)Tables.EXECUTION.EXECUTION_ID.as("EXECUTION_ID"), (SelectField)DSL.rowNumber().over().partitionBy(new GroupField[]{Tables.EXECUTION.TEST_PLAN_ITEM_ID}).orderBy(new OrderField[]{Tables.EXECUTION.EXECUTION_ORDER.desc()}).as("ROW_NUMBER")).from((TableLike)Tables.TEST_PLAN_ITEM).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.TEST_PLAN_ITEM.TCLN_ID.in(testCaseIds));
    }

    private void parseLastExecutionResultsIntoMapByTclnId(Map<Long, LastExecutionDto> resultMap, Stream<Record6<Long, Long, Timestamp, Long, String, Timestamp>> results, Map<Long, String> testCaseModes) {
        results.forEach(r -> {
            Long executionId;
            Long tclnId = (Long)r.get((Field)Tables.TEST_PLAN_ITEM.TCLN_ID);
            Timestamp tpiLastExecutedOn = (Timestamp)r.get("MAX_LAST_EXECUTED_ON", Timestamp.class);
            Timestamp executionLastExecutedOn = (Timestamp)r.get("LAST_EXECUTED_ON", Timestamp.class);
            String mode = (String)testCaseModes.get(tclnId);
            Long l = executionId = TestCaseExecutionMode.EXPLORATORY.name().equals(mode) ? (Long)r.get((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID) : (Long)r.get("EXECUTION_ID", Long.class);
            if (executionId != null && executionLastExecutedOn != null && !tpiLastExecutedOn.equals(executionLastExecutedOn)) {
                executionId = null;
            }
            resultMap.putIfAbsent(tclnId, new LastExecutionDto(executionId, (String)r.get((Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS), tpiLastExecutedOn));
        });
    }
}

