/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.PagingAndMultiSorting;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.service.internal.dto.AutomatedSuiteDto;
import org.squashtest.tm.service.testautomation.AutomationDeletionCount;
import org.squashtest.tm.service.testautomation.model.AutomatedSuitePreview;

public interface AutomatedSuiteDao {
    public AutomatedSuite save(AutomatedSuite var1);

    public void delete(AutomatedSuite var1);

    public void delete(Long var1);

    public AutomatedSuite createNewSuite();

    public AutomatedSuite createNewSuite(Iteration var1);

    public AutomatedSuite createNewSuite(TestSuite var1);

    public AutomatedSuite findById(Long var1);

    public Optional<AutomatedSuite> findByUuid(String var1);

    public List<AutomatedSuite> findAll();

    public List<AutomatedSuite> findAllByIds(Collection<Long> var1);

    public List<Couple<TestAutomationProject, Long>> findAllCalledByTestPlan(EntityReference var1, Collection<Long> var2, @Nullable Long var3);

    public List<String> findTestPathForAutomatedSuiteAndProject(EntityReference var1, Collection<Long> var2, long var3, @Nullable Long var5);

    public Collection<AutomatedExecutionExtender> findAllExtenders(Long var1);

    public Collection<AutomatedExecutionExtender> findAllWaitingExtenders(Long var1);

    public Collection<AutomatedExecutionExtender> findAllRunningExtenders(Long var1);

    public Collection<AutomatedExecutionExtender> findAllCompletedExtenders(Long var1);

    public Collection<AutomatedExecutionExtender> findAllExtendersByStatus(Long var1, Collection<ExecutionStatus> var2);

    public List<AutomatedExecutionExtender> findAndFetchForAutomatedExecutionCreation(Long var1);

    public List<AutomatedSuiteDto> findAutomatedSuitesByIterationID(Long var1, PagingAndMultiSorting var2, ColumnFiltering var3);

    public long countSuitesByIterationId(Long var1, ColumnFiltering var2);

    public List<AutomatedSuiteDto> findAutomatedSuitesByTestSuiteID(Long var1, PagingAndMultiSorting var2, ColumnFiltering var3);

    public long countSuitesByTestSuiteId(Long var1, ColumnFiltering var2);

    public ExecutionStatusReport getStatusReport(Long var1);

    public List<Long> getOldAutomatedSuiteIds();

    public void deleteAllByIds(List<Long> var1);

    public AutomationDeletionCount countOldAutomatedSuitesAndExecutions();

    public AutomationDeletionCount countOldAutomatedSuitesAndExecutionsByProjectId(Long var1);

    public List<Long> getOldAutomatedSuiteIdsByProjectId(Long var1);

    public boolean itpiSelectionContainsSquashAutomTest(EntityReference var1, List<Long> var2);

    public Map<Long, AutomatedSuitePreview.SquashAutomProjectPreview> findAllSquashAutomProjectPreviews(EntityReference var1, List<Long> var2, @Nullable Long var3);

    public List<Long> findAttachmentListIdsByIds(List<Long> var1);

    public AutomatedSuiteWorkflow getAutomatedSuiteWorkflowByWorkflowId(String var1);

    public Map<Long, List<AutomatedSuiteWorkflow>> getAutomatedSuiteWorkflowsBySuiteIds(List<Long> var1);

    public void deleteAutomatedSuiteWorkflowsBySuiteIds(List<Long> var1);

    public Map<Long, Long> getAutomatedExecutionIdsWithAttachmentListIds(List<Long> var1, boolean var2);

    public AutomatedSuite createNewSuiteWithLinkToTestSuite(TestSuite var1);

    public AutomatedSuite createNewSuiteWithLinkToIteration(Iteration var1);

    public AutomatedSuite findByIdWithExtenders(Long var1);

    public boolean isAutomatedSuiteCreatedByTestAutomationServerUser(Long var1);

    public AutomatedSuite load(Long var1);

    public void deleteApiTokensMatchingSuiteIds(List<Long> var1);
}

