/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.FolderPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.AttachmentPivotHolder;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.containerloader.ContainerLoader;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.containerloader.ContainerLoaderFactory;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.FolderPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.FolderPivotImporterService;

@Service
public class FolderPivotImporterServiceImpl
extends AbstractPivotImport
implements FolderPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderPivotImporterServiceImpl.class);
    private final AdminPivotConverterService adminPivotConverterService;
    private final AttachmentPivotImportService attachmentPivotImportService;
    private final FolderPivotConverterService folderPivotConverterService;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final ContainerLoaderFactory containerLoaderFactory;
    @PersistenceContext
    private EntityManager entityManager;

    public FolderPivotImporterServiceImpl(AdminPivotConverterService adminPivotConverterService, AttachmentPivotImportService attachmentPivotImportService, FolderPivotConverterService folderPivotConverterService, PrivateCustomFieldValueService customFieldValueService, ContainerLoaderFactory containerLoaderFactory) {
        super(LOGGER);
        this.adminPivotConverterService = adminPivotConverterService;
        this.attachmentPivotImportService = attachmentPivotImportService;
        this.folderPivotConverterService = folderPivotConverterService;
        this.customFieldValueService = customFieldValueService;
        this.containerLoaderFactory = containerLoaderFactory;
    }

    @Override
    public void importFoldersByJsonFileName(ZipFile zipFile, JsonImportFile jsonFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, jsonFile, pivotFormatImport, pivotImportMetadata, PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, true), PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, false), this.getFolderPivotImportStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<FolderPivot> getFolderPivotImportStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<FolderPivot>(){

            @Override
            public Class<FolderPivot> getPivotClazz() {
                return FolderPivot.class;
            }

            @Override
            public void create(List<FolderPivot> entities) {
                FolderPivotImporterServiceImpl.this.createFolders(entities, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createFolders(List<FolderPivot> folderPivotList, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.createEntities(folderPivotList, projectIdsReferences, pivotImportMetadata, this.containerLoaderFactory, this::mergeParentType, (folderPivot, containerLoader) -> this.createFolder((FolderPivot)folderPivot, (ContainerLoader)containerLoader, pivotImportMetadata, pivotFormatImport));
        this.handleCustomFields(this.customFieldValueService, pivotFormatImport, pivotImportMetadata);
        folderPivotList.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private EntityType mergeParentType(FolderPivot folderPivot) {
        EntityType parentType = folderPivot.getParentType();
        if (EntityType.SPRINT_GROUP.equals((Object)parentType)) {
            return EntityType.CAMPAIGN_FOLDER;
        }
        return parentType;
    }

    private <T extends NodeContainer<TreeNode> & TreeNode & AttachmentHolder> void createFolder(FolderPivot folderPivot, ContainerLoader containerLoader, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        NodeContainer container = containerLoader.getContainer(folderPivot);
        this.fixConflictNames(container, folderPivot.getName(), folderPivot::setName);
        NodeContainer folder = (NodeContainer)this.folderPivotConverterService.pivotToFolder(folderPivot);
        container.addContentWithoutSet((TreeNode)folder);
        this.entityManager.persist((Object)folder);
        this.handleAuditable(folderPivot, folder);
        this.handleAttachmentsCufs(folderPivot, folder, pivotFormatImport, pivotImportMetadata);
        this.getPivotIdConversionFromFolderKind(folderPivot.getKind(), pivotImportMetadata).put(folderPivot.getPivotId(), folder.getId());
        containerLoader.addContainer((NodeContainer<? extends TreeNode>)folder);
    }

    private Map<String, Long> getPivotIdConversionFromFolderKind(EntityType entityType, PivotImportMetadata pivotImportMetadata) {
        return switch (entityType) {
            case EntityType.REQUIREMENT_FOLDER -> pivotImportMetadata.getRequirementFolderIdByPivotId();
            case EntityType.TEST_CASE_FOLDER -> pivotImportMetadata.getTestCaseFolderIdByPivotId();
            case EntityType.CAMPAIGN_FOLDER, EntityType.SPRINT_GROUP -> pivotImportMetadata.getCampaignFolderIdByPivotId();
            default -> throw new IllegalArgumentException("Folder entity type not handled: " + String.valueOf(entityType));
        };
    }

    private <E extends AuditableMixin> void handleAuditable(FolderPivot folderPivot, E entity) {
        entity.setReadOnlyModifyAudit(folderPivot.getLastModifiedBy(), folderPivot.getLastModifiedOn());
        if (entity instanceof RequirementFolder) {
            RequirementFolder requirementFolder = (RequirementFolder)entity;
            requirementFolder.getResource().setReadOnlyModifyAudit(folderPivot.getLastModifiedBy(), folderPivot.getLastModifiedOn());
        }
    }

    private <ENTITY extends BoundEntity & AttachmentHolder> void handleAttachmentsCufs(FolderPivot folderPivot, ENTITY entity, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        Map<Long, Long> attachmentsConversion = this.handleAttachment(entity, folderPivot, pivotFormatImport, pivotImportMetadata);
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(folderPivot, entity, attachmentsConversion, pivotImportMetadata);
        pivotImportMetadata.getCufByEntity().put(entity, customFields);
    }

    private <ENTITY extends AttachmentHolder> Map<Long, Long> handleAttachment(ENTITY entity, FolderPivot folderPivot, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<ENTITY, FolderPivot>(folderPivot, entity), pivotImportMetadata, pivotFormatImport);
        ENTITY ENTITY = entity;
        Objects.requireNonNull(ENTITY);
        ENTITY ENTITY2 = ENTITY;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Folder.class, SprintGroup.class}, ENTITY2, 0)) {
            case 0: {
                Folder folder = (Folder)ENTITY2;
                String description = folder.getDescription();
                folder.setDescription(this.attachmentPivotImportService.updateRichText(description, folder.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
                break;
            }
            case 1: {
                SprintGroup sprintGroup = (SprintGroup)ENTITY2;
                String description = sprintGroup.getDescription();
                sprintGroup.setDescription(this.attachmentPivotImportService.updateRichText(description, sprintGroup.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported entity type %s for folder pivot %s", entity.getClass().getSimpleName(), folderPivot));
            }
        }
        return attachmentsConversion;
    }
}

