/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class RequirementVersionHasDescriptionFilterHandler
implements FilterHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"REQUIREMENT_VERSION_HAS_DESCRIPTION"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        HasDescriptionFilterValue filterValue = this.extractFilterValue(filter);
        QRequirementVersion outerVersion = QRequirementVersion.requirementVersion;
        QRequirementVersion initVersion = new QRequirementVersion("initVersion");
        HibernateQuery subquery = HasDescriptionFilterValue.NO_DESCRIPTION.equals((Object)filterValue) ? (HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)initVersion)).where((Predicate)initVersion.id.eq((Expression)outerVersion.id).and((Predicate)initVersion.description.isEmpty())) : (HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)initVersion)).where((Predicate)initVersion.id.eq((Expression)outerVersion.id).and((Predicate)initVersion.description.isNotEmpty()));
        query.where((Predicate)subquery.exists());
    }

    private HasDescriptionFilterValue extractFilterValue(GridFilterValue filter) {
        List<String> values = filter.getValues();
        if (values.size() != 1) {
            throw new IllegalArgumentException("Invalid value for filter REQUIREMENT_VERSION_HAS_DESCRIPTION");
        }
        return HasDescriptionFilterValue.valueOf(values.get(0));
    }

    public static enum HasDescriptionFilterValue {
        HAS_DESCRIPTION,
        NO_DESCRIPTION;

    }
}

