/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEventType;
import org.squashtest.tm.domain.execution.ExploratoryExecutionRunningState;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanGridHelpers;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class ExploratorySessionExecutionGrid
extends AbstractGrid {
    private static final String EXEC_ID = "EXEC_ID";
    private static final String ASSIGNEE = "ASSIGNEE";
    private static final String EXECUTOR = "EXECUTOR";
    private final Long overviewId;

    public ExploratorySessionExecutionGrid(Long overviewId) {
        this.overviewId = overviewId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)EXEC_ID).as("EXECUTION_ID")), new GridColumn(DSL.field((String)"LAST_EXECUTED_ON", Timestamp.class)), new GridColumn(DSL.field((String)"LAST_EXECUTED_BY_FULL_NAME")), new GridColumn(DSL.field((String)"EXECUTOR_LOGIN")), new GridColumn(DSL.field((String)"ASSIGNEE_ID")), new GridColumn(DSL.field((String)"ASSIGNEE_LOGIN")), new GridColumn(DSL.field((String)"ASSIGNEE_FULL_NAME")), new GridColumn(DSL.field((String)"TASK_DIVISION")), new GridColumn(DSL.field((String)"REVIEWED")), new GridColumn(DSL.field((String)"NOTE_TYPES")), new GridColumn(DSL.field((String)"EXECUTION_ORDER")), new GridColumn(DSL.field((String)"PROJECT_ID")), new GridColumn(this.countIssue().as("ISSUE_COUNT")), new GridColumn(DSL.field((String)"RUNNING_STATE")));
    }

    private Field<String> findSessionStatus() {
        return DSL.select((SelectField)DSL.when((Condition)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_TYPE.eq((Object)ExploratoryExecutionEventType.STOP.name()), (Object)ExploratoryExecutionRunningState.STOPPED.name()).otherwise(DSL.when((Condition)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_TYPE.in((Object[])new String[]{ExploratoryExecutionEventType.RESUME.name(), ExploratoryExecutionEventType.START.name(), ExploratoryExecutionEventType.PAUSE.name()}), (Object)ExploratoryExecutionRunningState.RUNNING.name()).otherwise((Object)ExploratoryExecutionRunningState.NEVER_STARTED.name())).as("RUNNING_STATE")).from((TableLike)Tables.EXPLORATORY_EXECUTION_EVENT).where(Tables.EXPLORATORY_EXECUTION_EVENT.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).orderBy((OrderField)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_DATE.desc()).limit((Number)1).asField();
    }

    private Field<Integer> countIssue() {
        return DSL.select((SelectField)DSL.countDistinct((Field)Tables.ISSUE.REMOTE_ISSUE_ID)).from((TableLike)Tables.ISSUE).innerJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID.eq((Field)Tables.ISSUE.ISSUE_ID)).where(DSL.field((String)EXEC_ID).eq((Object)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID)).asField("ISSUE_COUNT");
    }

    @Override
    protected Table<?> getTable() {
        CoreUser assigneeUser = Tables.CORE_USER.as(ASSIGNEE);
        CoreUser executorUser = Tables.CORE_USER.as(EXECUTOR);
        Field lastExecutedByName = TestPlanGridHelpers.formatAssigneeFullName(executorUser).as("LAST_EXECUTED_BY_FULL_NAME");
        Field assigneeFullName = TestPlanGridHelpers.formatAssigneeFullName(assigneeUser).as("ASSIGNEE_FULL_NAME");
        return DSL.select((SelectField)Tables.EXECUTION.EXECUTION_ID.as(EXEC_ID), (SelectField)Tables.EXECUTION.LAST_EXECUTED_ON, (SelectField)lastExecutedByName, (SelectField)executorUser.LOGIN.as("EXECUTOR_LOGIN"), (SelectField)Tables.EXPLORATORY_EXECUTION.ASSIGNEE_ID, (SelectField)Tables.EXPLORATORY_EXECUTION.TASK_DIVISION, (SelectField)assigneeUser.LOGIN.as("ASSIGNEE_LOGIN"), (SelectField)Tables.EXPLORATORY_EXECUTION.REVIEWED, (SelectField)Tables.EXECUTION.EXECUTION_ORDER, (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)DSL.groupConcat((Field)Tables.SESSION_NOTE.KIND).as("NOTE_TYPES"), (SelectField)assigneeFullName, (SelectField)DSL.coalesce(this.findSessionStatus(), (Object)ExploratoryExecutionRunningState.NEVER_STARTED.name()).as("RUNNING_STATE")).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CL_ID.eq((Field)Tables.TEST_PLAN.CL_ID)).innerJoin((TableLike)Tables.EXPLORATORY_EXECUTION).on(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.SESSION_NOTE).on(Tables.SESSION_NOTE.EXECUTION_ID.eq((Field)Tables.EXPLORATORY_EXECUTION.EXECUTION_ID)).leftJoin((TableLike)assigneeUser).on(assigneeUser.PARTY_ID.eq((Field)Tables.EXPLORATORY_EXECUTION.ASSIGNEE_ID)).leftJoin((TableLike)executorUser).on(Tables.EXECUTION.LAST_EXECUTED_BY.eq((Field)executorUser.LOGIN)).innerJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID).and(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)this.overviewId))).groupBy(new GroupField[]{Tables.EXECUTION.EXECUTION_ID, Tables.EXPLORATORY_EXECUTION.ASSIGNEE_ID, Tables.EXPLORATORY_EXECUTION.TASK_DIVISION, Tables.EXPLORATORY_EXECUTION.REVIEWED, Tables.EXECUTION.EXECUTION_ORDER, Tables.PROJECT.PROJECT_ID, assigneeUser.PARTY_ID, assigneeFullName, lastExecutedByName, executorUser.LOGIN}).asTable();
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"EXECUTION_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return DSL.field((String)"PROJECT_ID");
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.field((String)"EXECUTION_ORDER").asc();
    }
}

