/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.chart;

import com.querydsl.core.types.Order;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.chart.AxisColumn;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.chart.Filter;
import org.squashtest.tm.domain.chart.MeasureColumn;
import org.squashtest.tm.domain.chart.ScopeType;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.query.NaturalJoinStyle;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryAggregationColumn;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryFilterColumn;
import org.squashtest.tm.domain.query.QueryModel;
import org.squashtest.tm.domain.query.QueryOrderingColumn;
import org.squashtest.tm.domain.query.QueryProjectionColumn;
import org.squashtest.tm.domain.query.QueryStrategy;
import org.squashtest.tm.service.internal.repository.ColumnPrototypeDao;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;
import org.squashtest.tm.service.internal.repository.CustomReportDashboardDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.query.ConfiguredQuery;

@Component
@Scope(value="prototype")
class ChartToConfiguredQueryConverter {
    private static final List<EntityType> scopableEntityList = Arrays.asList(EntityType.ITERATION, EntityType.CAMPAIGN, EntityType.CAMPAIGN_FOLDER, EntityType.CAMPAIGN_LIBRARY, EntityType.PROJECT, EntityType.TEST_SUITE, EntityType.SPRINT, EntityType.SPRINT_GROUP);
    @Inject
    private ActiveMilestoneHolder milestoneHolder;
    @Inject
    private ColumnPrototypeDao columnPrototypeDao;
    @Inject
    private CustomReportDashboardDao dashboardDao;
    @Inject
    private CustomProjectFinder customProjectFinder;
    @Inject
    CustomItpiLastExecutionFilterDao customItpiLastExecutionFilterDao;
    private ChartDefinition definition;
    private Long dashboardId;
    private List<EntityReference> customScope;
    private Long milestoneId;
    private Workspace workspace;
    private boolean campaignLastExecScope;

    ChartToConfiguredQueryConverter() {
    }

    ChartToConfiguredQueryConverter withDefinition(ChartDefinition definition) {
        this.definition = definition;
        return this;
    }

    ChartToConfiguredQueryConverter disableMilestones() {
        this.milestoneId = null;
        return this;
    }

    ChartToConfiguredQueryConverter forMilestone(Long milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    ChartToConfiguredQueryConverter forWorkspace(Workspace workspace) {
        this.workspace = workspace;
        return this;
    }

    ChartToConfiguredQueryConverter forCurrentActiveMilestone() {
        Optional<Milestone> maybeMilestone = this.milestoneHolder.getActiveMilestone();
        this.milestoneId = maybeMilestone.isPresent() ? maybeMilestone.get().getId() : null;
        return this;
    }

    ChartToConfiguredQueryConverter forAutoScope() {
        this.customScope = null;
        return this;
    }

    ChartToConfiguredQueryConverter forDynamicScope(List<EntityReference> customScope) {
        this.customScope = customScope;
        return this;
    }

    ChartToConfiguredQueryConverter scopedForAllProjects() {
        List<Long> readableProjectIds = this.customProjectFinder.findAllReadableIds();
        ArrayList<EntityReference> entityReferences = new ArrayList<EntityReference>();
        for (Long readableProjectId : readableProjectIds) {
            entityReferences.add(new EntityReference(EntityType.PROJECT, readableProjectId));
        }
        this.customScope = entityReferences;
        return this;
    }

    ChartToConfiguredQueryConverter forDashboard(Long dashboardId) {
        this.dashboardId = dashboardId;
        return this;
    }

    ChartToConfiguredQueryConverter forScopeFilter(boolean campaignLastExecScope) {
        this.campaignLastExecScope = campaignLastExecScope;
        return this;
    }

    ConfiguredQuery convert() {
        QueryModel queryModel = this.createBaseQueryModel();
        if (this.shouldFilterByMilestones()) {
            QueryFilterColumn milestoneFilter = this.createMilestoneFilter();
            queryModel.getFilterColumns().add(milestoneFilter);
        }
        List<EntityReference> scope = this.resolveScope();
        if (this.campaignLastExecScope) {
            this.createLastExecScopeFilter(scope, queryModel);
        }
        if (this.shouldFilterByLastExecutedBy(queryModel)) {
            this.createLastExecutedByFilter(queryModel);
        }
        ConfiguredQuery newQuery = new ConfiguredQuery();
        newQuery.setQueryModel(queryModel);
        newQuery.setScope(scope);
        return newQuery;
    }

    private QueryModel createBaseQueryModel() {
        QueryModel query = new QueryModel();
        query.setStrategy(QueryStrategy.MAIN);
        query.setJoinStyle(NaturalJoinStyle.INNER_JOIN);
        List<QueryProjectionColumn> projections = this.extractProjections(this.definition);
        query.setProjectionColumns(projections);
        List<QueryAggregationColumn> aggregations = this.extractAggregations(this.definition);
        query.setAggregationColumns(aggregations);
        List<QueryFilterColumn> filters = this.extractFilters(this.definition);
        query.setFilterColumns(filters);
        List<QueryOrderingColumn> ordering = this.extractOrdering(this.definition);
        query.setOrderingColumns(ordering);
        return query;
    }

    private List<QueryProjectionColumn> extractProjections(ChartDefinition definition) {
        ArrayList<QueryProjectionColumn> projections = new ArrayList<QueryProjectionColumn>();
        List axes = definition.getAxis();
        axes.stream().map(this::toProjectionColumn).forEachOrdered(projections::add);
        List measures = definition.getMeasures();
        measures.stream().map(this::toProjectionColumn).forEachOrdered(projections::add);
        return projections;
    }

    private List<QueryAggregationColumn> extractAggregations(ChartDefinition definition) {
        List axes = definition.getAxis();
        return new ArrayList<QueryAggregationColumn>(axes.stream().map(this::toAggregationColumn).toList());
    }

    private List<QueryFilterColumn> extractFilters(ChartDefinition definition) {
        List chartFilters = definition.getFilters();
        return new ArrayList<QueryFilterColumn>(chartFilters.stream().map(this::toQueryFilterColumn).toList());
    }

    private List<QueryOrderingColumn> extractOrdering(ChartDefinition definition) {
        List axes = definition.getAxis();
        return new ArrayList<QueryOrderingColumn>(axes.stream().map(this::toOrderingColumn).toList());
    }

    private QueryProjectionColumn toProjectionColumn(AxisColumn axis) {
        QueryProjectionColumn projection = new QueryProjectionColumn();
        projection.setLabel(axis.getLabel());
        projection.setOperation(axis.getOperation());
        projection.setColumnPrototype(axis.getColumn());
        projection.setCufId(axis.getCufId());
        return projection;
    }

    private QueryProjectionColumn toProjectionColumn(MeasureColumn measure) {
        QueryProjectionColumn projection = new QueryProjectionColumn();
        projection.setLabel(measure.getLabel());
        projection.setColumnPrototype(measure.getColumn());
        projection.setOperation(measure.getOperation());
        projection.setCufId(measure.getCufId());
        return projection;
    }

    private QueryAggregationColumn toAggregationColumn(AxisColumn axis) {
        QueryAggregationColumn aggregation = new QueryAggregationColumn();
        aggregation.setLabel(axis.getLabel());
        aggregation.setOperation(axis.getOperation());
        aggregation.setColumnPrototype(axis.getColumn());
        aggregation.setCufId(axis.getCufId());
        return aggregation;
    }

    private QueryFilterColumn toQueryFilterColumn(Filter chartFilter) {
        QueryFilterColumn queryFilter = new QueryFilterColumn();
        queryFilter.setColumn(chartFilter.getColumn());
        queryFilter.setOperation(chartFilter.getOperation());
        queryFilter.setCufId(chartFilter.getCufId());
        queryFilter.getValues().addAll(chartFilter.getValues());
        return queryFilter;
    }

    private QueryOrderingColumn toOrderingColumn(AxisColumn axis) {
        QueryOrderingColumn order = new QueryOrderingColumn();
        order.setOrder(Order.ASC);
        order.setColumnPrototype(axis.getColumn());
        order.setOperation(axis.getOperation());
        order.setCufId(axis.getCufId());
        return order;
    }

    private boolean shouldFilterByMilestones() {
        return this.milestoneId != null && this.workspace != null && Workspace.isWorkspaceMilestoneFilterable((Workspace)this.workspace);
    }

    private QueryFilterColumn createMilestoneFilter() {
        QueryFilterColumn filter = new QueryFilterColumn();
        QueryColumnPrototype columnPrototype = null;
        switch (this.workspace) {
            case TEST_CASE: {
                columnPrototype = this.columnPrototypeDao.findByLabel("TEST_CASE_MILESTONE_ID");
                break;
            }
            case REQUIREMENT: {
                columnPrototype = this.columnPrototypeDao.findByLabel("REQUIREMENT_VERSION_MILESTONE_ID");
                break;
            }
            case CAMPAIGN: {
                columnPrototype = this.columnPrototypeDao.findByLabel("CAMPAIGN_MILESTONE_ID");
                break;
            }
        }
        filter.setColumn(columnPrototype);
        filter.setOperation(Operation.EQUALS);
        filter.getValues().add(this.milestoneId.toString());
        return filter;
    }

    private boolean shouldFilterByLastExecutedBy(QueryModel queryModel) {
        return queryModel.getProjectionColumns().stream().anyMatch(col -> col.getColumn().getLabel().equals("ITEM_TEST_PLAN_LASTEXECBY"));
    }

    private void createLastExecutedByFilter(QueryModel queryModel) {
        QueryColumnPrototype columnPrototype = this.columnPrototypeDao.findByLabel("ITEM_TEST_PLAN_LASTEXECBY");
        QueryFilterColumn filter = new QueryFilterColumn();
        filter.setColumn(columnPrototype);
        filter.setOperation(Operation.NOT_NULL);
        filter.addValues(List.of("True"));
        queryModel.getFilterColumns().add(filter);
    }

    private void createLastExecScopeFilter(List<EntityReference> scope, QueryModel queryModel) {
        EnumMap<EntityType, List<Long>> scopableEntitiesMap = new EnumMap<EntityType, List<Long>>(EntityType.class);
        scopableEntityList.forEach(entityType -> this.extractEntityIdsFromScope(scope, (Map<EntityType, List<Long>>)scopableEntitiesMap, (EntityType)entityType));
        List<String> filteredItpiIds = this.customItpiLastExecutionFilterDao.gatherLatestItpiIdsForTCInDynamicScope(scopableEntitiesMap).stream().map(String::valueOf).toList();
        if (!filteredItpiIds.isEmpty()) {
            QueryFilterColumn lastExecScopeFilter = this.getFilterColumn(filteredItpiIds);
            queryModel.getFilterColumns().add(lastExecScopeFilter);
        }
    }

    private void extractEntityIdsFromScope(List<EntityReference> scope, Map<EntityType, List<Long>> scopableEntitiesMap, EntityType entityType) {
        List<Long> scopedEntityIds = scope.stream().filter(scopedEntity -> scopedEntity.getType().equals((Object)entityType)).map(EntityReference::getId).toList();
        if (!scopedEntityIds.isEmpty()) {
            scopableEntitiesMap.put(entityType, scopedEntityIds);
        }
    }

    private QueryFilterColumn getFilterColumn(List<String> filteredItpiIds) {
        QueryFilterColumn lastExecFilter = new QueryFilterColumn();
        QueryColumnPrototype prototype = this.columnPrototypeDao.findByLabel("ITEM_TEST_PLAN_ID");
        lastExecFilter.setColumn(prototype);
        lastExecFilter.setOperation(Operation.IN);
        lastExecFilter.addValues(filteredItpiIds);
        return lastExecFilter;
    }

    private boolean hasDynamicScope() {
        return this.customScope != null && !this.customScope.isEmpty();
    }

    private boolean useChartProjectAsScope() {
        return this.definition.getScopeType() == ScopeType.DEFAULT && this.dashboardId == null && Objects.nonNull(this.definition.getProject());
    }

    private boolean useDashboardProjectAsScope() {
        return this.definition.getScopeType() == ScopeType.DEFAULT && this.dashboardId != null;
    }

    private List<EntityReference> resolveScope() {
        List<Object> finalScope = new ArrayList();
        if (this.hasDynamicScope()) {
            finalScope = this.customScope;
        } else if (this.useDashboardProjectAsScope()) {
            CustomReportDashboard dashboard = (CustomReportDashboard)this.dashboardDao.getReferenceById(this.dashboardId);
            EntityReference projectReference = new EntityReference(EntityType.PROJECT, dashboard.getProject().getId());
            finalScope.add(projectReference);
        } else if (this.useChartProjectAsScope()) {
            EntityReference projectReference = new EntityReference(EntityType.PROJECT, this.definition.getProject().getId());
            finalScope.add(projectReference);
        } else {
            finalScope = this.definition.getScope();
        }
        return finalScope;
    }
}

