/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ReflectionUtils;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.service.internal.batchimport.excel.NullMandatoryValueException;
import org.squashtest.tm.service.internal.batchimport.excel.PropertySetter;

public final class ReflectionMutatorSetter<VAL, TARGET>
implements PropertySetter<VAL, TARGET> {
    private final String mutatorName;
    private final Class<?> paramType;
    private final boolean optionalValue;
    private Method mutator;

    private ReflectionMutatorSetter(@NotNull String fieldName, Class<VAL> paramType, boolean optionalValue) {
        this.mutatorName = "set" + StringUtils.capitalize((String)fieldName);
        this.paramType = paramType;
        this.optionalValue = optionalValue;
    }

    public static <V, T> ReflectionMutatorSetter<V, T> forProperty(@NotNull String propName, Class<V> paramType) {
        String string = propName;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return new ReflectionMutatorSetter(propName, paramType, false);
    }

    public static <V, T> ReflectionMutatorSetter<V, T> forOptionalProperty(@NotNull String propName) {
        String string = propName;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return new ReflectionMutatorSetter(propName, null, true);
    }

    public static <V, T> ReflectionMutatorSetter<V, T> forOptionalProperty(@NotNull String propName, Class<V> paramType) {
        String string = propName;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return new ReflectionMutatorSetter(propName, paramType, true);
    }

    @Override
    public void set(VAL value, TARGET target) {
        if (this.optionalValue && value == null) {
            return;
        }
        if (!this.optionalValue && value == null) {
            throw new NullMandatoryValueException(this.mutatorName);
        }
        if (this.mutator == null) {
            this.mutator = ReflectionUtils.findMethod(target.getClass(), (String)this.mutatorName, (Class[])new Class[]{this.paramType(value)});
            if (this.mutator == null) {
                throw new IllegalStateException("Could not find method named '" + this.mutatorName + "(" + String.valueOf(this.paramType(value)) + ")' in object of type '" + String.valueOf(target.getClass()) + "'. Maybe you mistyped field name.");
            }
            this.mutator.setAccessible(true);
        }
        ReflectionUtils.invokeMethod((Method)this.mutator, target, (Object[])new Object[]{value});
    }

    private Class<?> paramType(VAL value) {
        return this.paramType != null ? this.paramType : value.getClass();
    }
}

