/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.testingstatus;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatistics;

public class RemoteRequirementStatisticsDictionary {
    public final Map<RemoteKeyAndServerId, Map<Long, RemoteRequirementStatistics>> combinedStats;
    public final Map<RemoteKeyAndServerId, RemoteRequirementStatistics> mergedStats;

    public RemoteRequirementStatisticsDictionary(Map<RemoteKeyAndServerId, Map<Long, RemoteRequirementStatistics>> combinedStats, Map<RemoteKeyAndServerId, RemoteRequirementStatistics> mergedStats) {
        this.combinedStats = combinedStats;
        this.mergedStats = mergedStats;
    }

    public boolean hasStatsForServerAndRemoteKey(Long serverId, String remoteKey) {
        RemoteKeyAndServerId key = new RemoteKeyAndServerId(remoteKey, serverId);
        return this.combinedStats.containsKey(key);
    }

    public Map<Long, RemoteRequirementStatistics> getStatsByRequirementId(Long serverId, String remoteKey) {
        RemoteKeyAndServerId key = new RemoteKeyAndServerId(remoteKey, serverId);
        return this.combinedStats.get(key);
    }

    public Set<Long> getRequirementIdsForRemote(Long serverId, String remoteKey) {
        if (this.hasStatsForServerAndRemoteKey(serverId, remoteKey)) {
            return this.getStatsByRequirementId(serverId, remoteKey).keySet();
        }
        return Collections.emptySet();
    }

    public RemoteRequirementStatistics getMergedStatistics(Long serverId, String remoteKey) {
        RemoteKeyAndServerId key = new RemoteKeyAndServerId(remoteKey, serverId);
        return this.mergedStats.get(key);
    }

    public static class RemoteKeyAndServerId {
        public final String remoteKey;
        public final Long serverId;

        public RemoteKeyAndServerId(String remoteKey, Long serverId) {
            this.remoteKey = remoteKey;
            this.serverId = serverId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteKeyAndServerId that = (RemoteKeyAndServerId)o;
            return Objects.equal((Object)this.remoteKey, (Object)that.remoteKey) && Objects.equal((Object)this.serverId, (Object)that.serverId);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.remoteKey, this.serverId});
        }
    }
}

