/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.helpers;

import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class WorkspaceStatisticsHelper {
    public static final int SQL_IN_CLAUSE_ITEMS_LIMIT = 6000;

    private WorkspaceStatisticsHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<Object, Integer> retrieveAllStatisticsResultPartitionsIntoMap(String queryString, boolean isNativeQuery, String parameterName, Collection<Long> entityIds, EntityManager entityManager) {
        List<List<Object[]>> partitionResults = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitions(entityManager, entityIds, queryString, isNativeQuery, parameterName);
        return WorkspaceStatisticsHelper.retrieveStatisticsIntoMap(partitionResults);
    }

    public static List<List<Object[]>> retrieveAllStatisticsResultPartitions(EntityManager entityManager, Collection<Long> entityIds, String queryString, boolean isNativeQuery, String parameterName) {
        List partitionsIds = Lists.partition(new ArrayList<Long>(entityIds), (int)6000);
        ArrayList<List<Object[]>> partitionResults = new ArrayList<List<Object[]>>();
        for (List partitionIds : partitionsIds) {
            Query query = isNativeQuery ? entityManager.createNativeQuery(queryString) : entityManager.createNamedQuery(queryString);
            query.setParameter(parameterName, (Object)partitionIds);
            partitionResults.add(query.getResultList());
        }
        return partitionResults;
    }

    private static Map<Object, Integer> retrieveStatisticsIntoMap(List<List<Object[]>> partitionResults) {
        Map<Object, Integer> statisticsMap = new HashMap<Object, Integer>();
        for (List<Object[]> partitionResult : partitionResults) {
            statisticsMap = WorkspaceStatisticsHelper.doRetrieveStatisticsIntoMap(statisticsMap, partitionResult);
        }
        return statisticsMap;
    }

    private static Map<Object, Integer> doRetrieveStatisticsIntoMap(Map<Object, Integer> statisticsMap, List<Object[]> partitionResult) {
        Map<Object, Integer> partitionResultMap = partitionResult.stream().collect(Collectors.toMap(tuple -> tuple[0], tuple -> ((Long)tuple[1]).intValue()));
        return statisticsMap.isEmpty() ? partitionResultMap : WorkspaceStatisticsHelper.mergeIntoFinalMap(partitionResultMap, statisticsMap);
    }

    private static Map<Object, Integer> mergeIntoFinalMap(Map<Object, Integer> partitionResultMap, Map<Object, Integer> statisticsMap) {
        partitionResultMap.forEach((k, v) -> {
            Integer n = statisticsMap.merge(k, (Integer)v, Integer::sum);
        });
        return statisticsMap;
    }
}

